//TODO: Please, refactor me!

unit CtrlPanelZdvt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ZdvhCtrl, ExtCtrls, StdCtrls, VisZdvt, Buttons;

type
  TCtrlPanelZdvtForm = class(TForm)
    Panel1: TPanel;
    Timer: TTimer;
    NamePanel: TPanel;
    Label2: TLabel;
    DatPanel: TPanel;
    AlarmShape: TShape;
    btnBlok: TSpeedButton;
    SostPanel: TPanel;
    Panel2: TPanel;
    Label4: TLabel;
    cmbControl: TComboBox;
    ChannelPanel: TPanel;
    ChnlListBox: TListBox;
    btChnlClose: TButton;
    procedure FormActivate(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BlokButtonClick(Sender: TObject);
    procedure btChnlCloseClick(Sender: TObject);
    procedure ChannelLabelClick(Sender: TObject);
    procedure ChnlListBoxDblClick(Sender: TObject);
    procedure ChnlListBoxKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure cmbControlChange(Sender: TObject);
    procedure Init;
    procedure NamePanelClick(Sender: TObject);
    procedure Process;
  private
    FMessageTag: string;

    FSost: integer;
    FControl: integer;
    FBlok: integer;
    FChannel: array of integer;

    FTagSost: integer;
    FTagControl: integer;
    FTagBlok: integer;
    FTagChannel: array of integer;
  public
    M: TVisZdvt;
  end;

var
  CtrlPanelZdvtForm: TCtrlPanelZdvtForm;

implementation
uses
  UserControlEx,
  users,
  MesConst,
  TagStorage,
  DatSetPanel,
  MesLogging,
  SetChannel,
  ZdvSetPanel,
  numbers,
  RpVisualUtils;

{$R *.DFM}

procedure TCtrlPanelZdvtForm.FormActivate(Sender: TObject);
begin
  Init;
  Timer.Enabled := true;
end;



procedure TCtrlPanelZdvtForm.TimerTimer(Sender: TObject);
begin
  Process;
end;



procedure TCtrlPanelZdvtForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Timer.Enabled := false;
end;


///////////////////////////


procedure TCtrlPanelZdvtForm.Init;
var
  s,ss: string;
  i: integer;
begin
  NamePanel.Caption := M.DeviceName;

  s := M.TagPath + '.ZDVT_' + M.TagName + '_Sost';
  FTagSost := GetTagIndex(s);
  s := M.TagPath + '.ZDVT_' + M.TagName + '_Control';
  FTagControl := GetTagIndex(s);
  s := M.TagPath + '.ZDVT_' + M.TagName + '_Blok';
  FMessageTag := M.DeviceName;
  FTagBlok := GetTagIndex(s);

  SetLength(FChannel, M.DirCount*2);
  SetLength(FTagChannel, M.DirCount*2);

  ss := '      ';
  cmbControl.Items.Clear;
  cmbControl.Items.Add(ss+'');

  ChnlListBox.Items.Clear;

  for i:=0 to M.DirCount-1 do begin
    s := format('%s.ZDVT_%s_Chnl%dOut', [M.TagPath, M.TagName, i+1]);
    FTagChannel[i*2] := GetTagIndex(s);
    FChannel[i*2] := -1;

    s := format('%s.ZDVT_%s_Chnl%dIn', [M.TagPath, M.TagName, i+1]);
    FTagChannel[i*2+1] := GetTagIndex(s);
    FChannel[i*2+1] := -1;

    cmbControl.Items.Add(format('    %s', [M.Dir[i].Name]));
    ChnlListBox.Items.Add(format('%s -:  ', [M.Dir[i].Name]));
    ChnlListBox.Items.Add(format('%s  :  ', [M.Dir[i].Name]));
  end;

{
  if cmbControl.Items.Count=2 then begin
    cmbControl.Items[1] := '    ';
    cmbControl.Items.Add('    ');
  end;
}  

  FBlok := -1;
  FControl := -1;
  FSost := -1;

  Process;
end;



procedure TCtrlPanelZdvtForm.Process;
var
  i, value: integer;
begin

  value := GetTagValue( FTagSost );
  if value <> FSost then begin

    if (Value and $7F)=0 then
      SostPanel.Caption := ''
    else
    if (Value<$FE) and ((Value and $7F)-1<M.DirCount) then
      SostPanel.Caption := M.Dir[(Value and $7F)-1].Name;

    FSost := value;
  end;

  if (FSost and $80) = 0 then
    AlarmShape.Brush.Color := clBtnFace
  else
    if AlarmShape.Brush.Color = clRed then
      AlarmShape.Brush.Color := clBtnFace
    else
      AlarmShape.Brush.Color := clRed;

  value := GetTagValue( FTagControl );
  if (value <> FControl) then begin
    if value < cmbControl.Items.Count then cmbControl.ItemIndex := value;
    FControl := value;
  end;

  value := GetTagValue( FTagBlok );
  if value <> FBlok then begin
    if value > 0 then begin
         btnBlok.Caption:='';
         btnBlok.Down := true;
         btnBlok.Font.Style := [fsBold];
    end else begin
         btnBlok.Caption:='';
         btnBlok.Down := false;
         btnBlok.Font.Style := [];
    end;
    FBlok := value;
  end;

  for i:=0 to length(FChannel)-1 do begin
    value := GetTagValue( FTagChannel[i] );
    if value <> FChannel[i] then begin
      ChnlListBox.Items[i] := copy(ChnlListBox.Items[i], 1,
          pos(':', ChnlListBox.Items[i])+1) +
          IntToStr(value shr 8) + '-' +
          IntToStr(value and $7F) + iif((value and $80)>0, 'f','');
      FChannel[i] := value;
    end;
  end;

end;    



procedure TCtrlPanelZdvtForm.NamePanelClick(Sender: TObject);
begin
  ZdvSetPanelForm.DeviceName := M.DeviceName;
  ZdvSetPanelForm.DelayTagName := '';
  ZdvSetPanelForm.SostTagName := M.TagPath + '.ZDVT_' + M.TagName + '_Sost';
  ZdvSetPanelForm.MessageTagName := FMessageTag;
  ZdvSetPanelForm.ShowModal;
end;



procedure TCtrlPanelZdvtForm.ChannelLabelClick(Sender: TObject);
begin
  ChannelPanel.Visible := not ChannelPanel.Visible;
end;



procedure TCtrlPanelZdvtForm.ChnlListBoxDblClick(Sender: TObject);
begin
  if ChnlListBox.ItemIndex >= 0 then begin
    SetChannelForm.Channel := FChannel[ChnlListBox.ItemIndex];
    SetChannelForm.DeviceName := M.DeviceName + ' ' + inttostr(ChnlListBox.ItemIndex);

    if SetChannelForm.ShowModal = mrOk then begin

      SaveMessageText(mcSetChannel_text, FMessageTag,
          IntToStr(SetChannelForm.Channel shr 8) + '-' +
          IntToStr(SetChannelForm.Channel and $7F) +
          iif((SetChannelForm.Channel and $80)>0, 'f',''), mcSetChannel_bc, mcSetChannel_fc);
      SetTagValue( FTagChannel[ChnlListBox.ItemIndex],
          SetChannelForm.Channel );
    end;
  end;
end;



procedure TCtrlPanelZdvtForm.btChnlCloseClick(Sender: TObject);
begin
  ChannelPanel.Visible := false;
end;



procedure TCtrlPanelZdvtForm.cmbControlChange(Sender: TObject);
begin
  SaveMessageText(mcMode_text, FMessageTag, iif(cmbControl.ItemIndex>0, '.' +
      inttostr(cmbControl.ItemIndex), ''), mcMode_bc, mcMode_fc);
  ChangeComboBox( cmbControl, FTagControl, $FF);
end;



procedure TCtrlPanelZdvtForm.ChnlListBoxKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = 13 then ChnlListBoxDblClick(nil);
end;



procedure TCtrlPanelZdvtForm.BlokButtonClick(Sender: TObject);
var
  Can:Boolean;
begin
  //  

  if isModeUserEx then
    Can := isPermitted(M.ClassName + '~' + M.DeviceName + '~')
  else
    Can := CheckAccess(PREVILEG_BLOK, true);
  if Can then
  begin
     if GetTagValue(FTagBlok) = 0 then
     begin
         SaveMessageText(mcBlok_text, FMessageTag, '', mcBlok_bc, mcBlok_fc);
         btnBlok.Caption:='';
         btnBlok.Down := true;
         btnBlok.Font.Style := [fsBold];
     end
     else
     begin
         SaveMessageText(mcBlok_text, FMessageTag, '', mcBlok_bc, mcBlok_fc);
         btnBlok.Caption:='';
         btnBlok.Down := false;
         btnBlok.Font.Style := [];
     end;
  //  
         SetTagValue( FTagBlok, (GetTagValue(FTagBlok) xor 1) );
  end
  else
  begin
    //btnBlok.Down:=bState;
  end;
end;

end.
