// DEPRECATED !!!

unit DatCtrl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons;

type
  TDatCtrlFrame = class(TFrame)
    NamePanel: TPanel;
    DatPanel: TPanel;
    AlarmShape: TShape;
    InpPanel: TPanel;
    ChannelLabel: TLabel;
    Label2: TLabel;
    BlokButton: TSpeedButton;
    procedure NamePanelClick(Sender: TObject);
    procedure ChannelLabelClick(Sender: TObject);
    procedure BlokButtonClick(Sender: TObject);
  private
    FOutput: integer;
    FAlarm: integer;
    FBlok: integer;
    FInpValue: integer;
    FChannel: integer;

    FTagOutput: integer;
    FTagAlarm: integer;
    FTagBlok: integer;
    FTagInpValue: integer;
    FTagChannel: integer;
  public
    TagName: string;
    TagPath: string;
    DatName: string;
    DatFullName: string;
    Flashing: boolean;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  MesConst, TagStorage, DatSetPanel, MesLogging, SetChannel, numbers;

{$R *.DFM}

{ TDatCtrlFrame }

procedure TDatCtrlFrame.Init;
var
  s: string;
begin
  NamePanel.Caption := DatName;

  s := TagPath + '.RKSV_' + TagName + '_Output';
  FTagOutput := GetTagIndex(s);
  s := TagPath + '.RKSV_' + TagName + '_Alarm';
  FTagAlarm := GetTagIndex(s);
  s := TagPath + '.RKSV_' + TagName + '_Blok';
  FTagBlok := GetTagIndex(s);
  s := TagPath + '.RKSV_' + TagName + '_InpValue';
  FTagInpValue := GetTagIndex(s);
  s := TagPath + '.RKSV_' + TagName + '_Channel';
  FTagChannel := GetTagIndex(s);

  FOutput := -1;
  FBlok := -1;
  FInpValue := -1;
  FChannel := -1;

  Process;
end;

procedure TDatCtrlFrame.Process;
var
  value: integer;
begin

  value := GetTagValue( FTagInpValue );
  if value <> FInpValue then begin
    InpPanel.Caption := IntToStr(value);// + ' ';
    FInpValue := value;
  end;

  value := GetTagValue( FTagOutput );
  if value <> FOutput then begin
    if value > 0 then
      AlarmShape.Brush.Color := clRed
    else
      AlarmShape.Brush.Color := clBtnFace;

    FOutput := value;
  end;

  value := GetTagValue( FTagAlarm );
  if value <> FAlarm then begin
    if value > 0 then
      InpPanel.Font.Color := clRed
    else
      InpPanel.Font.Color := clBlack;
    FAlarm := value;
  end;


  value := GetTagValue( FTagBlok );
  if value <> FBlok then begin
    if value > 0 then begin
      BlokButton.Down := true;
      BlokButton.Font.Style := [fsBold];
    end else begin
      BlokButton.Down := false;
      BlokButton.Font.Style := [];
    end;
    FBlok := value;
  end;

  value := GetTagValue( FTagChannel );
  if value <> FChannel then begin
    ChannelLabel.Caption := IntToStr(value shr 8) + '-' +
        IntToStr(value and $7F) + iif((value and $80)>0, 'f','');
    FChannel := value;
  end;

  if (FOutput > 0) and (Flashing) then
    if AlarmShape.Brush.Color = clRed then
      AlarmShape.Brush.Color := clBtnFace
    else
      AlarmShape.Brush.Color := clRed;
end;




procedure TDatCtrlFrame.NamePanelClick(Sender: TObject);
var
  DatSetPanelForm: TDatSetPanelForm;
begin
  DatSetPanelForm := TDatSetPanelForm.Create(self);
  DatSetPanelForm.DatName := DatFullName;
  DatSetPanelForm.TagName := TagName;
  DatSetPanelForm.TagPath := TagPath;
  DatSetPanelForm.ShowModal;
  DatSetPanelForm.Free;
end;

procedure TDatCtrlFrame.ChannelLabelClick(Sender: TObject);
begin
  SetChannelForm.Channel := FChannel;
  SetChannelForm.DeviceName := DatFullName;
  if SetChannelForm.ShowModal = mrOk then begin
    SaveMessageText(mcSetChannel_text, GetTagName(FTagAlarm),
        IntToStr(SetChannelForm.Channel shr 8) + '-' +
        IntToStr(SetChannelForm.Channel and $7F) +
        iif((SetChannelForm.Channel and $80)>0, 'f',''), mcSetChannel_bc, mcSetChannel_fc);

    SetTagValue( FTagChannel, SetChannelForm.Channel );
  end;

end;

procedure TDatCtrlFrame.BlokButtonClick(Sender: TObject);
begin
  //  
  if GetTagValue(FTagBlok) = 0 then
    SaveMessageText(mcBlok_text, GetTagName(FTagAlarm), '', mcBlok_bc, mcBlok_fc)
  else
    SaveMessageText(mcBlok_text, GetTagName(FTagAlarm), '', mcBlok_bc, mcBlok_fc);
  //  
  SetTagValue( FTagBlok, (GetTagValue(FTagBlok) xor 1) );
end;

end.
