// DEPRECATED !!!

unit DevCtrl;

interface

uses 
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons;

type
  TDevCtrlFrame = class(TFrame)
    PhasePanel: TPanel;
    SostPanel: TPanel;
    NamePanel: TPanel;
    Panel1: TPanel;
    AutoButton: TSpeedButton;
    Label4: TLabel;
    Panel2: TPanel;
    AlarmShape: TShape;
    ChannelLabel: TLabel;
    Label2: TLabel;
    StartButton: TSpeedButton;
    StopButton: TSpeedButton;
    Label5: TLabel;
    BlokButton: TSpeedButton;
    procedure AutoButtonClick(Sender: TObject);
    procedure StartButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure PhasePanelClick(Sender: TObject);
    procedure ChannelLabelClick(Sender: TObject);
    procedure BlokButtonClick(Sender: TObject);
  private
    FSost: integer;
    FBlok: integer;
    FAlarm: integer;
    FChannel: integer;
    FControl: integer;
    FTagMachSost: integer;
    FTagMachBlok: integer;
    FTagMachAlarm: integer;
    FTagMachChannel: integer;
    FTagMctlControl: integer;
  public
    TagName: string;
    TagPath: string;
    DeviceName: string;
    ChannelName: string;
    DevTypeMCTL: string;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  MesConst, TagStorage, DevSetPanel, MesLogging, SetChannel, numbers;

{$R *.DFM}

{ TDevCtrlFrame }

procedure TDevCtrlFrame.Init;
var
  s: string;
begin
  if DevTypeMCTL='' then DevTypeMCTL:='MCTL';
  
  NamePanel.Caption := DeviceName;
  ChannelLabel.Caption := ChannelName;

  s := TagPath + '.MACH_' + TagName + '_Sost';
  FTagMachSost := GetTagIndex(s);
  s := TagPath + '.MACH_' + TagName + '_Blok';
  FTagMachBlok := GetTagIndex(s);
  s := TagPath + '.MACH_' + TagName + '_Alarm';
  FTagMachAlarm := GetTagIndex(s);
  s := TagPath + '.' + DevTypeMCTL + '_' + TagName + '_Control';
  FTagMctlControl := GetTagIndex(s);
  s := TagPath + '.MACH_' + TagName + '_Channel';
  FTagMachChannel := GetTagIndex(s);

  FSost := -1;
  FBlok := -1;
  FAlarm := -1;
  FControl := -1;
  FChannel := -1;

  Process;
end;

procedure TDevCtrlFrame.Process;
var
  value: integer;
begin

  value := GetTagValue( FTagMachSost );
  if value <> FSost then begin
    case value of
      0: SostPanel.Caption := '';
      1: SostPanel.Caption := '';
      2: SostPanel.Caption := '';
      3: SostPanel.Caption := '';
      4: SostPanel.Caption := '!';
      5: SostPanel.Caption := '';
      6: SostPanel.Caption := '---';
      7: SostPanel.Caption := ' (=1)';
      8: SostPanel.Caption := '  ???';
    else
      SostPanel.Caption := '';
    end;
    FSost := value;
  end;


  value := GetTagValue( FTagMctlControl ) and 3;
  if value <> FControl then begin
    if (value and 1) = 0 then begin
      AutoButton.Down := true;
      AutoButton.Font.Style := [fsBold];
    end else begin
      AutoButton.Down := false;
      AutoButton.Font.Style := [];
    end;

    if value=3 then begin
      StartButton.Down := true;
      StartButton.Font.Style := [fsBold];
    end else begin
      StartButton.Down := false;
      StartButton.Font.Style := [];
    end;

    if value=1 then begin
      StopButton.Down := true;
      StopButton.Font.Style := [fsBold];
    end else begin
      StopButton.Down := false;
      StopButton.Font.Style := [];
    end;

    FControl := value;
  end;



  value := GetTagValue( FTagMachAlarm );
  if value <> FAlarm then begin
    if value > 0 then
      AlarmShape.Brush.Color := clRed
    else
      AlarmShape.Brush.Color := clBtnFace;

    FAlarm := value;
  end;


  value := GetTagValue( FTagMachBlok );
  if value <> FBlok then begin
    if value > 0 then begin
      BlokButton.Down := true;
      BlokButton.Font.Style := [fsBold];
    end else begin
      BlokButton.Down := false;
      BlokButton.Font.Style := [];
    end;

    FBlok := value;
  end;

  value := GetTagValue( FTagMachChannel );
  if value <> FChannel then begin
    ChannelLabel.Caption := IntToStr(value shr 8) + '-' +
        IntToStr(value and $7F) + iif((value and $80)>0, 'f','');
//  IntToStr(value shr 8) + '-' + IntToStr(value and $FF);
    FChannel := value;
  end;

  if FAlarm > 0 then
    if AlarmShape.Brush.Color = clRed then
      AlarmShape.Brush.Color := clBtnFace
    else
      AlarmShape.Brush.Color := clRed;

end;

//============================================================================
//  /
//============================================================================
procedure TDevCtrlFrame.AutoButtonClick(Sender: TObject);
begin
  //  
  SaveMessageText(mcMode_text, GetTagName(FTagMachAlarm), '', mcMode_bc, mcMode_fc);
  //  
  SetTagValue( FTagMctlControl, 0);
end;

procedure TDevCtrlFrame.StartButtonClick(Sender: TObject);
begin
  if MessageDlg('!    ?',
      mtConfirmation, [mbYes, mbNo], 0) <> mrYes then begin
    FControl := -1;
    exit;
  end;

  //  
  SaveMessageText(mcMode_text, GetTagName(FTagMachAlarm), ' - ', mcMode_bc, mcMode_fc);
  //  
  SetTagValue( FTagMctlControl, 3);
end;

procedure TDevCtrlFrame.StopButtonClick(Sender: TObject);
begin
  //  
  SaveMessageText(mcMode_text, GetTagName(FTagMachAlarm), ' - ', mcMode_bc, mcMode_fc);
  //  
  SetTagValue( FTagMctlControl, 1);
end;

//============================================================================
//    
//============================================================================
procedure TDevCtrlFrame.PhasePanelClick(Sender: TObject);
var
  DevSetPanelForm: TDevSetPanelForm;
begin
  DevSetPanelForm := TDevSetPanelForm.Create(self);
  DevSetPanelForm.DeviceName := DeviceName;
  DevSetPanelForm.TagName := TagName;
  DevSetPanelForm.TagPath := TagPath;
  DevSetPanelForm.ShowModal;
  DevSetPanelForm.Free;
end;

procedure TDevCtrlFrame.ChannelLabelClick(Sender: TObject);
begin
  SetChannelForm.Channel := FChannel;
  SetChannelForm.DeviceName := DeviceName;
  if SetChannelForm.ShowModal = mrOk then begin
    SaveMessageText(mcSetChannel_text, GetTagName(FTagMachAlarm),
        IntToStr(SetChannelForm.Channel shr 8) + '-' +
        IntToStr(SetChannelForm.Channel and $7F) +
        iif((SetChannelForm.Channel and $80)>0, 'f',''), mcSetChannel_bc, mcSetChannel_fc);
//        IntToStr(SetChannelForm.Channel shr 8) + '-' +
//        IntToStr(SetChannelForm.Channel and $FF));
    SetTagValue( FTagMachChannel, SetChannelForm.Channel );
  end;
end;

procedure TDevCtrlFrame.BlokButtonClick(Sender: TObject);
begin
  //  
  if GetTagValue(FTagMachBlok) = 0 then
    SaveMessageText(mcBlok_text, GetTagName(FTagMachAlarm), '', mcBlok_bc, mcBlok_fc)
  else
    SaveMessageText(mcBlok_text, GetTagName(FTagMachAlarm), '', mcBlok_bc, mcBlok_fc);

  //  
  SetTagValue( FTagMachBlok, (GetTagValue(FTagMachBlok) xor 1) );
end;

end.
