// DEPRECATED !!!

unit MarshCtrl;

interface

uses 
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TMarshCtrlFrame = class(TFrame)
    SostPanel: TPanel;
    NamePanel: TPanel;
    StartButton: TSpeedButton;
    StopButton: TSpeedButton;
    procedure StartButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
  private
    FBntInput: integer;
    FBitStop: integer;
    FTrigOn: integer;
    FTrigOff: integer;
    FTagBntInput: integer;
    FTagBitStop: integer;
    FTagTrigOn: integer;
    FTagTrigOff: integer;
  public
    MarshName: string;
    TagBtnInput: string;
    TagBitStop: string;
    TagTrigOn: string;
    TagTrigOff: string;

    TagTrigOnIdx: integer;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  MesConst, TagStorage, MesLogging;

{$R *.DFM}
procedure TMarshCtrlFrame.Init;
var
  s: string;
begin
  NamePanel.Caption := MarshName;

  FTagBntInput := GetTagIndex(TagBtnInput);
  FTagBitStop := GetTagIndex(TagBitStop);
  FTagTrigOn := GetTagIndex(TagTrigOn);
  FTagTrigOff := GetTagIndex(TagTrigOff);

  TagTrigOnIdx := FTagTrigOn;

  FBntInput := -1;
  FBitStop := -1;
  FTrigOn := -1;
  FTrigOff := -1;

  Process;
end;

procedure TMarshCtrlFrame.Process;
var
  value: integer;
  SostChanged: boolean;
begin
  SostChanged := false;

  value := GetTagValue( FTagBntInput );
  if value <> FBntInput then begin
//  if (value > 0) xor (StartButton.Down) then begin
    StartButton.Down := (value > 0);
    FBntInput := value;
    SostChanged := true;
  end;

  value := GetTagValue( FTagBitStop );
  if value <> FBitStop then begin
//  if (value > 0) xor (StopButton.Down) then begin
    StopButton.Down := (value > 0);
    FBitStop := value;
    SostChanged := true;
  end;

  value := GetTagValue( FTagTrigOn );
  if value <> FTrigOn then begin
    if value > 0 then
      NamePanel.Color := clLime
    else
      NamePanel.Color := clAqua;
    FTrigOn := value;
    SostChanged := true;
  end;

  value := GetTagValue( FTagTrigOff );
  if value <> FTrigOff then begin
    FTrigOff := value;
    SostChanged := true;
  end;

  if SostChanged then begin
    if (FBntInput=0) and (FTrigOn=0) and (FTrigOff=0) then
      SostPanel.Caption := ''
    else
    if (FBntInput=0) and (FTrigOn>0) and (FTrigOff=0) then
      SostPanel.Caption := ''
    else
    if (FBntInput>0) and (FTrigOn=0) and (FTrigOff=0) then
      SostPanel.Caption := ' ...'
    else
    if (FBntInput>0) and (FTrigOn>0) and (FTrigOff=0) then
      SostPanel.Caption := '...'
    else
      SostPanel.Caption := '...';
  end;

end;


procedure TMarshCtrlFrame.StartButtonClick(Sender: TObject);
begin
  if GetTagValue(FTagBntInput) = 0 then
    SaveMessageText(mcMStart_text, GetTagName(FTagBntInput), '', mcMStart_bc, mcMStart_fc)
  else
    SaveMessageText(mcMStart_text, GetTagName(FTagBntInput), ' ', mcMStart_bc, mcMStart_fc);

  SetTagValue( FTagBntInput, (GetTagValue(FTagBntInput) xor 1) );
//  FBntInput := -1;
end;

procedure TMarshCtrlFrame.StopButtonClick(Sender: TObject);
begin
  if GetTagValue(FTagBitStop) = 0 then
    SaveMessageText(mcMStop_text, GetTagName(FTagBntInput), '', mcMStop_bc, mcMStop_fc);

  SetTagValue( FTagBitStop, (GetTagValue(FTagBitStop) xor 1) );
//  FBitStop := -1;
end;

end.
