// DEPRECATED !!!

unit MchaCtrl;

interface

uses 
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, VisMcha;

type
  TMchaCtrlFrame = class(TFrame)
    PhasePanel: TPanel;
    SostPanel: TPanel;
    NamePanel: TPanel;
    Panel1: TPanel;
    AutoButton: TSpeedButton;
    Label4: TLabel;
    Panel2: TPanel;
    AlarmShape: TShape;
    ChannelLabel: TLabel;
    Label2: TLabel;
    StartButton: TSpeedButton;
    StopButton: TSpeedButton;
    Label5: TLabel;
    BlokButton: TSpeedButton;
    procedure AutoButtonClick(Sender: TObject);
    procedure StartButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure PhasePanelClick(Sender: TObject);
    procedure ChannelLabelClick(Sender: TObject);
    procedure BlokButtonClick(Sender: TObject);
  private
    FSost: integer;
    FBlok: integer;
    FChannel: integer;
    FControl: integer;
    FTagMchaSost: integer;
    FTagMchaBlok: integer;
    FTagMchaChannel: integer;
    FTagMchaControl: integer;

    FMessageTagName: string;
  public
    M: TVisMcha;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  RpVisualUtils,
  MesConst,
  TagStorage,
  MchaSetPanel,
  MesLogging,
  SetChannel,
  numbers;

{$R *.DFM}

{ TMchaCtrlFrame }

procedure TMchaCtrlFrame.Init;
var
  s, _tagname: string;
begin
  _tagname := M.expandTagname;
  NamePanel.Caption := M.DeviceName;
//  FMessageTagName := M.TagPath + '.MCHA' + M.TagName;
  FMessageTagName := M.DeviceName;

  s := M.TagPath + '.MCHA_' + _tagname + '_Sost';
  FTagMchaSost := GetTagIndex(s);
  s := M.TagPath + '.MCHA_' + _tagname + '_Blok';
  FTagMchaBlok := GetTagIndex(s);
  s := M.TagPath + '.MCHA_' + _tagname + '_Control';
  FTagMchaControl := GetTagIndex(s);
  s := M.TagPath + '.MCHA_' + _tagname + '_Channel';
  FTagMchaChannel := GetTagIndex(s);

  FSost := -1;
  FBlok := -1;
  FControl := -1;
  FChannel := -1;

  Process;
end;

procedure TMchaCtrlFrame.Process;
var
  value: integer;
begin

  value := GetTagValue( FTagMchaSost );
  if value <> FSost then begin
    case value of
      0: SostPanel.Caption := '';
      1: SostPanel.Caption := '';
      2: SostPanel.Caption := '';
      3: SostPanel.Caption := '';
      4: SostPanel.Caption := '!';
      5: SostPanel.Caption := '';
      7: SostPanel.Caption := ' (=1)';
      8: SostPanel.Caption := '  ???';
    else
      SostPanel.Caption := '';
    end;
    FSost := value;

    if value = 4 then
      AlarmShape.Brush.Color := clRed
    else
      AlarmShape.Brush.Color := clBtnFace;
  end;


  value := GetTagValue( FTagMchaControl ) and 3;
  if value <> FControl then begin
    if (value and 1) = 0 then begin
      AutoButton.Down := true;
      AutoButton.Font.Style := [fsBold];
    end else begin
      AutoButton.Down := false;
      AutoButton.Font.Style := [];
    end;

    if value=3 then begin
      StartButton.Down := true;
      StartButton.Font.Style := [fsBold];
    end else begin
      StartButton.Down := false;
      StartButton.Font.Style := [];
    end;

    if value=1 then begin
      StopButton.Down := true;
      StopButton.Font.Style := [fsBold];
    end else begin
      StopButton.Down := false;
      StopButton.Font.Style := [];
    end;

    FControl := value;
  end;



  value := GetTagValue( FTagMchaBlok );
  if value <> FBlok then begin
    if value > 0 then begin
      BlokButton.Down := true;
      BlokButton.Font.Style := [fsBold];
    end else begin
      BlokButton.Down := false;
      BlokButton.Font.Style := [];
    end;

    FBlok := value;
  end;

  value := GetTagValue( FTagMchaChannel );
  if value <> FChannel then begin
    ChannelLabel.Caption := GetStringChannelName(value); //IntToStr(value shr 8) + '-' + IntToStr(value and $7F) + iif((value and $80)>0, 'f','');
    FChannel := value;
  end;

end;

//============================================================================
//  /
//============================================================================
procedure TMchaCtrlFrame.AutoButtonClick(Sender: TObject);
begin
  SaveMessageText(mcMode_text, FMessageTagName, '', mcMode_bc, mcMode_fc);
  SetTagValue( FTagMchaControl, 0);
end;

procedure TMchaCtrlFrame.StartButtonClick(Sender: TObject);
begin
  if MessageDlg('!    ?',
      mtConfirmation, [mbYes, mbNo], 0) <> mrYes then begin
    FControl := -1;
    exit;
  end;

  SaveMessageText(mcMode_text, FMessageTagName, ' - ', mcMode_bc, mcMode_fc);
  SetTagValue( FTagMchaControl, 3);
end;

procedure TMchaCtrlFrame.StopButtonClick(Sender: TObject);
begin
  SaveMessageText(mcMode_text, FMessageTagName, ' - ', mcMode_bc, mcMode_fc);
  SetTagValue( FTagMchaControl, 1);
end;

//============================================================================
//    
//============================================================================
procedure TMchaCtrlFrame.PhasePanelClick(Sender: TObject);
var
  MchaSetPanelForm: TMchaSetPanelForm;
begin
  MchaSetPanelForm := TMchaSetPanelForm.Create(self);
  MchaSetPanelForm.M := M;
  MchaSetPanelForm.ShowModal;
  MchaSetPanelForm.Free;
end;

procedure TMchaCtrlFrame.ChannelLabelClick(Sender: TObject);
begin
  SetChannelForm.Channel := FChannel;
  SetChannelForm.DeviceName := M.DeviceName;
  if SetChannelForm.ShowModal = mrOk then begin
    SaveMessageText(mcSetChannel_text, FMessageTagName, GetStringChannelName(SetChannelForm.Channel), mcSetChannel_bc, mcSetChannel_fc );
    SetTagValue( FTagMchaChannel, SetChannelForm.Channel );
  end;
end;

procedure TMchaCtrlFrame.BlokButtonClick(Sender: TObject);
begin
  if GetTagValue(FTagMchaBlok) = 0 then
    SaveMessageText(mcBlok_text, FMessageTagName, '', mcBlok_bc, mcBlok_fc)
  else
    SaveMessageText(mcBlok_text, FMessageTagName, '', mcBlok_bc, mcBlok_fc);

  SetTagValue( FTagMchaBlok, (GetTagValue(FTagMchaBlok) xor 1) );
end;

end.
