// DEPRECATED !!!

unit MchbCtrl;

interface

uses 
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, VisMchb;

type
  TMchbCtrlFrame = class(TFrame)
    PhasePanel: TPanel;
    SostPanel: TPanel;
    NamePanel: TPanel;
    Panel1: TPanel;
    AutoButton: TSpeedButton;
    Label4: TLabel;
    Panel2: TPanel;
    AlarmShape: TShape;
    ChInLabel: TLabel;
    Label2: TLabel;
    StartButton: TSpeedButton;
    StopButton: TSpeedButton;
    Label5: TLabel;
    BlokButton: TSpeedButton;
    ChOutLabel: TLabel;
    Label3: TLabel;
    procedure AutoButtonClick(Sender: TObject);
    procedure StartButtonClick(Sender: TObject);
    procedure StopButtonClick(Sender: TObject);
    procedure PhasePanelClick(Sender: TObject);
    procedure ChInLabelClick(Sender: TObject);
    procedure BlokButtonClick(Sender: TObject);
    procedure ChOutLabelClick(Sender: TObject);
  private
    FSost: integer;
    FBlok: integer;
    FChIn: integer;
    FChOut: integer;
    FControl: integer;
    FFlags: integer;
    FTagMchbSost: integer;
    FTagMchbBlok: integer;
    FTagMchbChIn: integer;
    FTagMchbChOut: integer;
    FTagMchbControl: integer;
    FTagFlags: integer;

    FMessageTagName: string;
  public
    M: TVisMchb;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  RpVisualUtils,
  MesConst,
  TagStorage,
  MchbSetPanel,
  MesLogging,
  SetChannel,
  numbers;

{$R *.DFM}

{ TMchbCtrlFrame }

procedure TMchbCtrlFrame.Init;
var
  s: string;
begin
  NamePanel.Caption := M.DeviceName;
//  FMessageTagName := M.TagPath + '.Mchb' + M.TagName;
  FMessageTagName := M.DeviceName;

  s := M.TagPath + '.MCHB_' + M.TagName + '_Sost';
  FTagMchbSost := GetTagIndex(s);
  s := M.TagPath + '.MCHB_' + M.TagName + '_Blok';
  FTagMchbBlok := GetTagIndex(s);
  s := M.TagPath + '.MCHB_' + M.TagName + '_Control';
  FTagMchbControl := GetTagIndex(s);
  s := M.TagPath + '.MCHB_' + M.TagName + '_Channel1';
  FTagMchbChIn := GetTagIndex(s);
  s := M.TagPath + '.MCHB_' + M.TagName + '_Channel2';
  FTagMchbChOut := GetTagIndex(s);

  FTagFlags := GetTagIndex(M.TagPath + '.MCHB_' + M.TagName + '_Flags');

  FSost := -1;
  FBlok := -1;
  FControl := -1;
  FChIn := -1;
  FFlags := -1;

  Process;
end;

procedure TMchbCtrlFrame.Process;
var
  value: integer;
begin

  value := GetTagValue( FTagMchbSost );
  if value <> FSost then begin
    case value of
      0: SostPanel.Caption := '';
      1: SostPanel.Caption := '';
      2: SostPanel.Caption := '';
      3: SostPanel.Caption := '';
      4: SostPanel.Caption := '!';
      5: SostPanel.Caption := '';
      7: SostPanel.Caption := ' (=1)';
      8: SostPanel.Caption := '  ???';
    else
      SostPanel.Caption := '';
    end;
    FSost := value;

    if value = 4 then
      AlarmShape.Brush.Color := clRed
    else
      AlarmShape.Brush.Color := clBtnFace;
  end;


  value := GetTagValue( FTagMchbControl ) and 3;
  if value <> FControl then begin
    if (value and 1) = 0 then begin
      AutoButton.Down := true;
      AutoButton.Font.Style := [fsBold];
    end else begin
      AutoButton.Down := false;
      AutoButton.Font.Style := [];
    end;

    if value=3 then begin
      StartButton.Down := true;
      StartButton.Font.Style := [fsBold];
    end else begin
      StartButton.Down := false;
      StartButton.Font.Style := [];
    end;

    if value=1 then begin
      StopButton.Down := true;
      StopButton.Font.Style := [fsBold];
    end else begin
      StopButton.Down := false;
      StopButton.Font.Style := [];
    end;

    FControl := value;
  end;



  value := GetTagValue( FTagMchbBlok );
  if value <> FBlok then begin
    if value > 0 then begin
      BlokButton.Down := true;
      BlokButton.Font.Style := [fsBold];
    end else begin
      BlokButton.Down := false;
      BlokButton.Font.Style := [];
    end;

    FBlok := value;
  end;

  value := GetTagValue( FTagMchbChIn );
  if value <> FChIn then begin
    ChInLabel.Caption := GetStringChannelName(value); //IntToStr(value shr 8) + '-' + IntToStr(value and $7F) + iif((value and $80)>0, 'f','');
    FChIn := value;
  end;

  value := GetTagValue( FTagMchbChOut );
  if value <> FChOut then begin
    ChOutLabel.Caption := GetStringChannelName(value); //IntToStr(value shr 8) + '-' + IntToStr(value and $7F) + iif((value and $80)>0, 'f','');
    FChOut := value;
  end;

end;

//============================================================================
//  /
//============================================================================
procedure TMchbCtrlFrame.AutoButtonClick(Sender: TObject);
begin
  SaveMessageText(mcMode_text, FMessageTagName, '', mcMode_bc, mcMode_fc);
  SetTagValue( FTagMchbControl, 0);
end;

procedure TMchbCtrlFrame.StartButtonClick(Sender: TObject);
begin
  if MessageDlg('!    ?',
      mtConfirmation, [mbYes, mbNo], 0) <> mrYes then begin
    FControl := -1;
    exit;
  end;

  SaveMessageText(mcMode_text, FMessageTagName, ' - ', mcMode_bc, mcMode_fc);
  SetTagValue( FTagMchbControl, 3);
end;

procedure TMchbCtrlFrame.StopButtonClick(Sender: TObject);
begin
  SaveMessageText(mcMode_text, FMessageTagName, ' - ', mcMode_bc, mcMode_fc);
  SetTagValue( FTagMchbControl, 1);
end;

//============================================================================
//    
//============================================================================
procedure TMchbCtrlFrame.PhasePanelClick(Sender: TObject);
var
  MchbSetPanelForm: TMchbSetPanelForm;
begin
  MchbSetPanelForm := TMchbSetPanelForm.Create(self);
  MchbSetPanelForm.M := M;
  MchbSetPanelForm.ShowModal;
  MchbSetPanelForm.Free;
end;

procedure TMchbCtrlFrame.ChInLabelClick(Sender: TObject);
begin
  SetChannelForm.Channel := FChIn;
  SetChannelForm.DeviceName := M.DeviceName;
  if SetChannelForm.ShowModal = mrOk then begin
    SaveMessageText(mcSetChannel_text, FMessageTagName, GetStringChannelName(SetChannelForm.Channel), mcSetChannel_bc, mcSetChannel_fc );
    SetTagValue( FTagMchbChIn, SetChannelForm.Channel );
  end;
end;

procedure TMchbCtrlFrame.BlokButtonClick(Sender: TObject);
begin
  if GetTagValue(FTagMchbBlok) = 0 then
    SaveMessageText(mcBlok_text, FMessageTagName, '', mcBlok_bc, mcBlok_fc)
  else
    SaveMessageText(mcBlok_text, FMessageTagName, '', mcBlok_bc, mcBlok_fc);

  SetTagValue( FTagMchbBlok, (GetTagValue(FTagMchbBlok) xor 1) );
end;

procedure TMchbCtrlFrame.ChOutLabelClick(Sender: TObject);
begin
  SetChannelForm.Channel := FChOut;
  SetChannelForm.DeviceName := M.DeviceName;
  if SetChannelForm.ShowModal = mrOk then begin
    SaveMessageText(mcSetChannel_text, FMessageTagName, GetStringChannelName(SetChannelForm.Channel), mcSetChannel_bc, mcSetChannel_fc );
    SetTagValue( FTagMchbChOut, SetChannelForm.Channel );
  end;
end;

end.
