// DEPRECATED !!!

unit MdtaCtrl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, VisMcha;

type
  TMdtaCtrlFrame = class(TFrame)
    NamePanel: TPanel;
    DatPanel: TPanel;
    AlarmShape: TShape;
    InpPanel: TPanel;
    ChannelLabel: TLabel;
    Label2: TLabel;
    BlokButton: TSpeedButton;
    procedure NamePanelClick(Sender: TObject);
    procedure ChannelLabelClick(Sender: TObject);
    procedure BlokButtonClick(Sender: TObject);
  private
    FSost: integer;
    FBlok: integer;
    FValue: integer;
    FChannel: integer;

    FTagSost: integer;
    FTagBlok: integer;
    FTagValue: integer;
    FTagChannel: integer;

    FMessageTagName: string;

  public
    M: TVisMcha;
    DatIndex: integer;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  MesConst,
  TagStorage,
  MesLogging,
  SetChannel,
  numbers,
  RpVisualUtils,
  MdtaSetPanel;

{$R *.DFM}

{ TMdtaCtrlFrame }

procedure TMdtaCtrlFrame.Init;
var
  s, stag: string;
  _tagname: string;
begin

  _tagname := M.expandTagname;
  NamePanel.Caption := iif(M.OnlyDat, M.DeviceName + ' ', '') + M.Datchik[DatIndex].Name;
  FMessageTagName := iif(not M.OnlyDat, M.DeviceName + ' ', '') + M.Datchik[DatIndex].Name;;

  stag := M.TagPath + '.MDTA_' + _tagname + M.Datchik[DatIndex].TagPostfix;

  s := stag + '_Sost';
  FTagSost := GetTagIndex(s);
  s := stag + '_Blok';
  FTagBlok := GetTagIndex(s);
  s := stag + '_Value';
  FTagValue := GetTagIndex(s);
  s := stag + '_Channel';
  FTagChannel := GetTagIndex(s);

  FSost := -1;
  FBlok := -1;
  FValue := -1;
  FChannel := -1;

  Process;
end;

procedure TMdtaCtrlFrame.Process;
var
  value: integer;
begin

  value := GetTagValue( FTagValue );
  if value <> FValue then begin
    InpPanel.Caption := IntToStr(value);// + ' ';
    FValue := value;
  end;

  value := GetTagValue( FTagSost );
  if (value=0) and (AlarmShape.Brush.Color<>clBtnFace) then AlarmShape.Brush.Color := clBtnFace else
  if (value in [1,4]) and (AlarmShape.Brush.Color<>clYellow) then AlarmShape.Brush.Color := clYellow else
  if (value=2) and (AlarmShape.Brush.Color<>clRed) then AlarmShape.Brush.Color := clRed else
  if (value=3) then
    if (AlarmShape.Brush.Color=clRed) then
      AlarmShape.Brush.Color := clBtnFace
    else
      AlarmShape.Brush.Color := clRed;


  value := GetTagValue( FTagBlok );
  if value <> FBlok then begin
    if value > 0 then begin
      BlokButton.Down := true;
      BlokButton.Font.Style := [fsBold];
    end else begin
      BlokButton.Down := false;
      BlokButton.Font.Style := [];
    end;
    FBlok := value;
  end;

  value := GetTagValue( FTagChannel );
  if value <> FChannel then begin
    ChannelLabel.Caption := GetStringChannelName(value);
    FChannel := value;
  end;

end;


procedure TMdtaCtrlFrame.NamePanelClick(Sender: TObject);
var
  MdtaSetPanelForm: TMdtaSetPanelForm;
begin
  MdtaSetPanelForm := TMdtaSetPanelForm.Create(self);
  MdtaSetPanelForm.M := M;
  MdtaSetPanelForm.DatIndex := DatIndex;
  MdtaSetPanelForm.ShowModal;
  MdtaSetPanelForm.Free;
end;

procedure TMdtaCtrlFrame.ChannelLabelClick(Sender: TObject);
begin
  SetChannelForm.Channel := FChannel;
  SetChannelForm.DeviceName := M.DeviceName;
  if SetChannelForm.ShowModal = mrOk then begin
    SaveMessageText(mcSetChannel_text, FMessageTagName, GetStringChannelName(SetChannelForm.Channel) , mcSetChannel_bc, mcSetChannel_fc);
    SetTagValue( FTagChannel, SetChannelForm.Channel );
  end;
end;

procedure TMdtaCtrlFrame.BlokButtonClick(Sender: TObject);
begin
  if GetTagValue(FTagBlok) = 0 then
    SaveMessageText(mcBlok_text, FMessageTagName, '', mcBlok_bc, mcBlok_fc)
  else
    SaveMessageText(mcBlok_text, FMessageTagName, '', mcBlok_bc, mcBlok_fc);
    
  SetTagValue( FTagBlok, (GetTagValue(FTagBlok) xor 1) );  
end;

end.
