unit NotesCtrl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons;
                                   
type
  TNotesCtrlFrame = class(TFrame)
    Memo: TMemo;
    procedure MemoDblClick(Sender: TObject);
  private
  public
    TagName: string;
    procedure Init;
    procedure Process;
  end;

implementation
uses
  numbers,
  RpVisualGlobal,
  RpVisualUtils,
  inifiles,
  users;

{$R *.DFM}

{ TNotesCtrlFrame }

procedure TNotesCtrlFrame.Init;
var
  s,stext: string;
  F: TextFile;
  flag: boolean;
begin
  s := CurDir + 'rpvisual.not';

  if not FileExists( s ) then begin
    Memo.Lines.Clear;
    exit;
  end;

  AssignFile(F, s);
  reset(F);
  stext := '';
  flag := true;
  while not eof(F) do begin
    Readln(F, s);

    if flag then begin
      if s = '~'+TagName then flag := false;
    end else begin
      if copy(s,1,1)='~' then break;
      stext := stext + s + #13#10;
    end;
  end;
  CloseFile(F);

  Memo.Text := stext;
  if Memo.Lines.Count < 6 then
    Memo.ScrollBars := ssNone
  else
    Memo.ScrollBars := ssVertical;
end;

procedure TNotesCtrlFrame.Process;
begin

end;




procedure TNotesCtrlFrame.MemoDblClick(Sender: TObject);
var
  s,stext: string;
  i,k: integer;
  list: TStringList;
begin
  if Memo.Color = clBtnFace then begin
    if not CheckAccess(PREVILEG_NOTES_EDIT, true) then exit;

    Memo.Color := clWindow;
    Memo.ReadOnly := false;
    Memo.Modified := false;
    Memo.SelLength := 0;
    Memo.SelStart := 0;
    Memo.ScrollBars := ssVertical;

  end else begin

    if Memo.Modified then begin
      //    
      begin
        list := TStringList.Create;
        
        if FileExists( CurDir + 'rpvisual.not' ) then
          list.LoadFromFile(CurDir + 'rpvisual.not');

        stext := list.Text;
        repeat
          i := pos('~'+TagName+#13#10, stext);
          if i=0 then break;

          s := stext;
          delete(s, 1, i);
          k := pos('~', s);
          if k=0 then
            stext := copy(stext, 1, i-1)
          else
            delete(stext, i, k);

        until false;

        i:=0;
        while i<Memo.Lines.Count do
          if trim(Memo.Lines.Strings[i]) = '' then
            Memo.Lines.Delete(i)
          else
            inc(i);

        if Memo.Text = '' then
          list.Text := stext
        else
          list.Text := stext + '~'+Tagname + #13#10 + Memo.Text;
      
        list.SaveToFile(CurDir + 'rpvisual.not');

        list.Free;
      end;
      init;
    end;

    Memo.Color := clBtnFace;
    Memo.ReadOnly := true;
    Memo.SelLength := 0;
    Memo.SelStart := 0;
  end;
end;

end.
