// DEPRECATED !!!

unit ZdvcCtrl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons;

type
  TZdvcCtrlFrame = class(TFrame)
    NamePanel: TPanel;
    DatPanel: TPanel;
    AlarmShape: TShape;
    SostPanel: TPanel;
    BlokButton: TSpeedButton;
    Label2: TLabel;
    ChannelPanel: TPanel;
    ChnlListBox: TListBox;
    Button1: TButton;
    Panel1: TPanel;
    AutoButton: TSpeedButton;
    Label4: TLabel;
    StartButton: TSpeedButton;
    StopButton: TSpeedButton;
    Label5: TLabel;
    procedure NamePanelClick(Sender: TObject);
    procedure ChannelLabelClick(Sender: TObject);
    procedure BlokButtonClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ChnlListBoxDblClick(Sender: TObject);
    procedure StartButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure AutoButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StopButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    FSost: integer;
    FControl: integer;
    FAlarm: integer;
    FBlok: integer;
    FChannel: array of integer;

    FTagSost: integer;
    FTagControl: integer;
    FTagAlarm: integer;
    FTagBlok: integer;
    FTagChannel: array of integer;

    ChnlNumber: integer;
  public
    TagName: string;
    TagPath: string;
    DeviceName: string;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  MesConst, TagStorage, DatSetPanel, MesLogging, SetChannel, ZdvSetPanel, numbers;

{$R *.DFM}

{ TZdvcCtrlFrame }

procedure TZdvcCtrlFrame.Init;
var
  s: string;
begin
  ChnlNumber := 3;
  NamePanel.Caption := DeviceName;

  s := TagPath + '.ZDVC_' + TagName + '_Sost';
  FTagSost := GetTagIndex(s);
  s := TagPath + '.ZDVC_' + TagName + '_Control';
  FTagControl := GetTagIndex(s);
  s := TagPath + '.ZDVC_' + TagName + '_Alarm';
  FTagAlarm := GetTagIndex(s);
  s := TagPath + '.ZDVC_' + TagName + '_Blok';
  FTagBlok := GetTagIndex(s);

  SetLength(FChannel, ChnlNumber);
  SetLength(FTagChannel, ChnlNumber);

  s := TagPath + '.ZDVC_' + TagName + '_ChnlOut';
  FTagChannel[0] := GetTagIndex(s);
  s := TagPath + '.ZDVC_' + TagName + '_ChnlInA';
  FTagChannel[1] := GetTagIndex(s);
  s := TagPath + '.ZDVC_' + TagName + '_ChnlInB';
  FTagChannel[2] := GetTagIndex(s);

  FBlok := -1;
  FAlarm := -1;
  FControl := -1;
  FSost := -1;

  Process;
end;

procedure TZdvcCtrlFrame.Process;
var
  i, value: integer;
begin

  value := GetTagValue( FTagSost );
  if value <> FSost then begin
    case value of
      0: SostPanel.Caption := '';
      1: SostPanel.Caption := '';
      2: SostPanel.Caption := '';
      3: SostPanel.Caption := ' ';
      4: SostPanel.Caption := ' ';
      254: SostPanel.Caption := '?';
    end;
    FSost := value;
  end;

  value := GetTagValue( FTagControl );
  if (value <> FControl) then begin
    if value = 0 then begin
      AutoButton.Down := true;
      AutoButton.Font.Style := [fsBold];
    end else begin
      AutoButton.Down := false;
      AutoButton.Font.Style := [];
    end;

    if value=2 then begin
      StartButton.Down := true;
      StartButton.Font.Style := [fsBold];
    end else begin
      StartButton.Down := false;
      StartButton.Font.Style := [];
    end;

    if value=1 then begin
      StopButton.Down := true;
      StopButton.Font.Style := [fsBold];
    end else begin
      StopButton.Down := false;
      StopButton.Font.Style := [];
    end;

    FControl := value;
  end;

  value := GetTagValue( FTagAlarm );
  if (value <> FAlarm) or (value > 0) then begin
    if value = 0 then
      AlarmShape.Brush.Color := clBtnFace
    else
      if AlarmShape.Brush.Color = clRed then
        AlarmShape.Brush.Color := clBtnFace
      else
        AlarmShape.Brush.Color := clRed;
    FAlarm := value;
  end;


  value := GetTagValue( FTagBlok );
  if value <> FBlok then begin
    if value > 0 then begin
      BlokButton.Down := true;
      BlokButton.Font.Style := [fsBold];
    end else begin
      BlokButton.Down := false;
      BlokButton.Font.Style := [];
    end;
    FBlok := value;
  end;

  for i:=0 to ChnlNumber-1 do begin
    value := GetTagValue( FTagChannel[i] );
    if value <> FChannel[i] then begin
      ChnlListBox.Items[i] := copy(ChnlListBox.Items[i], 1,
          pos(':', ChnlListBox.Items[i])+1) +
          IntToStr(value shr 8) + '-' +
          IntToStr(value and $7F) + iif((value and $80)>0, 'f','');
//          IntToStr(value shr 8) + '-' + IntToStr(value and $FF);
      FChannel[i] := value;
    end;
  end;

end;




procedure TZdvcCtrlFrame.NamePanelClick(Sender: TObject);
var
  ZdvSetPanelForm: TZdvSetPanelForm;
begin
  ZdvSetPanelForm := TZdvSetPanelForm.Create(self);
  ZdvSetPanelForm.DeviceName := DeviceName;
  ZdvSetPanelForm.DelayTagName := TagPath + '.ZDVC_' + TagName + '_Delay';
  ZdvSetPanelForm.SostTagName := TagPath + '.ZDVC_' + TagName + '_Sost';
  ZdvSetPanelForm.MessageTagName := TagPath + '.ZDVC_' + TagName + '_Alarm';
  ZdvSetPanelForm.ShowModal;
  ZdvSetPanelForm.Free;
end;

procedure TZdvcCtrlFrame.ChannelLabelClick(Sender: TObject);
begin
  ChannelPanel.Visible := not ChannelPanel.Visible;
end;

procedure TZdvcCtrlFrame.BlokButtonClick(Sender: TObject);
begin
  //  
  if GetTagValue(FTagBlok) = 0 then
    SaveMessageText(mcBlok_text, GetTagName(FTagAlarm), '', mcBlok_bc, mcBlok_fc)
  else
    SaveMessageText(mcBlok_text, GetTagName(FTagAlarm), '', mcBlok_bc, mcBlok_fc);
  //  
  SetTagValue( FTagBlok, (GetTagValue(FTagBlok) xor 1) );
end;

procedure TZdvcCtrlFrame.Button1Click(Sender: TObject);
begin
  ChannelPanel.Visible := false;
end;

procedure TZdvcCtrlFrame.ChnlListBoxDblClick(Sender: TObject);
begin
  if ChnlListBox.ItemIndex >= 0 then begin
    SetChannelForm.Channel := FChannel[ChnlListBox.ItemIndex];
    SetChannelForm.DeviceName := DeviceName + ' ' + inttostr(ChnlListBox.ItemIndex);


    if SetChannelForm.ShowModal = mrOk then begin

      SaveMessageText(mcSetChannel_text, GetTagName(FTagAlarm),
          IntToStr(SetChannelForm.Channel shr 8) + '-' +
          IntToStr(SetChannelForm.Channel and $7F) +
          iif((SetChannelForm.Channel and $80)>0, 'f',''), mcSetChannel_bc, mcSetChannel_fc);
//          IntToStr(SetChannelForm.Channel shr 8) + '-' +
//          IntToStr(SetChannelForm.Channel and $FF));

      SetTagValue( FTagChannel[ChnlListBox.ItemIndex],
          SetChannelForm.Channel );
    end;
  end;
end;

procedure TZdvcCtrlFrame.StartButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  //  
  SaveMessageText(mcMode_text, GetTagName(FTagAlarm), ' ', mcMode_bc, mcMode_fc);
  //  
  SetTagValue( FTagControl, 2);
end;

procedure TZdvcCtrlFrame.AutoButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  //  
  SaveMessageText(mcMode_text, GetTagName(FTagAlarm), '', mcMode_bc, mcMode_fc);
  //  
  SetTagValue( FTagControl, 0);
end;

procedure TZdvcCtrlFrame.StopButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  //  
  SaveMessageText(mcMode_text, GetTagName(FTagAlarm), ' ', mcMode_bc, mcMode_fc);
  //  
  SetTagValue( FTagControl, 1);
end;

end.
