// DEPRECATED !!!

unit ZdvhCtrl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, VisZDVH;

type
  TZdvhCtrlFrame = class(TFrame)
    NamePanel: TPanel;
    DatPanel: TPanel;
    OpenedPanel: TPanel;
    ChannelLabel: TLabel;
    Label2: TLabel;
    Panel1: TPanel;
    cmbBlok: TComboBox;
    Label4: TLabel;
    Label1: TLabel;
    procedure NamePanelClick(Sender: TObject);
    procedure ChannelLabelClick(Sender: TObject);
    procedure BlokButtonClick(Sender: TObject);
    procedure cmbBlokChange(Sender: TObject);
  private
    FMessageTag: string;

    FOpened: integer;
    FBlok: integer;
    FChnlIn: integer;

    FTagOpened: integer;
    FTagBlok: integer;
    FTagChnlIn: integer;

  public
    M: TVisZdvh;
    DirNum: integer;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  MesConst,
  TagStorage,
  DatSetPanel,
  MesLogging,
  SetChannel,
  numbers,
  ZdvSetPanel,
  RpVisualUtils;

{$R *.DFM}

{ TZdvhCtrlFrame }

procedure TZdvhCtrlFrame.Init;
var
  s: string;
begin
  if DirNum < M.DirCount then begin
    NamePanel.Caption := M.DeviceName + ' ' + M.Dir[DirNum].Name;

    s := M.TagPath + '.ZDVH_' + M.TagName + M.Dir[DirNum].TagPostfix + '_Opened';
    FTagOpened := GetTagIndex(s);
    s := M.TagPath + '.ZDVH_' + M.TagName + M.Dir[DirNum].TagPostfix + '_ChnlIn';
    FTagChnlIn := GetTagIndex(s);
    s := M.TagPath + '.ZDVH_' + M.TagName + M.Dir[DirNum].TagPostfix + '_Blok';
    FMessageTag := M.DeviceName + ' ' + M.Dir[DirNum].Name;
    FTagBlok := GetTagIndex(s);

    FOpened := -1;
    FBlok := -1;
    FChnlIn := -1;

    Process;
  end;
end;

procedure TZdvhCtrlFrame.Process;
var
  value: integer;
begin

  value := GetTagValue( FTagOpened );
  if value <> FOpened then begin
    OpenedPanel.Caption := iif(value=0, '', '');
    FOpened := value;
  end;

  value := GetTagValue( FTagBlok );
  if (value <> FBlok) then begin
    if value < cmbBlok.Items.Count then cmbBlok.ItemIndex := value;
    FBlok := value;
  end;

  value := GetTagValue( FTagChnlIn );
  if value <> FChnlIn then begin
    ChannelLabel.Caption := IntToStr(value shr 8) + '-' +
        IntToStr(value and $7F) + iif((value and $80)>0, 'f','');
    FChnlIn := value;
  end;

end;




procedure TZdvhCtrlFrame.NamePanelClick(Sender: TObject);
begin
  if ZdvSetPanelForm=nil then ZdvSetPanelForm := TZdvSetPanelForm.Create(self);
  try
    ZdvSetPanelForm.DeviceName := M.DeviceName;
    ZdvSetPanelForm.DelayTagName := '';
    ZdvSetPanelForm.SostTagName := GetTagName(FTagOpened);
    ZdvSetPanelForm.MessageTagName := FMessageTag;
    ZdvSetPanelForm.ShowModal;
  finally
    FreeAndNil( ZdvSetPanelForm );
  end;
end;

procedure TZdvhCtrlFrame.ChannelLabelClick(Sender: TObject);
begin
  SetChannelForm.Channel := FChnlIn;
  SetChannelForm.DeviceName := M.DeviceName;


  if SetChannelForm.ShowModal = mrOk then begin
    SaveMessageText(mcSetChannel_text, FMessageTag,
        IntToStr(SetChannelForm.Channel shr 8) + '-' +
        IntToStr(SetChannelForm.Channel and $7F) +
        iif((SetChannelForm.Channel and $80)>0, 'f',''), mcSetChannel_bc, mcSetChannel_fc);

    SetTagValue( FTagChnlIn, SetChannelForm.Channel );
  end;
end;

procedure TZdvhCtrlFrame.BlokButtonClick(Sender: TObject);
begin
  //  
  if GetTagValue(FTagBlok) = 0 then
    SaveMessageText(mcBlok_text, FMessageTag, '', mcBlok_bc, mcBlok_fc)
  else
    SaveMessageText(mcBlok_text, FMessageTag, '', mcBlok_bc, mcBlok_fc);
  //  
  SetTagValue( FTagBlok, (GetTagValue(FTagBlok) xor 1) );
end;

procedure TZdvhCtrlFrame.cmbBlokChange(Sender: TObject);
begin
  if cmbBlok.ItemIndex = 0 then SaveMessageText(' ', FMessageTag, '.', clYellow) else
  if cmbBlok.ItemIndex = 1 then SaveMessageText(' ', FMessageTag, '.-', clYellow) else
  if cmbBlok.ItemIndex = 2 then SaveMessageText(' ', FMessageTag, '.-', clYellow);
  ChangeComboBox( cmbBlok, FTagBlok);
end;

end.
