// DEPRECATED !!!

unit ZdvrCtrl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, ComCtrls;

type
  TZdvrCtrlFrame = class(TFrame)
    NamePanel: TPanel;
    DatPanel: TPanel;
    SostPanel: TPanel;
    BlokButton: TSpeedButton;
    Label2: TLabel;
    ChannelPanel: TPanel;
    ChnlListBox: TListBox;
    Button1: TButton;
    Label1: TLabel;
    BlokPosEdit: TEdit;
    BlokPosUpDown: TUpDown;
    procedure ChannelLabelClick(Sender: TObject);
    procedure BlokButtonClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ChnlListBoxDblClick(Sender: TObject);
    procedure BlokPosUpDownClick(Sender: TObject; Button: TUDBtnType);
    procedure NamePanelClick(Sender: TObject);
  private
    FSost: integer;
    FBlok: integer;
    FChannel: array of integer;

    FTagSost: integer;
    FTagBlok: integer;
    FTagChannel: array of integer;
  public
    TagName: string;
    TagPath: string;
    DeviceName: string;
    ChnlNumber: integer;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  MesConst, TagStorage, DatSetPanel, MesLogging, SetChannel, ZdvSetPanel, numbers;

{$R *.DFM}

{ TZdvrCtrlFrame }

procedure TZdvrCtrlFrame.Init;
var
  s: string;
  i: integer;
begin
  ChnlNumber := 2;
  BlokPosUpDown.Max := ChnlNumber;
  BlokPosUpDown.Min := 1;

  NamePanel.Caption := DeviceName;

  s := TagPath + '.ZDVR_' + TagName + '_Sost';
  FTagSost := GetTagIndex(s);
  s := TagPath + '.ZDVR_' + TagName + '_Blok';
  FTagBlok := GetTagIndex(s);

  SetLength(FChannel, ChnlNumber);
  SetLength(FTagChannel, ChnlNumber);
  ChnlListBox.Items.Clear;

  for i:=0 to ChnlNumber-1 do begin
    s := TagPath + '.ZDVR_' + TagName + '_ChnlIn' + chr( ord('A') + i);
    FTagChannel[i] := GetTagIndex(s);
    FChannel[i] := -1;
    ChnlListBox.Items.Add('');
  end;

  FBlok := -1;
  FSost := -1;

  Process;
end;

procedure TZdvrCtrlFrame.Process;
var
  i, value: integer;
begin

  value := GetTagValue( FTagSost );
  if value <> FSost then begin
    case value of
      0: SostPanel.Caption := '';
      1: SostPanel.Caption := '';
      2: SostPanel.Caption := '';
      254: SostPanel.Caption := '?';
    else
      SostPanel.Caption := '???';
    end;
    FSost := value;
  end;

  value := GetTagValue( FTagBlok ) and 3;
  if value <> FBlok then begin
    if value > 0 then begin
      BlokButton.Down := true;
      BlokButton.Font.Style := [fsBold];
      BlokPosUpDown.Position := value;
    end else begin
      BlokButton.Down := false;
      BlokButton.Font.Style := [];
    end;
    FBlok := value;
  end;

  for i:=0 to ChnlNumber-1 do begin
    value := GetTagValue( FTagChannel[i] );
    if value <> FChannel[i] then begin
      ChnlListBox.Items[i] := ' ' + IntToStr(i+1) + ': ' +
          IntToStr(value shr 8) + '-' +
          IntToStr(value and $7F) + iif((value and $80)>0, 'f','');
      FChannel[i] := value;
    end;
  end;

end;




procedure TZdvrCtrlFrame.ChannelLabelClick(Sender: TObject);
begin
  ChannelPanel.Visible := not ChannelPanel.Visible;
end;

procedure TZdvrCtrlFrame.BlokButtonClick(Sender: TObject);
begin
  //  
  if BlokButton.Down then begin
    SaveMessageText(mcBlok_text, GetTagName(FTagBlok), '' + IntToStr(BlokPosUpDown.Position), mcBlok_bc, mcBlok_fc);
    SetTagValue( FTagBlok, (GetTagValue(FTagBlok) and $FC) + BlokPosUpDown.Position );
  end else begin
    SaveMessageText(mcBlok_text, GetTagName(FTagBlok), '', mcBlok_bc, mcBlok_fc);
    SetTagValue( FTagBlok, (GetTagValue(FTagBlok) and $FC) + 0 );
  end;
end;

procedure TZdvrCtrlFrame.Button1Click(Sender: TObject);
begin
  ChannelPanel.Visible := false;
end;

procedure TZdvrCtrlFrame.ChnlListBoxDblClick(Sender: TObject);
begin
  if ChnlListBox.ItemIndex >= 0 then begin
    SetChannelForm.Channel := FChannel[ChnlListBox.ItemIndex];
    SetChannelForm.DeviceName := DeviceName + ' ' + inttostr(ChnlListBox.ItemIndex);

    if SetChannelForm.ShowModal = mrOk then begin

      SaveMessageText(mcSetChannel_text, GetTagName(FTagBlok),
          IntToStr(SetChannelForm.Channel shr 8) + '-' +
          IntToStr(SetChannelForm.Channel and $7F) +
          iif((SetChannelForm.Channel and $80)>0, 'f',''), mcSetChannel_bc, mcSetChannel_fc );

      SetTagValue( FTagChannel[ChnlListBox.ItemIndex],
          SetChannelForm.Channel );
    end;
  end;
end;

procedure TZdvrCtrlFrame.BlokPosUpDownClick(Sender: TObject;
  Button: TUDBtnType);
begin
  if FBlok > 0 then
    BlokButtonClick(nil);
end;

procedure TZdvrCtrlFrame.NamePanelClick(Sender: TObject);
var
  ZdvSetPanelForm: TZdvSetPanelForm;
begin
  ZdvSetPanelForm := TZdvSetPanelForm.Create(self);
  ZdvSetPanelForm.DeviceName := DeviceName;
  ZdvSetPanelForm.DelayTagName := '';
  ZdvSetPanelForm.SostTagName := TagPath + '.ZDVR_' + TagName + '_Sost';
  ZdvSetPanelForm.MessageTagName := '';
  ZdvSetPanelForm.ShowModal;
  ZdvSetPanelForm.Free;
end;

end.
