unit zdvbCtrl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, Viszdvb, ScadaBase, VisButton, VisLabel,
  VisDataboard, VisControl;

type

  TzdvbCtrlChnlRec = record
    Name: string;
    tagidx: integer;
    tagvalue: integer;
    use: boolean;
  end;

  TzdvbCtrlFrame = class(TFrame)
    NamePanel: TPanel;
    DatPanel: TPanel;
    SostPanel: TPanel;
    BlokButton: TSpeedButton;
    Label2: TLabel;
    ChannelPanel: TPanel;
    ChnlListBox: TListBox;
    btChnlClose: TButton;
    Panel1: TPanel;
    Label4: TLabel;
    bt0: TVisButton;
    bt1: TVisButton;
    bt2: TVisButton;
    bt3: TVisButton;
    bt4: TVisButton;
    lb1: TVisLabel;
    lb2: TVisLabel;
    Panel2: TPanel;
    pnlParams: TPanel;
    Bevel4: TBevel;
    Label1: TLabel;
    dbrdParams: TVisDataboard;
    btParams: TBitBtn;
    TimePanel: TPanel;
    procedure NamePanelClick(Sender: TObject);
    procedure ChannelLabelClick(Sender: TObject);
    procedure BlokButtonClick(Sender: TObject);
    procedure ChnlListBoxDblClick(Sender: TObject);
    procedure btChnlCloseClick(Sender: TObject);
    procedure ChnlListBoxKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btModeClick(Sender: TObject);
    procedure bt0CanClick(Sender: TObject; var Can: Boolean);
    procedure btParamsClick(Sender: TObject);
    procedure TimePanelClick(Sender: TObject);
  private
    FMessageTag: string;

    FSost: integer;
    FOpen: integer;
    FClose: integer;
    FControl: integer;
    FBlok: integer;

    FTagSost: integer;
    FTagControl: integer;
    FTagBlok: integer;
    FTagClosed: integer;
    FTagOpened: integer;


    FTagTimeOpen : integer;
    FTagTime100Proc : integer;
    FTagProc : integer;


//    FTagFlags: integer;

    FChnl: array of TzdvbCtrlChnlRec;

    tagname: string;

  public
    M: TViszdvb;

    procedure Init;
    procedure Process;
  end;

implementation
uses
  RpVisualGlobal,
  RpVisualUtils,
  UserControlEx,
  Users,
  TrendWindow,
  MesConst,
  TagStorage,
  DatSetPanel,
  MesLogging,
  SetChannel,
  numbers;

{$R *.DFM}

{ TzdvbCtrlFrame }

procedure TzdvbCtrlFrame.Init;
var
  s: string;
  i: integer;
begin
  NamePanel.Caption := M.DeviceName;
  SetLength(FChnl, 4);

  tagname := 'zdvb_' + M.TagName + '_';
  s := tagname + 'Control';

  bt0.TagPath := M.TagPath;
  bt0.TagName := s ;
  bt0.Init;

  bt1.TagPath := M.TagPath;
  bt1.TagName := s ;
  bt1.Init;

  bt2.TagPath := M.TagPath;
  bt2.TagName := s ;
  bt2.CaptionUp := M.StateClose;
  bt2.CaptionDown := M.StateClose;
  bt2.Init;

  bt3.TagPath := M.TagPath;
  bt3.TagName := s ;
  bt3.CaptionUp := ' ';
  bt3.CaptionDown := ' ';
  bt3.Init;

  bt4.TagPath := M.TagPath;
  bt4.TagName := s ;
  bt4.CaptionUp := ' ';
  bt4.CaptionDown := ' ';
  bt4.Init;

  lb1.TagPath := M.TagPath;
  lb1.TagRoot := M.TagName;
  lb1.Init;

  lb2.TagPath := M.TagPath;
  lb2.TagRoot := M.TagName;
  lb2.Init;

  s := M.TagPath + '.zdvb_' + M.TagName;

  FTagSost := GetTagIndex(s + '_Sost');

  FTagClosed := GetTagIndex(s + '_Closed');
  FTagOpened := GetTagIndex(s + '_Opened');

  FTagControl := GetTagIndex(s + '_Control');
  FTagBlok := GetTagIndex(s + '_Blok');
  FMessageTag := M.DeviceName;


  FTagTimeOpen := GetTagIndex(s + '_TimeOpen');
  FTagTime100Proc := GetTagIndex(s + '_Time100Proc');
  FTagProc := GetTagIndex(s + '_Proc');



  with FChnl[0] do begin
    name := ' ' + M.StateClose;
    tagidx := GetTagIndex(s + '_Chnl2Out');
    tagvalue := -1;
    use := M.ChnlOutNum=2;
  end;

  with FChnl[1] do begin
    name := ' ' + M.StateOpen;
    tagidx := GetTagIndex(s + '_Chnl1Out');
    tagvalue := -1;
    use := M.ChnlOutNum>0;
  end;

  with FChnl[2] do begin
    name := ' ' + M.StateClose;
    tagidx := GetTagIndex(s + '_Chnl2In');
    tagvalue := -1;
    use := M.ChnlInNum=2;
  end;
  with FChnl[3] do begin
    name := ' ' + M.StateOpen;
    tagidx := GetTagIndex(s + '_Chnl1In');
    tagvalue := -1;
    use := true;
  end;



  ChnlListBox.Items.Clear;

  for i:=0 to 3 do
    if FChnl[i].use then
      ChnlListBox.Items.AddObject(FChnl[i].Name + ': ' , TObject(i));

  FBlok := -1;
  FControl := -1;
  FSost := -1;
  FOpen := -1;
  FClose := -1;

  Process;
end;

procedure TzdvbCtrlFrame.Process;
var
  i, k, value, valueo, valuec: integer;
begin
  bt0.Process;
  bt1.Process;
  bt2.Process;
  bt3.Process;
  bt4.Process;

  lb1.Process;
  lb2.Process;



  value  := GetTagValue( FTagSost   );
  valuec := GetTagValue( FTagClosed );
  valueo := GetTagValue( FTagOpened );


  if (value <> FSost) OR (valueo <> FOpen) OR (valuec <> FClose) then begin
    if (valuec > 0) and (valueo > 0) then SostPanel.Caption := ' '
      else
        begin

          case Value of
            88: SostPanel.Caption := ' ';
            30: SostPanel.Caption := '';
             0:  SostPanel.Caption := ' ';

            15,25:  SostPanel.Caption := '';
            17,27:  SostPanel.Caption := M.StateClose;
            18,28:  SostPanel.Caption := ' ';

            11,21:  SostPanel.Caption := ' ';

            10,20:  SostPanel.Caption := '. ';
            19,29:  SostPanel.Caption := ' . .';

            16,26:  SostPanel.Caption := M.StateOpen + ' ';

            12,22:  SostPanel.Caption := ' .';

            14,24:  SostPanel.Caption := M.StateOpen + ' .';
            13,23:  SostPanel.Caption := ' ';
          end;



        end;

    FSost := value;
    FOpen := valueo;
    FClose := valuec;
  end;



  value  := GetTagValue( FTagTime100Proc   );
  if value > 0 then
    begin
      //   
      valuec := GetTagValue( FTagProc );
      if valuec >= 0 then TimePanel.Caption := ' : ' + inttostr(valuec) + '%'
                     else TimePanel.Caption := ' : ????';

    end
  else
    begin
      //  
      valuec := GetTagValue( FTagTimeOpen );
      if valuec >= 0 then TimePanel.Caption := ' : ' + inttostr(valuec) + ' '
                     else TimePanel.Caption := ' : ????';
    end;




  value := GetTagValue( FTagBlok );
  if value <> FBlok then begin
    if value > 0 then begin
      BlokButton.Down := true;
      BlokButton.Font.Style := [fsBold];
    end else begin
      BlokButton.Down := false;
      BlokButton.Font.Style := [];
    end;
    FBlok := value;
  end;

  for i:=0 to 3 do begin
    value := GetTagValue( FChnl[i].tagidx );
    if value <> FChnl[i].tagvalue then begin

      k := ChnlListBox.Items.IndexOfObject(TObject(i));

      if k<>-1 then
        ChnlListBox.Items[k] := copy(ChnlListBox.Items[k], 1,
            pos(':', ChnlListBox.Items[k])+1) +  StringOfChar(' ', 15-length(FChnl[i].Name)) + // '        ' +
            IntToStr(value shr 8) + '-' +
            IntToStr(value and $7F) + iif((value and $80)>0, 'f','');

      FChnl[i].tagvalue := value;
    end;
  end;

end;




procedure TzdvbCtrlFrame.NamePanelClick(Sender: TObject);
begin
  ShowTrendWindow(
    M.DeviceName,
    GetTagName(FTagSost),
    '',
    'zdvb_',
    '',
    ': '#13+
    '30 - '#13+
    '0  -  '#13+
    '88 -   (  )'#13+
    '   : '#13+
    '  10 -    ( DoOpen=1), ..     '#13+
    '  11 -    ( DoOpen=1)'#13+
    '  12 -    '#13+
    '  13 -     '#13+
    '  14 -     '#13+
    '  15 -    ( DoOpen=0)'#13+
    '  16 -   DoOpen=1 ,   '#13+
    '  17 -    ( DoOpen=0)  '#13+
    '  18 -    ( DoOpen=0)  '#13+
    '  19 -    ( DoOpen=1)    '#13+
    '   :'#13+
    '  20 -    ( DoOpen=1), ..     '#13+
    '  21 -    ( DoOpen=1)'#13+
    '  22 -    '#13+
    '  23 -     '#13+
    '  24 -     '#13+
    '  25 -    ( DoOpen=0)'#13+
    '  26 -   DoOpen=1 ,   '#13+
    '  27 -    ( DoOpen=0)  '#13+
    '  28 -    ( DoOpen=0)  '#13+
    '  29 -    ( DoOpen=1)    '
  );

end;

procedure TzdvbCtrlFrame.ChannelLabelClick(Sender: TObject);
begin
  ChannelPanel.Visible := not ChannelPanel.Visible;
end;

procedure TzdvbCtrlFrame.BlokButtonClick(Sender: TObject);
var
  blokstr: string;
begin
  if GetTagValue(FTagBlok) = 0 then
    blokstr := ''
  else
    blokstr := '';

  if isModeUserEx then
    if not isPermitted(ClassName + '~' + NamePanel.Caption + '~' + (Sender as TSpeedButton).Caption + '~' + blokstr) then
      Exit;


  SaveMessageText(mcBlok_text, FMessageTag, blokstr, mcBlok_bc, mcBlok_fc);

  SetTagValue( FTagBlok, (GetTagValue(FTagBlok) xor 1) );
end;



procedure TzdvbCtrlFrame.ChnlListBoxDblClick(Sender: TObject);
var
  i: integer;
begin
  if ChnlListBox.ItemIndex = -1 then exit;


  i := integer(pointer(ChnlListBox.Items.Objects[ChnlListBox.ItemIndex]));
  if i=-1 then exit;

  SetChannelForm.Channel := FChnl[i].tagvalue;
  SetChannelForm.DeviceName := FChnl[i].Name;

  if isModeUserEx then
    if not isPermitted(ClassName + '~ ~' + FChnl[i].Name ) then
      exit;


    if SetChannelForm.ShowModal = mrOk then begin

      SaveMessageText(mcSetChannel_text, FMessageTag,
          IntToStr(SetChannelForm.Channel shr 8) + '-' +
          IntToStr(SetChannelForm.Channel and $7F) +
          iif((SetChannelForm.Channel and $80)>0, 'f',''), mcSetChannel_bc, mcSetChannel_fc);

      SetTagValue( FChnl[i].tagidx, SetChannelForm.Channel );
    end;

end;

procedure TzdvbCtrlFrame.btChnlCloseClick(Sender: TObject);
begin
  ChannelPanel.Visible := false;
end;

procedure TzdvbCtrlFrame.ChnlListBoxKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = 13 then ChnlListBoxDblClick(nil);
end;

procedure TzdvbCtrlFrame.btModeClick(Sender: TObject);
begin
//
  with sender as TVisButton do
  begin
    SaveMessageText('  ', FMessageTag, CaptionDown, mcMode_bc, mcMode_fc);
  end
end;

procedure TzdvbCtrlFrame.bt0CanClick(Sender: TObject; var Can: Boolean);
begin
//  M
  if isModeUserEx then
    Can := isPermitted(ClassName + '~' + NamePanel.Caption + '~ ~' + (Sender as TVisButton).CaptionDown);
  if ((Can)and(lb1.Visible=true)) then
    with Sender as TVisButton do
    begin
       if((Name='bt0')and(M.PosAShowMsg))then Can:=(MessageDlg('    , ?',mtConfirmation,[mbYes, mbNo],0) = mrYes);
       if((Name='bt2')and(M.Pos1ShowMsg))then Can:=(MessageDlg('    , ?',mtConfirmation,[mbYes, mbNo],0) = mrYes);
       if((Name='bt3')and(M.Pos2ShowMsg))then Can:=(MessageDlg('    , ?',mtConfirmation,[mbYes, mbNo],0) = mrYes);
       if((Name='bt4')and(M.Pos2ShowMsg))then Can:=(MessageDlg('    , ?',mtConfirmation,[mbYes, mbNo],0) = mrYes);
    end;

end;

procedure TzdvbCtrlFrame.btParamsClick(Sender: TObject);
//var
//  Flags,
//  i: integer;
begin
  if isModeUserEx then begin
    if not isPermitted(M.ClassName + '~' + M.DeviceName + '~') then
      exit;
  end else
    if not CheckAccess(PREVILEG_SET_PARAMETERS, true) then
      exit;

//  Flags := GetTagValueByName( tagname + 'Flags' );

  dbrdParams.Caption := M.DeviceName;
  dbrdParams.DataPar.Clear;

  dbrdParams.DataPar.Add(' /;;;;0');
  dbrdParams.DataPar.Add('out1 -  ;' + tagname + 'Chnl1Out;A;;0');
  dbrdParams.DataPar.Add('out2 -  ;' + tagname + 'Chnl2Out;A;;0');
  dbrdParams.DataPar.Add('in1 -  ;' + tagname + 'Chnl1In;A;;0');
  dbrdParams.DataPar.Add('in2 -  ;' + tagname + 'Chnl2In;A;;0');

  dbrdParams.DataPar.Add('   ;;;;0');

  dbrdParams.DataPar.Add('  ;' + tagname + 'Flags;& 3;0=0 (/),1=1 (/),2=2 (+);0;1');
  dbrdParams.DataPar.Add('  ;' + tagname + 'Flags;& 12;0=0 (/),4=1 (/),8=2 (+);0;1');
  dbrdParams.DataPar.Add('   ;' + tagname + 'Flags;& 16;0=0 ( 0),16=1 ( 1);0;1');
  dbrdParams.DataPar.Add('   ;' + tagname + 'Flags;& 32;0=0 ( 0),32=1 ( 1);0;1');


  dbrdParams.DataPar.Add('    ;' + tagname + 'Flags;& 64;0=0 ( ),64=1 ( );0;1');

  dbrdParams.DataPar.Add('   ;' + tagname + 'Flags;& 128;0=0 ( ),128=1 ( );0;1');

  dbrdParams.DataPar.Add(' , ;' + tagname + 'TimeOpen;;;0');

  dbrdParams.DataPar.Add('.  , ;' + tagname + 'MaxCloseTime;;;0');
  dbrdParams.DataPar.Add('.  , ;' + tagname + 'MaxOpenTime;;;0');

  dbrdParams.DataPar.Add('  , ;' + tagname + 'Time100Proc;;;0');
  dbrdParams.DataPar.Add(' , %;' + tagname + 'Proc;;;0');

  dbrdParams.DataPar.Add('  , %;' + tagname + 'RealProc;;;0');

  dbrdParams.DataPar.Add('  Control;' + tagname + 'Control;;;0');

  dbrdParams.DataPar.Add('  ,   "";' + tagname + 'CloseVal;;;0');
  dbrdParams.DataPar.Add('  ,   "";' + tagname + 'OpenVal;;;0');

  dbrdParams.DataPar.Add('  ;' + tagname + 'Value;;;0');


//    dbrdParams.DataPar.Add(';MCHB_^_Flags;& 3;0= 1,1= 2,2=,3=;0;1');

  {
  if not M.OnlyDat then begin
    if (flags and 3) = 0 then begin
      dbrdParams.DataPar.Add(';MCHB_^_Channel1;A;;0');
      dbrdParams.DataPar.Add(';MCHB_^_Channel2;A;;0');
    end;

    if (flags and 3) = 1 then
      dbrdParams.DataPar.Add('/;MCHB_^_Channel1;A;;0');

    if (flags and 3) = 2 then
      dbrdParams.DataPar.Add(';MCHB_^_Channel1;A;;0');
  end;

  for i:=0 to M.DatCount-1 do
    dbrdParams.DataPar.Add(M.Datchik[i].Name + ';MDTA_^' + M.Datchik[i].TagPostfix + '_Channel;A;;0');
}


//    dbrdParams.DataPar.Add(' , ;MCHB_^_TimeStop;;;0');

{
  for i:=0 to M.DatCount-1 do begin
    dbrdParams.DataPar.Add(M.Datchik[i].Name + ';;;;0');
    dbrdParams.DataPar.Add('  ( );MDTA_^' + M.Datchik[i].TagPostfix + '_Value;;;0');
    dbrdParams.DataPar.Add('   ( );MDTA_^' + M.Datchik[i].TagPostfix + '_Primeval;;;0');
    dbrdParams.DataPar.Add(' ;MDTA_^' + M.Datchik[i].TagPostfix + '_Low;;;0');
    dbrdParams.DataPar.Add(' ;MDTA_^' + M.Datchik[i].TagPostfix + '_High;;;0');
    dbrdParams.DataPar.Add(' , ;MDTA_^' + M.Datchik[i].TagPostfix + '_DlyDrebezg;;;0');
    dbrdParams.DataPar.Add(' , ;MDTA_^' + M.Datchik[i].TagPostfix + '_DlyOutput;;;0');
    dbrdParams.DataPar.Add(': .;MDTA_^' + M.Datchik[i].TagPostfix + '_PointV;;;0;1');
    dbrdParams.DataPar.Add(': .;MDTA_^' + M.Datchik[i].TagPostfix + '_PointP;;;0;1');
    dbrdParams.DataPar.Add(': .1;MDTA_^' + M.Datchik[i].TagPostfix + '_PointV1;;;0;1');
    dbrdParams.DataPar.Add(': .1;MDTA_^' + M.Datchik[i].TagPostfix + '_PointP1;;;0;1');
    dbrdParams.DataPar.Add('   ;MDTA_^' + M.Datchik[i].TagPostfix + '_Flags;& 64;0=,64=;1');
    dbrdParams.DataPar.Add(' ;MDTA_^' + M.Datchik[i].TagPostfix + '_Flags;& 128;0=,128=;1');
  end;
}


  SetPathRootScadaObjects(pnlParams, M.TagPath, M.TagRoot );
  dbrdParams.OnControlClick(sender);
end;

procedure TzdvbCtrlFrame.TimePanelClick(Sender: TObject);
var i, code, value, valuec:integer;
    s : string;
    w:boolean;
begin
  //PREVILEG_SET_PARAMETERS
  if isModeUserEx then begin
    if not isPermitted(M.ClassName + '~' + M.DeviceName + '~') then
      exit;
  end else
    if not CheckAccess(PREVILEG_SET_PARAMETERS, true) then
      exit;




  value  := GetTagValue( FTagTime100Proc   );
  if value > 0 then
    begin
      //   
      valuec := GetTagValue( FTagProc );

      s := inttostr(valuec);

      w := InputQuery('   ', ' % ', s);

      if valuec >= 0 then TimePanel.Caption := ' : ' + inttostr(valuec) + '%'
                     else TimePanel.Caption := ' : ????';

    end
  else
    begin
      //  
      valuec := GetTagValue( FTagTimeOpen );
      s := inttostr(valuec);

      w := InputQuery('   ', '    ', s);

    end;


  if w then
   begin
         {$R-}
         Val(s, I, Code);

         if (Code <> 0) or (i < 0) or (i>32768)
           then
             begin
               MessageDlg('  ,     ', mtWarning, [mbOk], 0);
             end
           else
             begin

               if value > 0 then
                 begin
                   SetTagValue( FTagProc, i );
                   SaveMessageText(' % : ', FMessageTag, inttostr(i)+'%', mcBlok_bc, mcBlok_fc);
                 end
               else
                 begin
                   SetTagValue( FTagTimeOpen, i );
                   SaveMessageText('  : ', FMessageTag, inttostr(i)+' ',  mcBlok_bc, mcBlok_fc);
                 end;
             end;
   end;



end;

end.
