unit DataClientBase;

interface
uses Forms, Classes, Controls, Windows, Dialogs, stdctrls, sysutils,
  rpTcpClientBase;

const
  PROTOCOL_RPSVRTCP = 0;
  PROTOCOL_JRBUSTCP = 1;

  TAGTYPE_BOOL   = 1;
  TAGTYPE_INT    = 2;
  TAGTYPE_LONG   = 3;
  TAGTYPE_DOUBLE = 4;
  TAGTYPE_STRING = 5;

type

  TDataClient = class(TObject)
    function getProtocol: integer; virtual; abstract;
    function getClient: TObject; virtual; abstract;

    procedure load(iniFileName: string; section: string); virtual; abstract;
    procedure save(iniFileName: string; section: string); virtual; abstract;
    function showSettingsDialog: boolean; virtual; abstract;

    function getHost: string; virtual; abstract;
    function getPort: integer; virtual; abstract;
    function getFilter: string; virtual; abstract;

    function isConnected: Boolean; virtual; abstract;
    function isNeedReconnect: Boolean; virtual; abstract;
    function getPortConnectBad: Integer; virtual; abstract;
    procedure start; virtual; abstract;
    procedure stop; virtual; abstract;

    function getTagCount: integer; virtual; abstract;
    function getTagName(index: Integer): string; virtual; abstract;
    function getTagIndex(tagname: string): Integer; virtual; abstract;
    function getTagType(index: Integer): integer; virtual; abstract;

    function getValBool(index: Integer): Boolean; virtual; abstract;
    function getValInt(index: Integer): Integer; virtual; abstract;
    function getValLong(index: Integer): int64; virtual; abstract;
    function getValDouble(index: Integer): Double; virtual; abstract;
    function getValString(index: Integer): string; virtual; abstract;
    function isTagStatusGood(index: Integer): Boolean; virtual; abstract;

    procedure setValBool(index: Integer; value: Boolean); virtual; abstract;
    procedure setValInt(index: Integer; value: integer); virtual; abstract;
    procedure setValLong(index: Integer; value: int64); virtual; abstract;
    procedure setValDouble(index: Integer; value: double); virtual; abstract;
    procedure setValString(index: Integer; value: string); virtual; abstract;

    function getTagExplotable(index: Integer): boolean; virtual; abstract;
    function getTagProp(index: Integer): TWorkRecTagProp; virtual; abstract;
    procedure setTagFlag(index: Integer; value: TWorkRecTagFlag); virtual; abstract;

    property Connected: Boolean read isConnected;
    property TagCount: integer read getTagCount;
    property Host: string read getHost;
    property Port: integer read getPort;
    property Filter: string read getFilter;
    property PortConnectBad: integer read getPortConnectBad;

  end;

  function tagtypeToStr(tagtype: integer): string;
  function strToTagtype(tagtypeStr: string): integer;

implementation
const
  STR_BOOL   = 'BOOL';
  STR_INT    = 'INT';
  STR_LONG   = 'LONG';
  STR_DOUBLE = 'DOUBLE';
  STR_STRING = 'STRING';


function tagtypeToStr(tagtype: integer): string;
begin
  case tagtype of
    TAGTYPE_BOOL:   Result := STR_BOOL;
    TAGTYPE_INT:    Result := STR_INT;
    TAGTYPE_LONG:   Result := STR_LONG;
    TAGTYPE_DOUBLE: Result := STR_DOUBLE;
    TAGTYPE_STRING: Result := STR_STRING;
  else
    raise Exception.Create('Unknown tag type value: ' + IntToStr(tagtype));
  end;
end;

function strToTagtype(tagtypeStr: string): integer;
begin
  tagtypeStr := Trim(UpperCase(tagtypeStr));

  if tagtypeStr = STR_BOOL then
    Result := TAGTYPE_BOOL
  else

  if tagtypeStr = STR_INT then
    Result := TAGTYPE_INT
  else

  if tagtypeStr = STR_LONG then
    Result := TAGTYPE_LONG
  else

  if tagtypeStr = STR_DOUBLE then
    Result := TAGTYPE_DOUBLE
  else

  if tagtypeStr = STR_STRING then
    Result := TAGTYPE_STRING
  else
    raise Exception.Create('Unknown tag type vale: ' + tagtypeStr);
end;


end.
