unit DataClientJrbustcp;

(*
   "File not found 'JrbustcpClient.dcu'",  :
1.     https://promauto@bitbucket.org/promauto/rplib-delphi.git
2.     Jrbustcp  Tools/Environment Options.../Library Path (: $(PROMAUTO)\Lib\Delphi\jrbustcp)
*)

interface
uses Forms, Classes, Controls, Windows, Dialogs, stdctrls, sysutils,
  rpTcpClientBase, DataClientBase, JrbustcpClient;
type
  TDataClientJrbustcp = class(TDataClient)
  private
    jr: TJrbustcpClient;
    started: boolean;
  public
    Constructor Create;
    destructor Destroy; override;

    function getProtocol: integer; override;
    function getClient: TObject; override;

    procedure load(iniFileName: string; section: string); override;
    procedure save(iniFileName: string; section: string); override;
    function showSettingsDialog: boolean; override;

    function getHost: string; override;
    function getPort: integer; override;
    function getFilter: string; override;

    function isConnected: Boolean; override;
    function isNeedReconnect: Boolean; override;
    function getPortConnectBad: Integer; override;
    procedure start; override;
    procedure stop; override;

    function getTagCount: integer; override;
    function getTagName(index: Integer): string; override;
    function getTagIndex(tagname: string): Integer; override;
    function getTagType(index: Integer): Integer; override;

    function getValBool(index: Integer): Boolean; override;
    function getValInt(index: Integer): Integer; override;
    function getValLong(index: Integer): int64; override;
    function getValDouble(index: Integer): Double; override;
    function getValString(index: Integer): string; override;
    function isTagStatusGood(index: Integer): Boolean; override;

    procedure setValBool(index: Integer; value: Boolean); override;
    procedure setValInt(index: Integer; value: integer); override;
    procedure setValLong(index: Integer; value: int64); override;
    procedure setValDouble(index: Integer; value: double); override;
    procedure setValString(index: Integer; value: string); override;

    function getTagExplotable(index: Integer): boolean; override;
    function getTagProp(index: Integer): TWorkRecTagProp; override;
    procedure setTagFlag(index: Integer; value: TWorkRecTagFlag); override;

    function getState: string;
  end;


implementation
uses
  IniFiles, Tags;


{ TDataClientJrbustcp }
constructor TDataClientJrbustcp.Create;
begin
  jr := TJrbustcpClient.Create;
  started := false;
end;

destructor TDataClientJrbustcp.Destroy;
begin
  jr.Free;
end;


function TDataClientJrbustcp.getClient: TObject;
begin
  Result := jr;
end;

function TDataClientJrbustcp.getFilter: string;
begin
  Result := jr.filter;
end;

function TDataClientJrbustcp.getHost: string;
begin
  Result := jr.host;
end;

function TDataClientJrbustcp.getPort: integer;
begin
  Result := jr.port;
end;

function TDataClientJrbustcp.getPortConnectBad: Integer;
begin
  if jr.Connected then
    Result := 0
  else
    Result := 1;
end;

function TDataClientJrbustcp.getProtocol: integer;
begin
  result := PROTOCOL_JRBUSTCP;
end;

function TDataClientJrbustcp.getTagCount: integer;
begin
  result := jr.TagTable.getSize;
end;

function TDataClientJrbustcp.getTagExplotable(index: Integer): boolean;
begin
  Result := false;
end;

function TDataClientJrbustcp.getTagIndex(tagname: string): Integer;
begin
  Result := jr.TagTable.getIndex(tagname);
end;

function TDataClientJrbustcp.getTagName(index: Integer): string;
begin
  Result := jr.TagTable.get(index).getName;
end;

function TDataClientJrbustcp.getTagProp(index: Integer): TWorkRecTagProp;
begin
  result := tpNormal;
end;

function TDataClientJrbustcp.getTagType(index: Integer): Integer;
begin
  result := Ord(jr.TagTable.get(index).getType);
end;

function TDataClientJrbustcp.getValBool(index: Integer): Boolean;
begin
  result := jr.TagTable.get(index).getBool;
end;

function TDataClientJrbustcp.getValDouble(index: Integer): Double;
begin
  result := jr.TagTable.get(index).getDouble;
end;

function TDataClientJrbustcp.getValInt(index: Integer): Integer;
begin
  result := jr.TagTable.get(index).getInt;
end;

function TDataClientJrbustcp.getValLong(index: Integer): int64;
begin
  result := jr.TagTable.get(index).getLong;
end;

function TDataClientJrbustcp.getValString(index: Integer): string;
begin
  result := jr.TagTable.get(index).getString;
end;

function TDataClientJrbustcp.isTagStatusGood(index: Integer): Boolean;
begin
  result := jr.TagTable.get(index).getStatus = tsGOOD;
end;

function TDataClientJrbustcp.isConnected: Boolean;
begin
  result := started;
end;

function TDataClientJrbustcp.isNeedReconnect: Boolean;
begin
  result := jr.NeedReinitList;
end;

procedure TDataClientJrbustcp.load(iniFileName, section: string);
begin
  with TIniFile.Create(iniFileName) do try
    jr.filter := ReadString(section,  'jrcl_filter', jr.filter);
    jr.descr  := ReadString(section,  'jrcl_descr',  jr.descr);
    jr.host   := ReadString(section,  'jrcl_host',   jr.host);
    jr.port   := ReadInteger(section, 'jrcl_port',   jr.port);
    jr.period := ReadInteger(section, 'jrcl_period', jr.period);
    jr.timeout:= ReadInteger(section, 'jrcl_timeout',jr.timeout);
    jr.flags  := ReadInteger(section, 'jrcl_flags',  jr.flags);
    jr.auth   := ReadBool(section,    'jrcl_auth',   jr.auth);
    jr.authKeyName := ReadString(section,  'jrcl_auth_key_name', jr.authKeyName);
  finally
    Free;
  end;
end;

procedure TDataClientJrbustcp.save(iniFileName, section: string);
begin
  with TIniFile.Create(iniFileName) do try
    writeString(section, 'jrcl_filter',  jr.filter);
    writeString(section, 'jrcl_descr',   jr.descr);
    writeString(section, 'jrcl_host',    jr.host);
    writeInteger(section, 'jrcl_port',   jr.port);
    writeInteger(section, 'jrcl_period', jr.period);
    writeInteger(section, 'jrcl_timeout',jr.timeout);
    writeInteger(section, 'jrcl_flags',  jr.flags);
    WriteBool(section, 'jrcl_auth',  jr.auth);
    writeString(section, 'jrcl_auth_key_name', jr.authKeyName);
  finally
    Free;
  end;
end;

procedure TDataClientJrbustcp.setTagFlag(index: Integer;
  value: TWorkRecTagFlag);
begin
  // nope
end;

procedure TDataClientJrbustcp.setValBool(index: Integer; value: Boolean);
begin
  jr.TagTable.get(index).setBool(value);
end;

procedure TDataClientJrbustcp.setValDouble(index: Integer; value: double);
begin
  jr.TagTable.get(index).setDouble(value);
end;

procedure TDataClientJrbustcp.setValInt(index, value: integer);
begin
  jr.TagTable.get(index).setInt(value);
end;

procedure TDataClientJrbustcp.setValLong(index: Integer; value: int64);
begin
  jr.TagTable.get(index).setLong(value);
end;

procedure TDataClientJrbustcp.setValString(index: Integer; value: string);
begin
  jr.TagTable.get(index).setString(value);
end;

function TDataClientJrbustcp.showSettingsDialog: boolean;
begin
  result := jr.showSettingsDialog;
end;

procedure TDataClientJrbustcp.start;
begin
  if started then Exit;
  jr.Connect;
  started := true;
end;

procedure TDataClientJrbustcp.stop;
begin
  if not started then Exit;
  started := false;
  jr.Disconnect;
end;

function TDataClientJrbustcp.getState: string;
begin
  Result := jr.State;
end;

end.
