unit DataClientRpsvrtcp;

interface
uses Forms, Classes, Controls, Windows, Dialogs, stdctrls, sysutils,
  rpTcpClient, rpTcpClientBase, DataClientBase;

type
  TDataClientRpsvrtcp = class(TDataClient)
  private
    rp: TrpTcpClient;
  public
    Constructor Create;
    destructor Destroy; override;

    function getProtocol: integer; override;
    function getClient: TObject; override;

    procedure load(iniFileName: string; section: string); override;
    procedure save(iniFileName: string; section: string); override;
    function showSettingsDialog: boolean; override;

    function getHost: string; override;
    function getPort: integer; override;
    function getFilter: string; override;

    function isConnected: Boolean; override;
    function isNeedReconnect: Boolean; override;
    function getPortConnectBad: Integer; override;
    procedure start; override;
    procedure stop; override;

    function getTagCount: integer; override;
    function getTagName(index: Integer): string; override;
    function getTagIndex(tagname: string): Integer; override;
    function getTagType(index: Integer): Integer; override;

    function getValBool(index: Integer): Boolean; override;
    function getValInt(index: Integer): Integer; override;
    function getValLong(index: Integer): int64; override;
    function getValDouble(index: Integer): Double; override;
    function getValString(index: Integer): string; override;
    function isTagStatusGood(index: Integer): Boolean; override;

    procedure setValBool(index: Integer; value: Boolean); override;
    procedure setValInt(index: Integer; value: integer); override;
    procedure setValLong(index: Integer; value: int64); override;
    procedure setValDouble(index: Integer; value: double); override;
    procedure setValString(index: Integer; value: string); override;

    function getTagExplotable(index: Integer): boolean; override;
    function getTagProp(index: Integer): TWorkRecTagProp; override;
    procedure setTagFlag(index: Integer; value: TWorkRecTagFlag); override;

  end;




implementation

uses TcpPortHolder;



{ TDataClientRpsvrtcp }
constructor TDataClientRpsvrtcp.Create;
begin
    rp := TrpTcpClient.Create;
end;

destructor TDataClientRpsvrtcp.Destroy;
begin
  rp.free;
end;


function TDataClientRpsvrtcp.getClient: TObject;
begin
  Result := rp;
end;

function TDataClientRpsvrtcp.getFilter: string;
begin
  Result := rp.client.TagFilterStr;
end;

function TDataClientRpsvrtcp.getHost: string;
begin
  Result := rp.port.Host;
end;

function TDataClientRpsvrtcp.getPort: integer;
begin
  Result := rp.port.Port;
end;

function TDataClientRpsvrtcp.getPortConnectBad: Integer;
begin
  Result := rp.port.ConnectBad;
end;

function TDataClientRpsvrtcp.getProtocol: integer;
begin
  result := PROTOCOL_RPSVRTCP;
end;

function TDataClientRpsvrtcp.getTagCount: integer;
begin
  Result := rp.client.TagCount;
end;

function TDataClientRpsvrtcp.getTagExplotable(index: Integer): boolean;
begin
  Result := rp.client.Tags[index].Explotable;
end;

function TDataClientRpsvrtcp.getTagIndex(tagname: string): Integer;
begin
  Result := rp.client.getTagIndex(tagname);
end;

function TDataClientRpsvrtcp.getTagName(index: Integer): string;
begin
  Result := rp.client.Tags[index].TagName;
end;

function TDataClientRpsvrtcp.getTagProp(index: Integer): TWorkRecTagProp;
begin
  Result := rp.client.Tags[index].TagProp;
end;

function TDataClientRpsvrtcp.getTagType(index: Integer): Integer;
begin
  result := TAGTYPE_INT;
end;

function TDataClientRpsvrtcp.getValBool(index: Integer): Boolean;
begin
  Result := rp.client.Tags[index].ValIn <> 0;
end;

function TDataClientRpsvrtcp.getValDouble(index: Integer): Double;
begin
  Result := rp.client.Tags[index].ValIn;
end;

function TDataClientRpsvrtcp.getValInt(index: Integer): Integer;
begin
  Result := rp.client.Tags[index].ValIn;
end;

function TDataClientRpsvrtcp.getValLong(index: Integer): int64;
begin
  Result := rp.client.Tags[index].ValIn;
end;

function TDataClientRpsvrtcp.getValString(index: Integer): string;
begin
  Result := IntToStr(rp.client.Tags[index].ValIn);
end;

function TDataClientRpsvrtcp.isTagStatusGood(index: Integer): Boolean;
begin
  result := true;
end;

function TDataClientRpsvrtcp.isConnected: Boolean;
begin
  Result := rp.Connected;
end;

function TDataClientRpsvrtcp.isNeedReconnect: Boolean;
begin
  Result := false;
end;

procedure TDataClientRpsvrtcp.load(iniFileName, section: string);
begin
  rp.Load(iniFileName, section);
end;

procedure TDataClientRpsvrtcp.save(iniFileName, section: string);
begin
  rp.Save(iniFileName, section);
end;

procedure TDataClientRpsvrtcp.setTagFlag(index: Integer;
  value: TWorkRecTagFlag);
begin
  rp.client.Tags[index].TagFlag := value;
end;

procedure TDataClientRpsvrtcp.setValBool(index: Integer; value: Boolean);
begin
  if value then
    rp.client.Tags[index].ValOut := 1
  else
    rp.client.Tags[index].ValOut := 0;
  rp.client.Tags[index].GotOut := True;
end;

procedure TDataClientRpsvrtcp.setValDouble(index: Integer; value: double);
begin
  rp.client.Tags[index].ValOut := Trunc(value);
  rp.client.Tags[index].GotOut := True;
end;

procedure TDataClientRpsvrtcp.setValInt(index, value: integer);
begin
  rp.client.Tags[index].ValOut := value;
  rp.client.Tags[index].GotOut := True;
end;

procedure TDataClientRpsvrtcp.setValLong(index: Integer; value: int64);
begin
  rp.client.Tags[index].ValOut := value and $FFFFFFFF;
  rp.client.Tags[index].GotOut := True;
end;

procedure TDataClientRpsvrtcp.setValString(index: Integer; value: string);
begin
  rp.client.Tags[index].ValOut := StrToIntDef(value, 0);
  rp.client.Tags[index].GotOut := True;
end;

function TDataClientRpsvrtcp.showSettingsDialog: boolean;
begin
  result := rp.EditProp;
end;

procedure TDataClientRpsvrtcp.start;
begin
  rp.Start;
end;

procedure TDataClientRpsvrtcp.stop;
begin
  rp.Stop;
end;

end.
