unit DebugCommands;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, Buttons, Menus, StdCtrls, Mask;

  function executeDebugCommand(cmd: string): string;

implementation
uses
  infodlg,
  AdminMain,
  DataClientJrbustcp,
  TagStorage,
  Numbers,
  UserControlEx,
  main, DataClientBase;

var
  cmdlist: string;

function isCmd(cmd, cmdname, descr: string): Boolean;
begin
  cmd := Trim(UpperCase(cmd));
  cmdname := Trim(UpperCase(cmdname));
  Result := (cmd = cmdname) or (Pos(cmdname + ' ', cmd)=1);
  cmdlist := cmdlist + cmdname + ' - ' + descr + #13#10;
end;

//==============================================================================


// SOUNDS
(*
function doCmdSounds: string;
var
  s: string;
  sl: TStringList;
  i: Integer;
begin
  Result := '';
  sl := TStringList.Create;
  sl.Text := Form1.SndThrd.getMissingSounds();
  for i:=0 to sl.Count-1 do begin
    Result := Result + sl[i] + #13#10;
    Form1.Update;
    Application.ProcessMessages;
    Form1.SndThrd.produceSoundFile(sl[i]);
  end;
  sl.Free;
  Result := Result + 'OK'#13#10;
end;
*)

// USERRULES
function doCmdUserRules: string;
begin
  if modeUserEx then
    result := userEx.getProfileStr
  else
    result := 'UserEx mode is disabled'#13#10;
  Result := Result + 'OK'#13#10;
end;


// BLOKALL
function doCmdBlokAll: string;
var
  FiltStr, s: string;
  i,total,changed: integer;
begin

  if showInfoDlg('    ?', mtConfirmation, mbOKCancel, 0)<>mrOk then
    exit;

  FiltStr := '*_Blok' ;

  i := 0;
  total := 0;
  changed := 0;
  repeat
    s := GetTagName(i);
    if not(s='') then
      if CheckFilter(s, FiltStr) then begin
        if GetTagValue(i) = 0 then begin
          SetTagValue( i, 1 );
          Inc(changed);
        end;
        inc(total);
      end;
    inc(i);
  until s='';

  result :=
    ' : ' + IntToStr(total) +
    #13#10' : ' + IntToStr(changed);
end;



// SETALL
function doCmdSetAll: string;
var
  i: integer;
  value: string;
begin
  if showInfoDlg('        ?',
        mtConfirmation, mbOKCancel, 0)<>mrOk then exit;

  if AdminMainForm.listTags.Selected <> nil then begin
//    v := GetTagValue( integer(AdminMainForm.listTags.Selected.Data) );
    value := GetTagValueString( Integer(AdminMainForm.listTags.Selected.Data));
    for i:=0 to AdminMainForm.listTags.Items.Count-1 do
      SetTagValueString( integer(AdminMainForm.listTags.Items[i].Data), value);
  end;
  Result := Result + 'OK'#13#10;
end;


// EXPORTLIST
function doCmdExportList: string;
var
  i: integer;
  F: TextFile;
  fname: string;
begin
  fname := 'exportlist.txt';
  AssignFile(F, fname);
  Rewrite(F);
  for i:=0 to AdminMainForm.listTags.Items.Count-1 do begin
    writeln(F, Format('%5u: %-48s = %s',
        [i, AdminMainForm.listTags.Items[i].Caption, AdminMainForm.listTags.Items[i].Subitems[LISTTAGS_VALUE]]));
  end;
  CloseFile(F);
  Result := ' ' + fname + ' .';
end;


function doCmdJrbusinfo: string;
var
  cl: TDataClientJrbustcp;
begin
  if not(DataClient is TDataClientJrbustcp) then begin
    Result := '   JrBusTcp';
  end else begin
    cl := TDataClientJrbustcp(DataClient);

    Result :=
      'Started:     ' + iif(cl.Connected, 'YES', 'NO') + #13#10 +
      'Connected:   ' + iif(cl.PortConnectBad = 0, 'YES', 'NO') + #13#10 +
      'Need Recon:  ' + iif(cl.isNeedReconnect, 'YES', 'NO') + #13#10 +
      'State:       ' + cl.getState + #13#10 +
      'Address:     ' + cl.Host + ':' + IntToStr(cl.Port) + #13#10 +
      'Filter:      ' + cl.Filter + #13#10 +
      'Tags count:  ' + IntToStr(cl.TagCount);
  end;
end;


function doCmdCmdLine: string;
begin
    Result :=
      '  :'#13#10 +
      '-INI= '#13#10 +
      '-NOINISAVE -    rpvisual.ini'#13#10 +
      '    (        )'#13#10 +
      ''#13#10 +
      '    :'#13#10 +
      '-X=<>'#13#10 +
      '-Y=<>'#13#10 +
      '-SIZEX=<>'#13#10 +
      '-SIZEY=<>'#13#10 +
      ''#13#10 +
      '-START[= ] -     '#13#10 +
      ''#13#10 +
      '-SCREEN=< > -       ,   '#13#10 +
      ''#13#10 +
      '-SSHUTDOWN -     '#13#10 +
      ''#13#10 +
      '-AUTOCONFIRM -    ';

end;


//==============================================================================
function executeDebugCommand(cmd: string): string;
begin
  Result := '';
  cmdlist := 'Help:'#13#10'====='#13#10;


  if isCmd(cmd, 'exportlist', '  ') then
    Result := doCmdExportList();

  if isCmd(cmd, 'blokall', '  Blok ') then
    Result := doCmdBlokAll();

  if isCmd(cmd, 'jrbusinfo', '  JrBusTcp') then
    Result := doCmdJrbusinfo();

  if isCmd(cmd, 'setall', '       ') then
    Result := doCmdSetAll();

//  if isCmd(cmd, 'sounds', '   ') then
//    Result := doCmdSounds();

  if isCmd(cmd, 'userrules', '   userex') then
    Result := doCmdUserRules();

  if isCmd(cmd, 'cmdline', '     ') then
    Result := doCmdCmdLine();


  if Result = '' then
    Result := cmdlist;
  Result := Result + #13#10;
end;



end.
