// DEPRECATED !!!   .  !

unit EasyImage;


interface

uses
  DesignIntf, DesignEditors,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, stdctrls, consts, ExtDlgs, jpeg;


type

  TEasyImage = class(TGraphicControl)          
  private
    FUseRelativePath: boolean;
    FPicture: TPicture;
    FOnProgress: TProgressEvent;
    FStretch: Boolean;
    FCenter: Boolean;
    FIncrementalDisplay: Boolean;
    FTransparent: Boolean;
    FDrawing: Boolean;
    FProportional: Boolean;
    FPictureFileName: string;
//    FCurAppDir: string;
    function GetCanvas: TCanvas;
    procedure PictureChanged(Sender: TObject);
    procedure SetCenter(Value: Boolean);
    procedure SetPictureFileName(Value: string);
    procedure SetPicture(Value: TPicture);
    procedure SetStretch(Value: Boolean);
    procedure SetTransparent(Value: Boolean);
    procedure SetProportional(Value: Boolean);
  protected
    function CanAutoSize(var NewWidth, NewHeight: Integer): Boolean; override;
    function DestRect: TRect;
    function DoPaletteChange: Boolean;
    function GetPalette: HPALETTE; override;
    procedure Paint; override;
    procedure Progress(Sender: TObject; Stage: TProgressStage;
      PercentDone: Byte; RedrawNow: Boolean; const R: TRect; const Msg: string); dynamic;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Canvas: TCanvas read GetCanvas;
    property Picture: TPicture read FPicture write SetPicture;
  published
    property Align;
    property Anchors;
    property AutoSize;
    property Center: Boolean read FCenter write SetCenter default False;
    property Constraints;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property IncrementalDisplay: Boolean read FIncrementalDisplay write FIncrementalDisplay default False;
    property ParentShowHint;
    property PictureFileName: string read FPictureFileName write SetPictureFileName;
//    property CurAppDir: string read FCurAppDir write FCurAppDir;
    property PopupMenu;
    property Proportional: Boolean read FProportional write SetProportional default false;
    property ShowHint;
    property Stretch: Boolean read FStretch write SetStretch default False;
    property Transparent: Boolean read FTransparent write SetTransparent default False;
    property UseRelativePath: Boolean read FUseRelativePath write FUseRelativePath default False;
    property Visible;
    property OnClick;
    property OnContextPopup;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnProgress: TProgressEvent read FOnProgress write FOnProgress;
    property OnStartDock;
    property OnStartDrag;
  end;

  TImageFilenameProperty = class(TPropertyEditor)
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;

procedure Register;

implementation
var
  tempdir: string;

procedure Register;
begin
  RegisterComponents('Scada', [TEasyImage]);
  RegisterPropertyEditor( TypeInfo(string), TEasyImage, 'PictureFileName', TImageFilenameProperty );
end;

{ TEasyImage }
constructor TEasyImage.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csReplicatable];
  FPicture := TPicture.Create;
  FPicture.OnChange := PictureChanged;
  FPicture.OnProgress := Progress;
  Height := 105;
  Width := 105;
end;

destructor TEasyImage.Destroy;
begin
  FPicture.Free;
  inherited Destroy;
end;

function TEasyImage.GetPalette: HPALETTE;
begin
  Result := 0;
  if FPicture.Graphic <> nil then
        Result := FPicture.Graphic.Palette;
end;

function TEasyImage.DestRect: TRect;
var
  w, h, cw, ch: Integer;
  xyaspect: Double;
begin
  w := Picture.Width;
  h := Picture.Height;
  cw := ClientWidth;
  ch := ClientHeight;
  if Stretch or (Proportional and ((w > cw) or (h > ch))) then
  begin
        if Proportional and (w > 0) and (h > 0) then
        begin
      xyaspect := w / h;
      if w > h then
      begin
        w := cw;
        h := Trunc(cw / xyaspect);
        if h > ch then  // woops, too big
        begin
          h := ch;
          w := Trunc(ch * xyaspect);
        end;
      end
      else
      begin
        h := ch;
        w := Trunc(ch * xyaspect);
        if w > cw then  // woops, too big
        begin
          w := cw;
          h := Trunc(cw / xyaspect);
        end;
      end;
    end
    else
    begin
      w := cw;
      h := ch;
    end;
  end;

  with Result do
  begin
    Left := 0;
    Top := 0;
    Right := w;
    Bottom := h;
  end;

  if Center then
        OffsetRect(Result, (cw - w) div 2, (ch - h) div 2);
end;

procedure TEasyImage.Paint;
var
  Save: Boolean;
begin
  if csDesigning in ComponentState then
        with inherited Canvas do
        begin
          Pen.Style := psDash;
          Brush.Style := bsClear;
          Rectangle(0, 0, Width, Height);
        end;
  Save := FDrawing;
  FDrawing := True;
  try
        with inherited Canvas do
          StretchDraw(DestRect, Picture.Graphic);
  finally
        FDrawing := Save;
  end;
end;

function TEasyImage.DoPaletteChange: Boolean;
var
  ParentForm: TCustomForm;
  Tmp: TGraphic;
begin
  Result := False;
  Tmp := Picture.Graphic;
  if Visible and (not (csLoading in ComponentState)) and (Tmp <> nil) and
        (Tmp.PaletteModified) then
  begin
        if (Tmp.Palette = 0) then
          Tmp.PaletteModified := False
        else
        begin
          ParentForm := GetParentForm(Self);
          if Assigned(ParentForm) and ParentForm.Active and Parentform.HandleAllocated then
          begin
                if FDrawing then
                  ParentForm.Perform(wm_QueryNewPalette, 0, 0)
                else
                  PostMessage(ParentForm.Handle, wm_QueryNewPalette, 0, 0);
                Result := True;
                Tmp.PaletteModified := False;
          end;
        end;
  end;
end;

procedure TEasyImage.Progress(Sender: TObject; Stage: TProgressStage;
  PercentDone: Byte; RedrawNow: Boolean; const R: TRect; const Msg: string);
begin
  if FIncrementalDisplay and RedrawNow then
  begin
        if DoPaletteChange then Update
        else Paint;
  end;
  if Assigned(FOnProgress) then FOnProgress(Sender, Stage, PercentDone, RedrawNow, R, Msg);
end;

function TEasyImage.GetCanvas: TCanvas;
var
  Bitmap: TBitmap;
begin
  if Picture.Graphic = nil then
  begin
        Bitmap := TBitmap.Create;
        try
          Bitmap.Width := Width;
          Bitmap.Height := Height;
          Picture.Graphic := Bitmap;
        finally
          Bitmap.Free;
        end;
  end;
  if Picture.Graphic is TBitmap then
        Result := TBitmap(Picture.Graphic).Canvas
  else
        raise EInvalidOperation.Create(SImageCanvasNeedsBitmap);
end;

procedure TEasyImage.SetCenter(Value: Boolean);
begin
  if FCenter <> Value then
  begin
        FCenter := Value;
        PictureChanged(Self);
  end;
end;

procedure TEasyImage.SetPicture(Value: TPicture);
begin
  FPicture.Assign(Value);
end;

procedure TEasyImage.SetStretch(Value: Boolean);
begin
  if Value <> FStretch then
  begin
        FStretch := Value;
        PictureChanged(Self);
  end;
end;

procedure TEasyImage.SetTransparent(Value: Boolean);
begin
  if Value <> FTransparent then
  begin
        FTransparent := Value;
        PictureChanged(Self);
  end;
end;

procedure TEasyImage.SetProportional(Value: Boolean);
begin
  if FProportional <> Value then
  begin
        FProportional := Value;
        PictureChanged(Self);
  end;
end;

procedure TEasyImage.PictureChanged(Sender: TObject);
var
  G: TGraphic;
  D : TRect;
begin
  if AutoSize and (Picture.Width > 0) and (Picture.Height > 0) then
        SetBounds(Left, Top, Picture.Width, Picture.Height);
  G := Picture.Graphic;
  if G <> nil then
  begin
        if not ((G is TMetaFile) or (G is TIcon)) then
          G.Transparent := FTransparent;
        D := DestRect;
        if (not G.Transparent) and (D.Left <= 0) and (D.Top <= 0) and
           (D.Right >= Width) and (D.Bottom >= Height) then
          ControlStyle := ControlStyle + [csOpaque]
        else  // picture might not cover entire clientrect
          ControlStyle := ControlStyle - [csOpaque];
        if DoPaletteChange and FDrawing then Update;
  end
  else ControlStyle := ControlStyle - [csOpaque];
  if not FDrawing then Invalidate;
end;

function TEasyImage.CanAutoSize(var NewWidth, NewHeight: Integer): Boolean;
begin
  Result := True;
  if not (csDesigning in ComponentState) or (Picture.Width > 0) and
    (Picture.Height > 0) then
  begin
    if Align in [alNone, alLeft, alRight] then
      NewWidth := Picture.Width;
    if Align in [alNone, alTop, alBottom] then
      NewHeight := Picture.Height;
  end;
end;

procedure TEasyImage.SetPictureFileName(Value: string);
begin

  if FUseRelativePath then
    FPictureFileName := ExtractRelativePath(GetCurrentDir+'\', ExtractFilePath(Value)) + ExtractFileName(Value)
  else
    FPictureFileName := value;

  if FileExists(FPictureFileName) then
    try
      FPicture.LoadFromFile(FPictureFileName);
    except
    end;

//  CurAppDir := GetCurrentDir;  
end;








procedure TImageFilenameProperty.Edit;
var
  Dlg: TOpenPictureDialog;
  curdir: string;
begin
  inherited;
  curdir := GetCurrentDir;
  Dlg := TOpenPictureDialog.Create(nil);
//  Dlg.Filter := '(*.jpg;*.gif;*.bmp;*.wmf;*.emf)';
  Dlg.InitialDir := tempdir;
  try
    if Dlg.Execute then begin
      tempdir := ExtractFilePath(Dlg.FileName);
      chdir(curdir);
      SetValue(Dlg.FileName);
    end;
  finally
    Dlg.Free;
  end;
  chdir(curdir);
end;

function TImageFilenameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paMultiSelect ];
end;

function TImageFilenameProperty.GetValue: string;
begin
  result := GetStrValue;
end;

procedure TImageFilenameProperty.SetValue(const Value: string);
begin
  SetStrValue(Value);
end;


end.
