unit InputColorComboDialog;

interface
uses
  InputColorDialog,
  HyperStr,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons, ColorGrd;

type
  TInputColorComboDialogForm = class(TInputColorDialogForm)
  public
    cmb: TComboBox;
    constructor Create(AOwner: TComponent); override;
  end;

  function ShowInputColorComboDialog(ACaption, APrompt, AItems: string; var value: string; var clr: TColor; withDate: Boolean = true): boolean;

implementation


function ShowInputColorComboDialog(ACaption, APrompt, AItems: string; var value: string; var clr: TColor; withDate: Boolean): boolean;
var
  s: string;
  wnd: TInputColorComboDialogForm;
begin
  result := false;
  wnd := TInputColorComboDialogForm.create(nil);
  with wnd do try
    Caption := ACaption;
    lbPrompt.Caption := Aprompt;
    cmb.Items.Text := AItems;

    s := value;
    if withDate then
      Delete(s, 1, 13);
    cmb.ItemIndex := cmb.Items.IndexOf(s);

    SetColor(clr);

    if ShowModal <> mrOk then
      Exit;

    if cmb.Text <> s then begin
      value := cmb.Text;
      if withDate then
        value := format('%s  %s', [FormatDateTime('dd.MM hh:mm', now), value]);
    end;
    
    clr := getColor();
  finally
    Free;
  end;
  result := true;
end;

{ TInputColorComboDialogForm }

constructor TInputColorComboDialogForm.Create(AOwner: TComponent);
begin
  inherited;
  cmb := TComboBox.Create(self);
  cmb.Style := csDropDownList;
  cmb.Parent := Self;
  cmb.Left := edValue.Left;
  cmb.Top := edValue.Top;
  cmb.Width := edValue.Width;
  cmb.Font.Assign(edValue.Font);

  edValue.Visible := false;
end;




end.
