unit InputColorDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons, ColorGrd;

type
  TInputColorDialogForm = class(TForm)
    btOk: TButton;
    btCancel: TButton;
    Bevel1: TBevel;
    edValue: TEdit;
    lbPrompt: TLabel;
    pnl1: TPanel;
    pnl2: TPanel;
    pnl4: TPanel;
    pnl3: TPanel;
    pnl6: TPanel;
    pnl5: TPanel;
    pnl7: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure pnlClick(Sender: TObject);
  private
    { Private declarations }
    pnls: array of TPanel;
  public
    procedure SetColor(clr: integer);
    function GetColor: TColor;
  end;

  function ShowInputColorDialog(ACaption, APrompt: string; var value: string; var clr: TColor): boolean;

implementation
uses
  HyperStr,
  numbers;

{$R *.dfm}

function ShowInputColorDialog(ACaption, APrompt: string; var value: string; var clr: TColor): boolean;
begin
  result := false;
  with TInputColorDialogForm.create(nil) do try
    Caption := ACaption;
    lbPrompt.Caption := Aprompt;
    edValue.Text := value;
    edValue.SelectAll;
    SetColor(clr);
    if ShowModal <> mrOk then Exit;
    value := edValue.Text;
    clr := getColor();
  finally
    Free;
  end;
  result := true;
end;

procedure TInputColorDialogForm.FormCreate(Sender: TObject);
begin
  SetLength(pnls, 7);
  pnls[0] := pnl1;
  pnls[1] := pnl2;
  pnls[2] := pnl3;
  pnls[3] := pnl4;
  pnls[4] := pnl5;
  pnls[5] := pnl6;
  pnls[6] := pnl7;
end;

function TInputColorDialogForm.GetColor: TColor;
var
  i: Integer;
begin
  Result := clBlack;
  for i:=0 to Length(pnls)-1 do begin
    if pnls[i].Caption = '+' then
      result := pnls[i].Color;
  end;
end;


procedure TInputColorDialogForm.SetColor(clr: integer);
var
  i: Integer;
begin
  for i:=0 to Length(pnls)-1 do begin
    if pnls[i].Color = clr then
      pnls[i].Caption := '+'
    else
      pnls[i].Caption := '';
  end;
end;

procedure TInputColorDialogForm.pnlClick(Sender: TObject);
begin
  SetColor((Sender as TPanel).Color);
end;

end.
