unit InputDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons;

type
  TInputDialogForm = class(TForm)
    btOk: TButton;
    btCancel: TButton;
    Bevel1: TBevel;
    edValue: TEdit;
    lbPrompt: TLabel;
    btText: TSpeedButton;
    procedure btTextClick(Sender: TObject);
  private
    memo: TMemo;
    procedure MemoChange(Sender: TObject);
  public
  end;

  function ShowInputDialog(ACaption, APrompt: string; var value: string): boolean;

implementation
uses
  HyperStr,
  numbers;

{$R *.dfm}

function ShowInputDialog(ACaption, APrompt: string; var value: string): boolean;
begin
  result := false;
  with TInputDialogForm.create(nil) do try
    Caption := ACaption;
    lbPrompt.Caption := Aprompt;
    edValue.Text := value;
    edValue.SelectAll;
    if ShowModal <> mrOk then Exit;
    value := edValue.Text;
  finally
    Free;
  end;
  result := true;
end;

procedure TInputDialogForm.btTextClick(Sender: TObject);
const
  width1 = 640;
  height1 = 480;
begin
  Left := Left + (width div 2) - (width1 div 2);
  Top := Top + (Height div 2) - (Height1 div 2);
  Width := width1;
  Height := height1;
  memo := TMemo.Create(self);
  memo.Parent := Self;
  memo.Left := edValue.Left;
  memo.Top := edValue.Top;
  memo.Width := btText.Left + btText.Width - memo.Left;
  memo.Height := Bevel1.Top + Bevel1.Height - memo.Top - edValue.Height;
  memo.Anchors := [akLeft, akTop, akRight, akBottom];
  memo.Text := edValue.Text;
  memo.Font.Name := 'Courier New';
  memo.Font.Size := 10;
  memo.ScrollBars := ssBoth;
  memo.OnChange := MemoChange;
  memo.SetFocus;
  edValue.Visible := False;
end;

procedure TInputDialogForm.MemoChange(Sender: TObject);
begin
  edValue.Text := memo.Text;
end;


end.
