unit MachSeqCfg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Buttons, ExtCtrls, ActnList;

type
  TMachSeqCfgForm = class(TForm)
    Panel2: TPanel;
    btCreate: TBitBtn;
    btCancel: TBitBtn;
    btNew: TButton;
    btEdit: TButton;
    btDel: TButton;
    EditPanel: TPanel;
    Panel4: TPanel;
    edName: TEdit;
    Memo: TMemo;
    Label1: TLabel;
    Panel5: TPanel;
    btEditOk: TButton;
    EditCancelButton: TButton;
    Panel1: TPanel;
    DescrMemo: TMemo;
    Splitter1: TSplitter;
    Tree: TTreeView;
    btGroups: TButton;
    btCheck: TButton;
    btSearch: TButton;
    ActionList: TActionList;
    ActionSearch: TAction;
    btTempl: TButton;
    btAssist: TSpeedButton;
    procedure btCancelClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btCreateClick(Sender: TObject);
    procedure btNewClick(Sender: TObject);
    procedure btEditOkClick(Sender: TObject);
    procedure btEditClick(Sender: TObject);
    procedure EditCancelButtonClick(Sender: TObject);
    procedure btDelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TreeChange(Sender: TObject; Node: TTreeNode);
    procedure btGroupsClick(Sender: TObject);
    procedure btCheckClick(Sender: TObject);
    procedure btSearchClick(Sender: TObject);
    procedure btTemplClick(Sender: TObject);
    procedure btAssistClick(Sender: TObject);
  private
    { Private declarations }
    FindStr: string;

    //         RpVisualIniFile
    MachSeqDir: string;
    MachSeqTagPath: string;
    
    EditFileName: string;
    procedure CreateList;
    function AddMsqItemToTree(T: TTreeNode; sname: string): TTreeNode;
  public
    { Public declarations }
    MachSeqFile: string;
  end;


implementation
uses machseq, MachTmpl, users, main, MachSeqCfg_GetMach;

{$R *.DFM}

procedure TMachSeqCfgForm.FormActivate(Sender: TObject);
begin
  MachSeqDir := CurDir + 'MachSeq\';
  MachSeqTagPath := MachSeq_TagPath;
  MachSeqFile := '';

  CreateList;

  EditPanel.Visible := false;
  Panel2.Visible := not EditPanel.Visible;
end;

function TMachSeqCfgForm.AddMsqItemToTree(T: TTreeNode; sname: string): TTreeNode;
var
  N,G: TTreeNode;
  s: string;
  i,k: integer;
begin
  k := pos('\', sname);
  if k=0 then begin
    N := Tree.Items.AddChild(T, sname);
  end else begin
    s := trim(copy(sname, 1, k-1));
    delete(sname, 1, k);
    sname := trim(sname);
    G := nil;

    for i:=0 to T.Count-1 do
      if T.Item[i].Data = nil then
        if T.Item[i].Text = s then begin
          G := T.Item[i];
          break;
        end;

    if G = nil then begin
      G := Tree.Items.AddChild(T, s);
      G.Data := nil;
    end;

    N := AddMsqItemToTree(G, sname);    
  end;

  result := N;
end;

procedure TMachSeqCfgForm.CreateList;
var
  sr: TSearchRec;
  F: TextFile;
  s: string;
  i,v: integer;
begin
  Tree.Items.Clear;
  Tree.Items.Add(nil, '');
  if FindFirst(MachSeqDir + 'ms????.msq', faAnyFile, sr) = 0 then repeat
    val(copy(sr.Name, 3, 4), v, i);
    if i=0 then begin
      AssignFile(F, MachSeqDir + sr.Name);
      Reset(F);
      Readln(F, s);
      with AddMsqItemToTree(Tree.TopItem, s) do begin
        Data := pointer(v);
        if (MachSeqDir + sr.Name) = EditFileName then Selected := true;
      end;
      CloseFile(F);
    end;
  until FindNext(sr)<>0;
  FindClose(sr);
  Tree.TopItem.Expand(false);
end;


procedure TMachSeqCfgForm.btCancelClick(Sender: TObject);
begin
  close;
end;

procedure TMachSeqCfgForm.btCreateClick(Sender: TObject);
begin
  if Tree.Selected <> nil then
    if Tree.Selected.Data<>nil then begin
      MachSeqFile := format('%sms%.4d.msq', [MachSeqDir, integer(Tree.Selected.Data)]);
      close;
    end;
end;

procedure TMachSeqCfgForm.btNewClick(Sender: TObject);
var
  k,i: integer;
  sr: TSearchRec;
begin
  //*** old password begin ***
  if not UsersControlEnable then begin
  //  CheckEditMode;
  //  if not EditMode_On then exit;
  end else
  //*** old password end ***

  if not CheckAccess(PREVILEG_MSQ_EDIT, true) then exit;

  EditPanel.Visible := true;
  Panel2.Visible := not EditPanel.Visible;
  k := 1;
  repeat
    EditFileName := format('%sms%.4d.msq', [MachSeqDir, k]);
    i := FindFirst(EditFileName, faAnyFile, sr);
    FindClose(sr);
    inc(k);
  until i<>0;

  Memo.Lines.Clear;
end;

procedure TMachSeqCfgForm.btEditClick(Sender: TObject);
var
  s: string;
  F: TextFile;
begin
  //*** old password begin ***
  if not UsersControlEnable then begin
//  CheckEditMode;
//  if not EditMode_On then exit;
  end else
  //*** old password end ***

  if not CheckAccess(PREVILEG_MSQ_EDIT, true) then exit;

  if Tree.Selected <> nil then if Tree.Selected.Data<>nil then begin
    try
      Memo.Lines.Clear;
      EditFileName := format('%sms%.4d.msq', [MachSeqDir, integer(Tree.Selected.Data)]);
      AssignFile(F, EditFileName);
      Reset(F);
      Readln(F, s);
      edName.Text := s;
      while not(eof(F)) do begin
        readln(F, s);
        Memo.Lines.Add(s);
      end;
    except
    end;
    CloseFile(F);

    EditPanel.Visible := true;
    Panel2.Visible := not EditPanel.Visible;
  end;
end;


procedure TMachSeqCfgForm.btEditOkClick(Sender: TObject);
var
  i: integer;
  F: TextFile;
begin
  //  
  if trim(edName.Text) = '' then exit;

  EditPanel.Visible := false;
  Panel2.Visible := not EditPanel.Visible;

  try
    AssignFile(F, EditFileName);
    rewrite(F);
    writeln(F, edName.Text);
    for i:=0 to Memo.Lines.Count-1 do
//      if not(trim(Memo.Lines.Strings[i])='') then
        writeln(F, Memo.Lines.Strings[i]);
  except
    MessageDlg('    !', mtError, [mbOk], 0);
  end;
  CloseFile(F);

  CreateList;
end;


procedure TMachSeqCfgForm.EditCancelButtonClick(Sender: TObject);
begin
  EditPanel.Visible := false;
  Panel2.Visible := not EditPanel.Visible;
end;

procedure TMachSeqCfgForm.btDelClick(Sender: TObject);
begin
  //*** old password begin ***
  if not UsersControlEnable then begin
//  CheckEditMode;
//  if not EditMode_On then exit;
  end else
  //*** old password end ***

  if not CheckAccess(PREVILEG_MSQ_EDIT, true) then exit;

  if Tree.Selected = nil then exit;
  if Tree.Selected.Data = nil then exit;
  if MessageDlg(' ?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then begin
    EditFileName := format('%sms%.4d.msq', [MachSeqDir, integer(Tree.Selected.Data)]);
    if FileExists(EditFileName) then
      DeleteFile(EditFileName);
    CreateList;
  end;  
end;

procedure TMachSeqCfgForm.FormCreate(Sender: TObject);
begin
  FindStr := '';
  Tree.Align := alClient;
  EditPanel.Align := alClient;
end;

procedure TMachSeqCfgForm.TreeChange(Sender: TObject; Node: TTreeNode);
begin
  if Tree.Selected = nil then exit;
  if Tree.Selected.Data = nil then
    DescrMemo.Lines.Clear
  else
    DescrMemo.Lines.LoadFromFile(
          format('%sms%.4d.msq', [MachSeqDir, integer(Tree.Selected.Data)]));
end;

procedure TMachSeqCfgForm.btGroupsClick(Sender: TObject);
var
  s: string;
  F: TextFile;
begin
  //*** old password begin ***
  if not UsersControlEnable then begin
//  CheckEditMode;
//  if not EditMode_On then exit;
  end else
  //*** old password end ***

  if not CheckAccess(PREVILEG_MSQ_EDIT, true) then exit;

  EditFileName := MachSeqDir + MachSeq_GroupsFile;
  Memo.Lines.LoadFromFile(EditFileName);
  edName.Text := '';
  if Memo.Lines.Count>0 then begin
    edName.Text := Memo.Lines.Strings[0];
    Memo.Lines.Delete(0);
  end;

  EditPanel.Visible := true;
  Panel2.Visible := not EditPanel.Visible;
end;


procedure TMachSeqCfgForm.btCheckClick(Sender: TObject);
var
  D: TMachSeq;
  i,k: integer;
  s,fname: string;
  F: TextFile;
  flag: boolean;
begin
  fname := MachSeqDir + 'msq_check.tmp';
  AssignFile(F, fname);
  k := 0;

  for i:=0 to Memo.Lines.Count-1 do begin
    s := Memo.Lines.Strings[i];
    Memo.SetFocus; 
    Memo.SelStart := k;
    Memo.SelLength := length(s);
    Memo.Update; 
    k := k + length(s) + 2;

    Rewrite(F);
    writeln(F, '  ' + IntToStr(i+1));
    writeln(F, s);
    CloseFile(F);

    D := TMachSeq.Create(fname);
    flag := D.LoadSuccess;
    D.Free;
    if not flag then exit;
  end;
  Memo.SelStart := k;
  MessageDlg('  !', mtInformation, [mbOk], 0);
end;


procedure TMachSeqCfgForm.btSearchClick(Sender: TObject);
var
  I, J, PosReturn, SkipChars: Integer;
  OldSelStart: integer;
  NextFlag: boolean;
  FindFlag: boolean;
begin
  if not InputQuery( '', '', FindStr) then exit;

  OldSelStart := Memo.SelStart;
  NextFlag := Memo.SelText = FindStr;
  FindFlag := false;

  for I := 0 to Memo.Lines.Count do begin
    PosReturn := Pos(FindStr,Memo.Lines[I]);
    if PosReturn <> 0 then begin
      Skipchars := 0;
      for J := 0 to I - 1 do
        Skipchars := Skipchars + Length(Memo.Lines[J]);
      SkipChars := SkipChars + (I*2);
      SkipChars := SkipChars + PosReturn - 1;

      if (SkipChars<=OldSelStart) and (NextFlag) then continue;

      Memo.SetFocus;
      Memo.SelStart := SkipChars;
      Memo.SelLength := Length(FindStr);
      FindFlag := true;
      Break;
    end;
  end;

  if not FindFlag then begin
    Memo.SelStart := OldSelStart;
    Memo.SelLength := 0;
    Memo.SetFocus;
    MessageDlg('  .', mtInformation, [mbOk], 0);
  end;

end;

procedure TMachSeqCfgForm.btTemplClick(Sender: TObject);
var
  MachTmplForm: TMachTmplForm;
begin
  //*** old password begin ***
  if not UsersControlEnable then begin
  CheckAdminMode;
  if not AdminMode_On then exit;
  end else
  //*** old password end ***

  if not CheckAccess(PREVILEG_MSQ_SM_EDIT, true) then exit;

  MachTmplForm := TMachTmplForm.Create(self);
  MachTmplForm.ShowModal;
  MachTmplForm.Free;
end;

procedure TMachSeqCfgForm.btAssistClick(Sender: TObject);
var
  MachSeqCfg_GetMachForm: TMachSeqCfg_GetMachForm;
  s: string;
  i: integer;
begin
  MachSeqCfg_GetMachForm := TMachSeqCfg_GetMachForm.Create(self);
  try
    MachSeqCfg_GetMachForm.ShowModal;
    if length(MachSeqCfg_GetMachForm.resultstr)>0 then begin
      s := memo.Text;
      i := memo.SelStart;
      system.insert( MachSeqCfg_GetMachForm.resultstr, s, i+1 );
      memo.Text := s;
      memo.SelStart := i + length(MachSeqCfg_GetMachForm.resultstr);
//      memo.SelLength := length(s);
    end;
  finally
    MachSeqCfg_GetMachForm.Free;
  end;


end;

end.
