unit MachSeqCfg_GetMach;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, StdCtrls, Buttons;

type
  TMachSeqCfg_GetMachForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Panel1: TPanel;
    listMach: TListView;
    Panel2: TPanel;
    listGroup: TListView;
    BitBtn1: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure listMachDblClick(Sender: TObject);
    procedure listGroupDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    resultstr: string;
  end;


implementation
uses
  tagstorage, numbers, main;

var
  resultstr_prev: string;

{$R *.dfm}

procedure TMachSeqCfg_GetMachForm.FormActivate(Sender: TObject);
var
  i,k: integer;
  s,ss: string;
  F: TextFile;
begin
  resultstr := '';

  // Mach'
  listMach.Items.Clear;
  i:=0;
  repeat
    s := GetTagName(i);
    if s='' then break;

    if CheckFilter(s, '*.MCTL_*_Control') then begin
      k := pos('.MCTL_', s);
      delete(s, 1, k+5);
      k := pos('_Control', s);
      delete(s, k, 8);
      with listMach.Items.Add do begin
        Caption := s;
      end;
    end;

    inc(i);
  until false;
  listMach.AlphaSort;

  for i:=0 to listMach.Items.Count-1 do
    if SameText(listMach.Items[i].Caption, resultstr_prev) then
      listMach.Selected := listMach.Items[i];
  if (listMach.Items.Count>0) and (listMach.Selected<>nil) then listMach.Selected.MakeVisible(true);



  // 
  AssignFile(F, CurDir + 'MachSeq\'+MachSeq_GroupsFile);
  try
    reset(F);
    while not(eof(F)) do begin
      readln(F, s);
      s := trim(s);
      if not(copy(s,1,6)='#GROUP') then continue;
      delete(s,1,6);
      s := trim(s);

      ss := '';
      if not(eof(F)) then begin
        readln(F, ss);
        ss := trim(ss);
        if copy(ss,1,2)='//' then
          delete(ss,1,2)
        else
          ss := '';  
      end;

      with listGroup.Items.Add do begin
        Caption := s;
        SubItems.add(ss);
      end;

    end;
  except
  end;
  CloseFile(F);

  listGroup.AlphaSort;

  for i:=0 to listGroup.Items.Count-1 do
    if SameText(listGroup.Items[i].Caption, resultstr_prev) then
      listGroup.Selected := listGroup.Items[i];
  if (listGroup.Items.Count>0) and (listGroup.Selected<>nil) then listGroup.Selected.MakeVisible(true);


end;

procedure TMachSeqCfg_GetMachForm.listMachDblClick(Sender: TObject);
begin
  if listMach.Selected=nil then exit;
  resultstr := listMach.Selected.Caption;
  resultstr_prev := resultstr;
  Close;
end;

procedure TMachSeqCfg_GetMachForm.listGroupDblClick(Sender: TObject);
begin
  if listGroup.Selected=nil then exit;
  resultstr := '['+listGroup.Selected.Caption+']';
  resultstr_prev := listGroup.Selected.Caption;
  Close;
end;

end.
