unit MachTmpl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons;

type
  TMachTmplForm = class(TForm)
    Panel1: TPanel;
    Memo: TMemo;
    Label1: TLabel;
    edFileName: TEdit;
    btOpen: TSpeedButton;
    btSave: TSpeedButton;
    Label2: TLabel;
    edPrms: TEdit;
    btTest: TSpeedButton;
    OpenDialog: TOpenDialog;
    btClose: TBitBtn;
    TestMemo: TMemo;
    procedure btOpenClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btSaveClick(Sender: TObject);
    procedure btTestClick(Sender: TObject);
  private
  public
    fname: string;
  end;

implementation
uses MarshSearch;

{$R *.DFM}

//============================================================================
//  
//============================================================================
procedure TMachTmplForm.btOpenClick(Sender: TObject);
var
  OldDir: string;
begin
  OldDir := GetCurrentDir;
  OpenDialog.InitialDir := CurDir + 'MachSeq\';
  OpenDialog.FileName := '';
  if OpenDialog.Execute then begin
    if UpperCase(ExtractFilePath(OpenDialog.FileName))=UpperCase(CurDir + 'MachSeq\') then begin
      fname := OpenDialog.FileName;
      edFileName.Text := ExtractFileName(fname);
      Memo.Lines.LoadFromFile(fname)
    end else
      ShowMessage('!');

  end;
  ChDir(OldDir);
end;

procedure TMachTmplForm.btCloseClick(Sender: TObject);
begin
  close;
end;

procedure TMachTmplForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  k: integer;
begin
  if Memo.Modified then begin
    k := MessageDlg(' ?', mtConfirmation, mbYesNoCancel, 0);

    if k = mrYes then begin
      btSaveClick(nil);
      CanClose := not Memo.Modified;
    end;

    if k = mrNo then CanClose := true;

    if k = mrCancel then CanClose := false;

  end;
end;

procedure TMachTmplForm.btSaveClick(Sender: TObject);
var
  s: string;
begin
  s := trim(edFileName.Text);

  if s='' then begin
    MessageDlg('  !', mtError, [mbOk], 0);
    exit;
  end;

  s := CurDir + 'MachSeq\' + s;
  if (not(s=fname)) and (FileExists(s)) then
    if MessageDlg('  ! ?', mtConfirmation,
          mbOKCancel, 0) <> mrOk then exit;

  Memo.Lines.SaveToFile(s);
  fname := s;
  Memo.Modified := false;
end;

//============================================================================
//  
//============================================================================
procedure TMachTmplForm.btTestClick(Sender: TObject);
var
  i: integer;
  s: string;
begin
  if btTest.Down then begin
    s := fname;

    if Memo.Modified then begin
      MessageDlg('    !', mtInformation, [mbOk], 0);
      exit;
    end;

    if not FileExists(s) then begin
      MessageDlg(' ' + s + '  !', mtInformation, [mbOk], 0);
      exit;
    end;

    FindAndCreateMarsh(trim(edPrms.Text),'//'#13#10,i,s);
    TestMemo.Lines.LoadFromFile(s);
  end;

  TestMemo.Visible := btTest.Down;
end;

end.
