unit MesFilterSetup;

interface

uses
  HyperStr,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, Buttons, Menus, StdCtrls, Mask;

type
  TMesFilterSetupForm = class(TForm)
    AdminPageControl: TPageControl;
    TabSheet2: TTabSheet;
    Panel11: TPanel;
    Splitter2: TSplitter;
    memoMesFilterTest: TMemo;
    memoMesFilterRules: TMemo;
    btMesFilterTest: TButton;
    btMesFilterApply: TButton;
    btMesFilterCancel: TButton;
    Memo3: TMemo;
    procedure FormActivate(Sender: TObject);
    procedure btMesFilterCancelClick(Sender: TObject);
    procedure btMesFilterApplyClick(Sender: TObject);
    procedure btMesFilterTestClick(Sender: TObject);
  end;

var
  MesFilterSetupForm: TMesFilterSetupForm;


implementation
uses
  main,
  _PrjProcs,
  RpVisualGlobal,
  RpVisualMain,
  rpVisualParams,
  RpVisualIni,
  MesLogging,
  MesLoggingV1;


{$R *.DFM}


procedure TMesFilterSetupForm.FormActivate(Sender: TObject);
var
  sl: TStringList;
begin
  // prepare mes filter memo
  sl := TStringList.Create;
  saveMesFilterToList(sl);
  memoMesFilterRules.Text := sl.Text;
  sl.Free;

  WindowState := wsMaximized;
end;


procedure TMesFilterSetupForm.btMesFilterCancelClick(Sender: TObject);
var
  sl: TStringList;
begin
  sl := TStringList.Create;
  saveMesFilterToList(sl);
  memoMesFilterRules.Text := sl.Text;
  sl.Free
end;


procedure TMesFilterSetupForm.btMesFilterApplyClick(Sender: TObject);
var
  sl: TStringList;
begin
  sl := TStringList.Create;
  sl.Text := memoMesFilterRules.Text;
  loadMesFilterFromList(sl);
  saveMesFilterToIni;
  if Sender <> nil then
    rescanMesFilter;
  sl.Free
end;


procedure TMesFilterSetupForm.btMesFilterTestClick(Sender: TObject);
var
  i,j: integer;
  msgname_printed: boolean;
  sl: TStringList;
  tagname,descr: string;
begin
  sl := TStringList.Create;
  saveMesFilterToList(sl);
  btMesFilterApplyClick(nil);

  memoMesFilterTest.Lines.Clear;
  for i:=0 to length(Mess)-1 do begin
    msgname_printed := false;
    for j:=0 to length(Mess[i].Tags)-1 do begin
      if checkMesFilter(i,j) then begin
        if not msgname_printed then begin
          msgname_printed := true;
          memoMesFilterTest.Lines.Add(mess[i].Name);
        end;

        tagname := mess[i].tags[j].Name;
        descr := mess[i].tags[j].Descr;
        memoMesFilterTest.Lines.Add('    ' + tagname + StringOfChar(' ', 50-Length(tagname) ) + descr);
      end;
    end;
  end;
  loadMesFilterFromList(sl);
  sl.Free;
end;




end.
