unit MesLogging;

interface
uses
  Classes;


  function ConnectToMesLogging(silent: Boolean = false): boolean;
  procedure DisconnectFromMesLogging;
  function checkMesloggingAlive: boolean;

  procedure SaveMessage(MesId: integer; TagName: string; Data: string);
  procedure SaveMessageText(MsgText: string; ObjName: string; Text: string;
          BckgColor: integer = 16777215; FontColor: integer = 0);

  procedure UpdateMesLogging;
  procedure AcknoledgeMes;
  procedure AcknoledgeMesAll;
  procedure ClearMesBar;

  function hasMesActive: boolean;
  function isMesActiveAcknowledged: boolean;
  function isMesConnected: boolean;

  procedure showMesMonitor;
  procedure showMesView;

  procedure setupCurPlaceId;
  procedure updateOrInsertCurUser;
  procedure setupFilterPlaces;
  function getExistingPlaceNames: string;

  procedure addAlarmResetTag(tagname: string; placename: string);


implementation
uses
  MesLoggingCommon,
  RpVisualGlobal,
  MesLoggingV1,
  MesLoggingV2;


function ConnectToMesLogging(silent: Boolean = false): boolean;
begin
  if useMesloggingV2 then
    Result := MesLoggingV2.ConnectMeslogging(silent)
  else
    Result := MesLoggingV1.ConnectToMesLogging(silent);
end;


procedure DisconnectFromMesLogging;
begin
  if useMesloggingV2 then
    MesLoggingV2.DisconnectMeslogging
  else
    MesLoggingV1.DisconnectFromMesLogging;
end;


function checkMesloggingAlive: boolean;
begin
  if useMesloggingV2 then
    Result := MesLoggingV2.checkMesloggingAlive
  else
    Result := MesLoggingV1.checkMesloggingAlive;
end;


procedure SaveMessageText(MsgText: string; ObjName: string; Text: string; BckgColor: integer = 16777215; FontColor: integer = 0);
begin
  if useMesloggingV2 then
    MesLoggingV2.SaveMessageText(MsgText, ObjName, Text, BckgColor, FontColor)
  else
    MesLoggingV1.SaveMessageText(MsgText, ObjName, Text, BckgColor, FontColor);
end;


procedure SaveMessage(MesId: integer; TagName: string; Data: string);
begin
  if useMesloggingV2 then
    MesLoggingV2.SaveMessage(MesId, TagName, Data)
  else
    MesLoggingV1.SaveMessage(MesId, TagName, Data);
end;



procedure UpdateMesLogging;
begin
  if useMesloggingV2 then
    MesLoggingV2.UpdateMesLogging
  else
    MesLoggingV1.UpdateMesLogging;
end;


procedure AcknoledgeMes;
begin
  if useMesloggingV2 then
    MesLoggingV2.AcknoledgeLastMessage
  else
    MesLoggingV1.AcknoledgeMes;
end;



procedure ClearMesBar;
begin
  if useMesloggingV2 then
    MesLoggingV2.ClearMesBar
  else
    MesLoggingV1.ClearMesBar;
end;


procedure AcknoledgeMesAll;
begin
  if not useMesloggingV2 then
    MesLoggingV1.AcknoledgeMesAll;
end;




function hasMesActive: boolean;
begin
  if useMesloggingV2 then
    result := False
  else
    result := MesLoggingV1.hasMesActive;
end;

function isMesActiveAcknowledged: boolean;
begin
  if useMesloggingV2 then
    result := false
  else
    result := MesLoggingV1.isMesActiveAcknowledged;
end;

function isMesConnected: boolean;
begin
  if useMesloggingV2 then
    result := MesLoggingV2.isMesConnected
  else
    result := MesLoggingV1.isMesConnected;
end;


procedure showMesMonitor;
begin
  if useMesloggingV2 then
    MesLoggingV2.showMesMonitor
  else
    MesLoggingV1.showMesMonitor;
end;


procedure showMesView;
begin
  if useMesloggingV2 then
    MesLoggingV2.showMesView
  else
    MesLoggingV1.showMesView;
end;


procedure setupCurPlaceId;
begin
  MesLoggingCommon.setupCurPlaceId;
end;

procedure updateOrInsertCurUser;
begin
  MesLoggingCommon.updateOrInsertCurUser;
end;

procedure setupFilterPlaces;
begin
  MesLoggingCommon.setupFilterPlaces;
end;

function getExistingPlaceNames: string;
begin
  Result := MesLoggingCommon.getExistingPlaceNames;
end;


procedure addAlarmResetTag(tagname: string; placename: string);
begin
  MesLoggingV2.addAlarmResetTag(tagname, placename);
end;


end.
