unit MesLoggingCommon;

interface
uses HyperStr, SysUtils, Classes, FIBQuery, Dialogs;


  procedure setupCurPlaceId;
  procedure updateOrInsertCurUser;
  procedure setupFilterPlaces;
  function getExistingPlaceNames: string;

implementation
uses
  connecting,
  MesLogging,
  RpVisualGlobal,
  DbUtils,
  DataMod;


procedure setupCurPlaceId;
begin
  if not isMesloggingConnected then exit;

  CurPlaceId := 0;
  CurPlaceName := trim(CurPlaceName);

  if CurPlaceName = '' then Exit;

  try
    dm.WrQueryMes.Transaction.StartTransaction;
    dm.WrQueryMes.SQL.Text := 'SELECT ID FROM PLACES WHERE NAME=''' + CurPlaceName + '''';
    dm.WrQueryMes.ExecQuery;
    CurPlaceId := dm.WrQueryMes.Fields[0].AsInteger;
    dm.WrQueryMes.Close;
    dm.WrQueryMes.Transaction.Commit;

    if CurPlaceId <= 0 then begin
      dm.WrQueryMes.Transaction.StartTransaction;
      CurPlaceId := GenerateId('GEN_PLACES_ID', dm.WrQueryMes);
      dm.WrQueryMes.SQL.Text := 'INSERT INTO PLACES(ID, NAME) VALUES (' +
            inttostr(CurPlaceId)+', ''' + CurPlaceName + ''')';
      dm.WrQueryMes.ExecQuery;
      dm.WrQueryMes.Transaction.Commit;
    end;
  except
    dm.WrQueryMes.Transaction.Active := false;
    CurPlaceId := 0;
  end;
end;

procedure updateOrInsertCurUser;
var
  flag: boolean;
  maxid: integer;
begin
  if not isMesloggingConnected then exit;
  if (CurUserName = '') or (CurUserId = 0) then Exit;

  try
    dm.WrQueryMes.Transaction.StartTransaction;
    dm.WrQueryMes.SQL.Text := 'SELECT IDUSER, NAME FROM USERS WHERE IDUSER=' + inttostr(CurUserId);
    dm.WrQueryMes.ExecQuery;
    flag := (dm.WrQueryMes.Fields[0].AsInteger <> CurUserId) or
            (dm.WrQueryMes.Fields[1].AsString <> CurUserName);
    dm.WrQueryMes.Close;

    if flag then begin
      dm.WrQueryMes.SQL.Text := 'update or insert into users (iduser, name) values (' +
            IntToStr(CurUserId) + ', ''' + CurUserName + ''')';
      dm.WrQueryMes.ExecQuery;
      dm.WrQueryMes.Close;

      dm.WrQueryMes.SQL.Text := 'SELECT max(IDUSER) FROM USERS';
      dm.WrQueryMes.ExecQuery;
      maxid := dm.WrQueryMes.Fields[0].AsInteger;
      dm.WrQueryMes.Close;

      dm.WrQueryMes.SQL.Text := 'ALTER SEQUENCE GEN_USERS_ID RESTART WITH ' + inttostr(maxid);
      dm.WrQueryMes.ExecQuery;
      dm.WrQueryMes.Close;
    end;

    dm.WrQueryMes.Transaction.Commit;
  except
    dm.WrQueryMes.Transaction.Active := false;
  end;
end;


procedure setupFilterPlaces;
var
  i: Integer;
  placenames, s: string;
begin
  filterPlaceIds := '';
  placenames := Trim(filterPlaceNames);
  if filterPlaceNames = '' then
    Exit;
  placenames := placenames + ',' + CurPlaceName;

  SetDelimiter(',');
  i:=1;
  try
    dm.QueryMes.Transaction.StartTransaction;
    repeat
      s := Trim(GetToken(placenames, i));
      dm.QueryMes.SQL.Text := 'SELECT ID FROM PLACES WHERE NAME=''' + s + '''';
      dm.QueryMes.ExecQuery;
      if not dm.QueryMes.eof then
        filterPlaceIds := filterPlaceIds + iif(filterPlaceIds='', '', ',') + dm.QueryMes.Fields[0].AsString;
      dm.QueryMes.Close;
    until not NextToken(placenames, i);
    dm.QueryMes.Transaction.Commit;
  except
    dm.QueryMes.Transaction.Active := false;
  end;
end;


function getExistingPlaceNames: string;
var
  s: string;
begin
  Result := '';
  if not isMesloggingConnected then exit;

  s := '';
  try
    dm.QueryMes.Transaction.StartTransaction;
    dm.QueryMes.SQL.Text := 'SELECT NAME FROM PLACES ORDER BY 1';
    dm.QueryMes.ExecQuery;
    while not dm.QueryMes.Eof do begin
      if s<>'' then
        s := s + ', ';
      s := s + dm.QueryMes.Fields[0].AsString;
      dm.QueryMes.Next;
    end;
    dm.QueryMes.Close;
    dm.QueryMes.Transaction.Commit;
  except
    dm.QueryMes.Transaction.Active := false;
  end;
  result := s;
end;

end.
