unit MesLoggingDBCheck;

interface

uses 
  pFIBDatabase, 
  pFIBQuery, 
  Classes, 
  dialogs, 
  sysutils;

  procedure CheckDatabase(AQuery: TpFIBQuery);



implementation

uses 
  dbutils,
  FIBQuery;

var
  Passed: boolean = false;


procedure CheckDatabase(AQuery: TpFIBQuery);
begin
  dbutils.qry := AQuery;

  if Passed then exit;
  Passed := true;



  //    ROOTS
  if not table_exist('PLACES') then begin
    do_sql('CREATE GENERATOR GEN_PLACES_ID');

    do_sql('CREATE TABLE PLACES (ID INTEGER NOT NULL, NAME  VARCHAR(32))');

    do_sql('ALTER TABLE PLACES ADD CONSTRAINT PK_PLACES PRIMARY KEY (ID)');

    do_sql('CREATE OR ALTER TRIGGER PLACES_BI FOR PLACES        '#13#10+
           'ACTIVE BEFORE INSERT POSITION 0                     '#13#10+
           'AS                                                  '#13#10+
           'BEGIN                                               '#13#10+
           '  IF (NEW.ID IS NULL) THEN                          '#13#10+
           '    NEW.ID = GEN_ID(GEN_PLACES_ID,1);               '#13#10+
           'END                                                 ');

    do_sql('ALTER TABLE MESSAGES ADD IDUSER INTEGER');
    do_sql('ALTER TABLE MESSAGES ADD IDPLACE INTEGER');

    do_sql('CREATE INDEX MESSAGES_IDUSER ON MESSAGES (IDUSER)');
    do_sql('CREATE INDEX MESSAGES_IDPLACE ON MESSAGES (IDPLACE)');
  end;


end;

end.
