unit MesMonitor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ComCtrls, ExtCtrls, ImgList;

type
  TMesMonitorForm = class(TForm)
    List: TListView;
    BitBtn1: TBitBtn;
    CancelButton: TButton;
    procedure FormActivate(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure ListDrawItem(Sender: TCustomListView; Item: TListItem;
      Rect: TRect; State: TOwnerDrawState);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MesMonitorForm: TMesMonitorForm = nil;

implementation
uses
  MesLoggingV1,
  main;

{$R *.DFM}

function DateSortProc(Item1, Item2: TListItem; ParamSort: integer): integer; stdcall;
var
  d1,d2: TDateTime;
begin
  d1 := StrToDateTime(Item1.Caption);
  d2 := StrToDateTime(Item2.Caption);
  if d1 - d2 < 0 then
    Result := 1
  else if d1 - d2 > 0 then
    Result := -1
  else
    Result := 0;
end;

procedure TMesMonitorForm.FormActivate(Sender: TObject);
var
  i,j,k,clb,clf: integer;
  s: string;
  CanBeDisp, CanWentOut: boolean;
begin

  k := 0;
  for i:=0 to length(Mess)-1 do begin
    CanBeDisp := (Mess[i].Alarm and 2) = 0;
    CanWentOut := (Mess[i].Alarm and 8) = 0;

    for j:=0 to length(Mess[i].Tags)-1 do
      if (Mess[i].Tags[j].State > 0) and (CanBeDisp) and ((CanWentOut) or (Mess[i].Tags[j].State in [1,3])) then begin
//      if Mess[i].Tags[j].State > 0 then begin

        if k >= List.Items.Count then begin
          List.Items.Add;
          List.Items[k].SubItems.Add('');
          List.Items[k].SubItems.Add('');
          List.Items[k].SubItems.Add('');
          List.Items[k].SubItems.Add('');
        end;

        List.Items[k].Caption := DateTimeToStr(Mess[i].Tags[j].DT);
        List.Items[k].SubItems[0] := Mess[i].Name + ': ' + Mess[i].Tags[j].Descr;

        clb := clWhite;
        clf := clBlack;
        case Mess[i].Tags[j].State of
        1: begin
             clb := TColor(Mess[i].Clb_inp);
             clf := TColor(Mess[i].Clf_inp);
             s := '';
           end;
        2: begin
             clb := TColor(Mess[i].Clb_out);
             clf := TColor(Mess[i].Clf_out);
             s := '';
           end;
        3: begin
             clb := TColor(Mess[i].Clb_ack);
             clf := TColor(Mess[i].Clf_ack);
             s := '';
           end;
        end;
        List.Items[k].SubItems[1] := s;

        List.Items[k].SubItems[2] :=  IntToStr(clb);
        List.Items[k].SubItems[3] := IntToStr(clf);

        inc(k);
      end;
  end;

  while k < List.Items.Count do
    List.Items.Delete(k);

  List.CustomSort(@DateSortProc, 0);

end;

procedure TMesMonitorForm.CancelButtonClick(Sender: TObject);
begin
  close;
end;

procedure TMesMonitorForm.ListDrawItem(Sender: TCustomListView;
  Item: TListItem; Rect: TRect; State: TOwnerDrawState);
var
  i,k: integer;
begin

  List.Canvas.Brush.Color := StrToInt(Item.SubItems[2]);
  List.Canvas.Font.Color := StrToInt(Item.SubItems[3]);
  List.Canvas.FillRect(Rect);
  k := Rect.Left;
  List.Canvas.TextOut( k+5, Rect.Top, Item.Caption);
  for i:=0 to List.Columns.Count-2 do begin
    k := k + List.Columns[i].Width;
    List.Canvas.TextOut(k, Rect.Top, ' ' + Item.SubItems[i]);
  end;

  List.Canvas.Pen.Color := clBtnShadow;
  List.Canvas.MoveTo(Rect.Left, Rect.Bottom-1);
  List.Canvas.LineTo(Rect.Right, Rect.Bottom-1);

end;

procedure TMesMonitorForm.BitBtn1Click(Sender: TObject);
begin
  AcknoledgeMesAll;
  Form1.PanelMesTextClick(Form1.PanelMesText);
  close;
end;

end.
