unit MesMonitorV2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ComCtrls, ExtCtrls, ImgList, GridsEh, DBGridEh,
  FIBDatabase, pFIBDatabase, DB, FIBDataSet, pFIBDataSet;

type
  TMesMonitorV2Form = class(TForm)
    btAckAll: TBitBtn;
    btCancel: TButton;
    grid: TDBGridEh;
    dsrc: TDataSource;
    ds: TpFIBDataSet;
    trnr: TpFIBTransaction;
    trnw: TpFIBTransaction;
    pFIBDatabase1: TpFIBDatabase;
    dsIDM: TFIBIntegerField;
    dsORD: TFIBBCDField;
    dsDT: TFIBDateTimeField;
    dsDTEND: TFIBDateTimeField;
    dsDTACK: TFIBDateTimeField;
    dsIDPLACE: TFIBIntegerField;
    dsPLACENAME: TFIBstringField;
    dsIDUSER: TFIBIntegerField;
    dsUSERNAME: TFIBstringField;
    dsCLB: TFIBIntegerField;
    dsCLF: TFIBIntegerField;
    btAck: TBitBtn;
    dsFULLTEXT: TFIBstringField;
    procedure btCancelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure gridGetCellParams(Sender: TObject; Column: TColumnEh;
      AFont: TFont; var Background: TColor; State: TGridDrawState);
    procedure btAckClick(Sender: TObject);
    procedure btAckAllClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    procedure updateMesMonitor;
  end;

  procedure showMesMonitor;
  procedure updateMesMonitor;

var
  MesMonitorV2Form: TMesMonitorV2Form;

  lastTop: integer = 0;
  lastLeft: integer = 0;
  lastWidth: integer = 0;
  lastHeight: integer = 0;

implementation
uses
  Numbers,
  MesLoggingV2,
  RpVisualGlobal,
  DataMod,
  main;

{$R *.DFM}
var
  updateEnabled: boolean = true;

procedure showMesMonitor;
begin
  if MesMonitorV2Form = nil then begin
    MesMonitorV2Form := TMesMonitorV2Form.Create(Form1);
  end;

  MesMonitorV2Form.ShowModal;
end;

procedure updateMesMonitor;
begin
  if (MesMonitorV2Form <> nil) and (updateEnabled) then
    MesMonitorV2Form.updateMesMonitor;
end;

procedure TMesMonitorV2Form.FormCreate(Sender: TObject);
begin
  if filterPlaceIds <> '' then
    ds.SelectSQL.add('where idplace in (' + filterPlaceIds + ')');

  try
    trnr.DefaultDatabase := dm.pFIBDbMes;
    trnw.DefaultDatabase := dm.pFIBDbMes;
    ds.Database := dm.pFIBDbMes;
    ds.Active := true;
  except
  end;
end;

procedure TMesMonitorV2Form.btCancelClick(Sender: TObject);
begin
  close;
end;

procedure TMesMonitorV2Form.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  MesMonitorV2Form := nil;

  lastTop := Top;
  lastLeft := Left;
  lastWidth := Width;
  lastHeight := Height;
end;


procedure TMesMonitorV2Form.gridGetCellParams(Sender: TObject;
  Column: TColumnEh; AFont: TFont; var Background: TColor;
  State: TGridDrawState);
var
  clb, clf: integer;
begin
  if not dsDTACK.IsNull then begin
    clb := MES_COLOR_BACK_ACKNOWLEDGED;
    clf := MES_COLOR_FONT_ACKNOWLEDGED;
  end else if not dsDTEND.IsNull then begin
    clb := MES_COLOR_BACK_FINISHED;
    clf := MES_COLOR_FONT_FINISHED;
  end else if not dsDT.IsNull then begin
    clb := dsCLB.AsInteger;
    clf := dsCLF.AsInteger;
  end else begin
    clb := clWhite;
    clf := clBlack;
  end;
  Background := clb;
  AFont.Color := clf;
end;

procedure TMesMonitorV2Form.updateMesMonitor;
//var
//  idm: integer;
begin
//  idm := dsIDM.AsInteger;
  ds.ReopenLocate('IDM');
end;


procedure TMesMonitorV2Form.btAckClick(Sender: TObject);
begin
  AcknoledgeMessage(dsIDM.AsInteger, dsIDPLACE.AsInteger);
end;

procedure TMesMonitorV2Form.btAckAllClick(Sender: TObject);
begin
  AcknoledgeAllMessages;
//  updateEnabled := false;
//  ds.First;
//  while not ds.eof do begin
//    AcknoledgeMessage(dsIDM.AsInteger, dsIDPLACE.AsInteger);
//    ds.Next;
//  end;
//  updateEnabled := true;
//  close;
end;

procedure TMesMonitorV2Form.FormActivate(Sender: TObject);
begin
  if lastWidth > 0 then begin
    top := lastTop;
    left := lastLeft;
    Width := lastWidth;
    Height := lastHeight;
  end;
end;

end.
