unit MesSound;

interface
uses
  MMSystem;

  procedure updatePlaySound(needPlaySound: boolean);

implementation
uses
  RpVisualGlobal;

var
  playingSound: boolean = false;


procedure updatePlaySound(needPlaySound: boolean);
begin
  if (needPlaySound) and (not playingSound) then begin
    if canMessagePlaySound then
      sndPlaySound(pansichar(messageSoundFileName), SND_NODEFAULT Or SND_ASYNC Or SND_LOOP);
  end else
  if (not needPlaySound) and (playingSound) then begin
    sndPlaySound(nil, 0);
  end;
  playingSound := needPlaySound;
end;

end.
