unit MesViewV2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ComCtrls, ExtCtrls, ImgList, GridsEh, DBGridEh,
  FIBDatabase, pFIBDatabase, DB, FIBDataSet, pFIBDataSet;

type
  TMesViewV2Form = class(TForm)
    btCancel: TButton;
    grid: TDBGridEh;
    dsrc: TDataSource;
    ds: TpFIBDataSet;
    trnr: TpFIBTransaction;
    trnw: TpFIBTransaction;
    pFIBDatabase1: TpFIBDatabase;
    dsIDM: TFIBIntegerField;
    dsDT: TFIBDateTimeField;
    dsDTEND: TFIBDateTimeField;
    dsDTACK: TFIBDateTimeField;
    dsIDPLACE: TFIBIntegerField;
    dsPLACENAME: TFIBstringField;
    dsIDUSER: TFIBIntegerField;
    dsUSERNAME: TFIBstringField;
    dsFULLTEXT: TFIBstringField;
    dsCLB: TFIBIntegerField;
    dsCLF: TFIBIntegerField;
    dt: TDateTimePicker;
    btBackward: TSpeedButton;
    btForward: TSpeedButton;
    btToday: TSpeedButton;
    dsACT: TFIBstringField;
    btPrint: TSpeedButton;
    procedure btCancelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure gridGetCellParams(Sender: TObject; Column: TColumnEh;
      AFont: TFont; var Background: TColor; State: TGridDrawState);
    procedure dtChange(Sender: TObject);
    procedure btBackwardClick(Sender: TObject);
    procedure btForwardClick(Sender: TObject);
    procedure btTodayClick(Sender: TObject);
    procedure gridColumns1GetCellParams(Sender: TObject; EditMode: Boolean;
      Params: TColCellParamsEh);
    procedure gridApplyFilter(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btPrintClick(Sender: TObject);
  private
    updateEnabled: boolean;

    procedure updateMesView;
    { Private declarations }
  public
    { Public declarations }
  end;

  procedure showMesView;
  procedure updateMesView;

var
  MesViewV2Form: TMesViewV2Form;

  lastTop: integer = 0;
  lastLeft: integer = 0;
  lastWidth: integer = 0;
  lastHeight: integer = 0;

implementation
uses
  Numbers,
  MesLoggingV2,
  RpVisualGlobal,
  DataMod,
  main;

{$R *.DFM}

var
  lastdt: TDateTime = 0;

procedure showMesView;
begin
  if MesViewV2Form = nil then begin
    MesViewV2Form := TMesViewV2Form.Create(Form1);
  end;

  MesViewV2Form.ShowModal;
end;

procedure updateMesView;
begin
  if MesViewV2Form <> nil then
    MesViewV2Form.updateMesView;
end;

procedure TMesViewV2Form.FormCreate(Sender: TObject);
begin
  if lastdt = 0 then
    lastdt := now;
  dt.DateTime := lastdt;

  if filterPlaceIds <> '' then begin
    ds.SelectSQL.Insert(
          ds.SelectSQL.Count-1,
          'and idplace in (' + filterPlaceIds + ')'
    );
  end;

  try
    updateEnabled := false;
    trnr.DefaultDatabase := dm.pFIBDbMes;
    trnw.DefaultDatabase := dm.pFIBDbMes;
    ds.Database := dm.pFIBDbMes;
    ds.Prepare;
    ds.ParamByName('DTBEG').Value := Int(lastdt);
    ds.ParamByName('DTEND').Value := Int(lastdt) + 1;
    ds.ParamByName('FILTER_USER').Value := '';
    ds.ParamByName('FILTER_PLACE').Value := '';
    ds.ParamByName('FILTER_TEXT').Value := '';
    ds.Open;
    updateEnabled := true;
  except
  end;
end;

procedure TMesViewV2Form.btCancelClick(Sender: TObject);
begin
  close;
end;

procedure TMesViewV2Form.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  lastTop := Top;
  lastLeft := Left;
  lastWidth := Width;
  lastHeight := Height;

  MesViewV2Form := nil;
end;


procedure TMesViewV2Form.gridGetCellParams(Sender: TObject;
  Column: TColumnEh; AFont: TFont; var Background: TColor;
  State: TGridDrawState);
var
  clb, clf: integer;
begin
  if not dsDT.IsNull then begin
    clb := dsCLB.AsInteger;
    clf := dsCLF.AsInteger;
  end else begin
    clb := clWhite;
    clf := clBlack;
  end;
  Background := clb;
  AFont.Color := clf;
end;

procedure TMesViewV2Form.updateMesView;
//var
//  idm: integer;
begin
  if not updateEnabled then
    exit;
//  idm := dsIDM.AsInteger;
  ds.ReopenLocate('IDM');
end;


procedure TMesViewV2Form.dtChange(Sender: TObject);
begin
  if not updateEnabled then exit;
  updateEnabled := false;
  lastdt := dt.Date;
  ds.Close;
  ds.ParamByName('DTBEG').Value := Int(lastdt);
  ds.ParamByName('DTEND').Value := Int(lastdt) + 1;
  ds.Open;
  updateEnabled := true;
end;


procedure TMesViewV2Form.gridApplyFilter(Sender: TObject);
begin
  if not updateEnabled then exit;
  updateEnabled := false;
  ds.Close;
  ds.ParamByName('FILTER_USER').Value  := grid.Columns[3].STFilter.ExpressionStr;
  ds.ParamByName('FILTER_PLACE').Value := grid.Columns[4].STFilter.ExpressionStr;
  ds.ParamByName('FILTER_TEXT').Value  := grid.Columns[5].STFilter.ExpressionStr;
  ds.Open;
  updateEnabled := true;
end;


procedure TMesViewV2Form.btBackwardClick(Sender: TObject);
begin
  dt.Date := dt.Date - 1;
  dtChange(nil);
end;

procedure TMesViewV2Form.btForwardClick(Sender: TObject);
begin
  dt.Date := dt.Date + 1;
  dtChange(nil);
end;

procedure TMesViewV2Form.btTodayClick(Sender: TObject);
begin
  dt.Date := Now;
  dtChange(nil);
end;

procedure TMesViewV2Form.gridColumns1GetCellParams(Sender: TObject;
  EditMode: Boolean; Params: TColCellParamsEh);
begin
  // this makes DTEND and DTACK empty strings when message ACT=M 
  if dsACT.AsString = 'M' then begin
    Params.Text := '';
  end;
end;

procedure TMesViewV2Form.FormActivate(Sender: TObject);
begin
  if lastWidth > 0 then begin
    top := lastTop;
    left := lastLeft;
    Width := lastWidth;
    Height := lastHeight;
  end;
end;

procedure TMesViewV2Form.btPrintClick(Sender: TObject);
begin
//  DataSource.DataSet := nil;
//  flag := Timer.Enabled;
//  Timer.Enabled := false;

//  dm.frxReport.LoadFromFile(ReportDirStd + 'MesView2.fr3');
  dm.frxDBDataset1.DataSet := ds;
  dm.frxDBDataset1.DataSource := dsrc;
  dm.frxReport.DesignReport;
//  dm.frxReport.PrepareReport;
//  dm.frxReport.ShowPreparedReport;

//  Timer.Enabled := flag;
//  dm.dsRead.Close;
//  DataSource.DataSet := dm.dsRead;
//  CreateList;
end;

end.
