unit Motohr;

interface
uses
  HyperStr,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ComCtrls, ExtCtrls, ImgList;

const
  STR_MOTOHR = '';

  COLOR_NORMAL = $00E4E4E4;
  COLOR_NEGATIVE = $000080FF;
  COLOR_RUNNING = clLime;
  COLOR_LISTVIEW = clWhite;

  COUNTER_TOTAL_ID = 1;
  COUNTER_TOTAL_SID = '1';
  COUNTER_DISABLED = $7fffffff;

  SYSTEM_CMD_REINIT = 'reinit';

  SEC_IN_HOUR = 3600.0;
//  SEC_IN_HOUR: double = 10.0;

  procedure EnableMotohr;
  function isMotohrEnabled: boolean;
  function getMotohrModulePath: string;
  function getMotohrDBName: string;

  procedure sendSystemUtilCommand(value: string);

//  procedure splitCounterTypeDescr(descr: string; var descrShort: string; var descrLong: string);
  function getCounterTypeDescrShort(descr: string): string;
  function getCounterTypeDescrLong(descr: string): string;

implementation
uses
  DataMod,
  MesLogging,
  InputDialog,
  InfoDlg,
  TagStorage,
  RpVisualGlobal,
  RpVisualParams,
  RpVisualUtils, StrUtils;

var
  Enabled: Boolean = false;
  ModulePath: string = '';
  DBName: string = '';


procedure EnableMotohr;
begin
  DBName := Trim(rpVisualParams_Read('MotohrDBName', ':  ', ''));
  ModulePath := Trim(rpVisualParams_Read('MotohrModule', ':    jrobo', 'mh'));
  Enabled := ModulePath <> '';
  if Enabled then
    ShowMotohrButton;
end;


function isMotohrEnabled: boolean;
begin
  result := Enabled;
end;


function getMotohrModulePath: string;
begin
  result := ModulePath;
end;


function getMotohrDBName: string;
begin
  result := DBName;
end;



procedure sendSystemUtilCommand(value: string);
var
  idx: integer;
begin
  idx := GetTagIndex(ModulePath + '.system.util');
  if idx >= 0 then
    SetTagValueString(idx, value);
end;



function getCounterTypeDescrShort(descr: string): string;
var
  k: Integer;
begin
  k := Pos(': ', descr);
  if k = 0 then
    Result := descr
  else
    result := Copy(descr, 1, k-1);
end;

function getCounterTypeDescrLong(descr: string): string;
var
  k: Integer;
begin
  k := Pos(': ', descr);
  if k = 0 then
    Result := descr
  else
    result := IStr(descr, k+2);
end;



end.
