unit MotohrLogbook;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ComCtrls, ExtCtrls, ImgList, Menus, AdvGlowButton,
  Grids, DB, FIBDataSet, pFIBDataSet, FIBDatabase, pFIBDatabase, GridsEh,
  DBGridEh, DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh,
  EhLibVCL, DBAxisGridsEh;

type

  TMotohrLogbookForm = class(TForm)
    Panel2: TPanel;
    btCancel: TButton;
    Panel1: TPanel;
    Panel3: TPanel;
    dt: TDateTimePicker;
    edDays: TEdit;
    udDays: TUpDown;
    btBackward: TAdvGlowButton;
    btForward: TAdvGlowButton;
    grid: TDBGridEh;
    tr: TpFIBTransaction;
    ds: TpFIBDataSet;
    dsrc: TDataSource;
    btRefresh: TAdvGlowButton;
    dsID: TFIBIntegerField;
    dsDT: TFIBDateTimeField;
    dsTEXT: TFIBstringField;
    dsDESCR: TFIBstringField;
    dsFIO: TFIBstringField;
    btAdd: TButton;
    procedure FormActivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure gridApplyFilter(Sender: TObject);
    procedure dtChange(Sender: TObject);
    procedure btRefreshClick(Sender: TObject);
    procedure btBackwardClick(Sender: TObject);
    procedure btForwardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btAddClick(Sender: TObject);
  private
    procedure setFilterParams;
    function getDelta: integer;
  public
    machName: string;

  end;



implementation
uses
  DbDatasetUtils,
  MotohrMessage,
  MotohrView,
  InfoDlg,
  Utils,
  TagStorage,
  Motohr,
  MotohrDb,
  Numbers,
  main;

{$R *.DFM}

procedure TMotohrLogbookForm.FormCreate(Sender: TObject);
begin
  machName := '';
end;


procedure TMotohrLogbookForm.FormActivate(Sender: TObject);
var
  s: string;
begin
  if machName <> '' then begin
    s := ds.SQLs.SelectSQL.Text;
    rpReplaceS(s, '-- machName', Format('m.name=''%s'' and', [machName]));
    ds.SQLs.SelectSQL.Text := s;
    btAdd.Visible := true;
  end;

  try
    connectMotohrDb;
    setDisconnectTimerActive(false);
    ds.Database := getMotohrDb;
    dt.DateTime := Now;
    setFilterParams;
    ds.Open;
  except
    on e : Exception do begin
      showInfoDlg(e.Message, mtError, [mbOk], 0);
    end;
  end;

end;


procedure TMotohrLogbookForm.FormDestroy(Sender: TObject);
begin
  setDisconnectTimerActive(true);
end;



procedure TMotohrLogbookForm.gridApplyFilter(Sender: TObject);
begin
  dsDESCR.Origin := 'M.DESCR';
  dsTEXT.Origin := 'L.TEXT';
  dsFIO.Origin := 'L.FIO';
  if ds.Active then
    applyFilter(ds, andFilterExpr([grid.Columns[1], grid.Columns[2], grid.Columns[3]]), [] );
end;

procedure TMotohrLogbookForm.setFilterParams;
begin
  ds.ParamByName('DTEND').AsDateTime := trunc(dt.Date) + 1;
  ds.ParamByName('DTBEG').AsDateTime := trunc(dt.Date - getDelta) + 1;
end;


procedure TMotohrLogbookForm.dtChange(Sender: TObject);
begin
  if ds.Active then begin
    setFilterParams;
    btRefreshClick(nil);
  end;
end;


procedure TMotohrLogbookForm.btRefreshClick(Sender: TObject);
begin
  if ds.Active then 
    reopenDataSet(ds);
end;


procedure TMotohrLogbookForm.btBackwardClick(Sender: TObject);
begin
  dt.DateTime := dt.DateTime - getDelta;
  dtChange(nil);
end;


procedure TMotohrLogbookForm.btForwardClick(Sender: TObject);
begin
  dt.DateTime := dt.DateTime + getDelta;
  dtChange(nil);
end;

function TMotohrLogbookForm.getDelta: integer;
begin
  result := StrToIntDef(edDays.Text, 1);
end;



procedure TMotohrLogbookForm.btAddClick(Sender: TObject);
var
  text, fio: string;
  id: Integer;
begin
  if not showMotohrMessage(text, fio) then
    exit;

  try
    startTransaction(true);
    id := insertLogbookRecord(now, machName, text, fio);
    commitTransaction;
    reopenDataSet(ds);
    ds.Locate('id', id, []);
  except
    on e : Exception do begin
      rollbackTransaction;
      showInfoDlg(e.Message, mtError, [mbOk], 0);
    end;
  end;
end;

end.

