unit MotohrNote;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ComCtrls, ExtCtrls, ImgList, Menus;

type

  TMotohrNoteForm = class(TForm)
    memo: TMemo;
    btSave: TButton;
    btCancel: TButton;
    lbDt: TLabel;
    procedure btSaveClick(Sender: TObject);
    procedure memoChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  public
    noteName: string;
  end;

  procedure showMotohrNote(caption, name: string);


implementation

uses
  Users,
  MotohrDb,
  hyperstr,
  main;

{$R *.DFM}

var
  lastFio: string = '';

procedure showMotohrNote(caption, name: string);
var
  w: TMotohrNoteForm;
  text: string;
  dt: TDatetime;
  id: integer;
begin
  w := TMotohrNoteForm.Create(Form1);
  w.Caption := caption + ' ' + name;
  w.noteName := name;

  id := loadNote(name, text, dt);

  w.memo.Text := text;

  if id > 0 then
    w.lbDt.caption := w.lbDt.caption + DateTimeToStr(dt);

  w.btSave.Enabled := false;

  w.ShowModal;
  w.Free
end;




procedure TMotohrNoteForm.btSaveClick(Sender: TObject);
begin
  saveNote(noteName, memo.Lines.Text);
  Close;
end;

procedure TMotohrNoteForm.memoChange(Sender: TObject);
begin
  btSave.Enabled := True;
end;

procedure TMotohrNoteForm.FormActivate(Sender: TObject);
begin
  memo.ReadOnly := not isUserSuvervisor;
end;

end.

