unit MotohrView;

interface

uses
  MotohrMonitor,
  MotohrLogbook,
  MotohrAdmin,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ComCtrls, ExtCtrls, ImgList, Menus, AdvGlowButton;

type

  TMotohrViewForm = class(TForm)    
    pg: TPageControl;
    tab1: TTabSheet;
    tab2: TTabSheet;
    tab3: TTabSheet;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    procedure FormActivate(Sender: TObject);
    procedure pgChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    wndMonitor : TMotohrMonitorForm;
    wndLogbook: TMotohrLogbookForm;
    wndAdmin: TMotohrAdminForm;
    procedure showTabWindow(tab: TTabSheet; wnd: TForm);
  end;

  procedure showMotohrView;

  function prepareFilter(filter: string): string;
  function getTimerMark(value: boolean): string;


implementation
uses
  InfoDlg,
  Users,
  Numbers,
  RpVisualGlobal,
  Motohr,
  main;

{$R *.DFM}



procedure showMotohrView;
var
  w: TMotohrViewForm;
begin
  if isMotohrEnabled and rvgLogIn then begin
    w := TMotohrViewForm.Create(Form1);
    w.ShowModal;
    w.Free
  end;
end;



procedure TMotohrViewForm.FormActivate(Sender: TObject);
  procedure reactivate(pageIndex: Integer; wnd: TForm);
  begin
    if (pg.ActivePageIndex <> pageIndex) and (wnd <> nil) and Assigned(wnd.OnActivate) then
      wnd.OnActivate(nil);
  end;
begin
  if getMotohrDBName = '' then begin
    tab2.TabVisible := false;
    tab3.TabVisible := false;
  end;

  if CurUserId > USER_SUPERVISOR then
    tab3.TabVisible := false;

  pgChange(nil);

  reactivate(0, wndMonitor);
  reactivate(1, wndLogbook);
  reactivate(2, wndAdmin);

//  if (pg.ActivePage <> tab1) and (wndMonitor <> nil) then
//    wndMonitor.OnActivate(nil);
end;

procedure TMotohrViewForm.pgChange(Sender: TObject);
begin
  if (pg.TabIndex = 0) and (wndMonitor = nil) then begin
    wndMonitor := TMotohrMonitorForm.Create(tab1);
    showTabWindow(tab1, wndMonitor);
  end;

  if (pg.TabIndex = 1) and (wndLogbook = nil) then begin
    wndLogbook := TMotohrLogbookForm.Create(tab1);
    showTabWindow(tab2, wndLogbook);
  end;

  if (pg.TabIndex = 2) and (wndAdmin = nil) then begin
    wndAdmin := TMotohrAdminForm.Create(tab1);
    showTabWindow(tab3, wndAdmin);   
  end;

end;

procedure TMotohrViewForm.showTabWindow(tab: TTabSheet; wnd: TForm);
begin
  wnd.Parent := tab;
  wnd.Align := alClient;
  wnd.Left := 0;
  wnd.Top := 0;
  wnd.BorderStyle := bsNone;

  if Assigned(wnd.OnActivate) then
    wnd.OnActivate(nil);

  wnd.show;

  if Assigned(wnd.OnShow) then
    wnd.OnShow(nil);
end;



function prepareFilter(filter: string): string;
begin
  if filter <> '' then begin
    if filter[1] <> ' ' then
      filter := '*' + filter + '*';
    filter := Trim(filter);
  end;
  result := filter;
end;


function getTimerMark(value: boolean): string;
begin
  Result := iif(value, '+', '');
end;



procedure TMotohrViewForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var
  res: integer;
begin
  if (wndAdmin <> nil) and wndAdmin.hasChanges then begin
    pg.ActivePage := tab3;
    res := showInfoDlg('    !   ?',
          '!', '', ' ', '');
          
    if res = 1 then
      wndAdmin.btSaveAndApplyClick(nil);

    CanClose := res < 3;
  end;
end;

end.
