unit NeedReconnectNotification;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TNeedReconnectNotificationForm = class(TForm)
    StatePanel: TPanel;
    Label2: TLabel;
    btReconnect: TButton;
    btPostpone: TButton;
    timer: TTimer;
    procedure TimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btReconnectClick(Sender: TObject);
    procedure btPostponeClick(Sender: TObject);
  private
    secReconnect: integer;
    secPostpone: integer;
  public
    { Public declarations }
  end;

  procedure processReconnectNotification;


implementation
uses
  Users,
  RpVisualGlobal,
  RpVisualMain,
  Status,
  MesLogging,
  Connecting,
  TagStorage,
  main;

{$R *.dfm}

const
  SEC_RECONNECT = 10;
  SEC_POSTPONE = 60;

var
  wnd: TNeedReconnectNotificationForm = nil;
  reconnecting: boolean = false;

procedure processReconnectNotification;
begin
  if reconnecting then
    Exit;

  if (DataClient.isNeedReconnect) then begin
    if wnd = nil then begin
      wnd := TNeedReconnectNotificationForm.Create(Form1);
      wnd.Parent := form1;
      wnd.Show;
//      wnd.Left := (Form1.Width - wnd.Width) div 2;
//      wnd.Top := (Form1.Height - wnd.Height) div 2;
      wnd.Left := 0;
      wnd.Top := 0;
    end;
  end else begin
    if wnd <> nil then begin
      wnd.Close;
      wnd.Free;
      wnd := nil;
    end;
  end;
end;

procedure TNeedReconnectNotificationForm.FormCreate(Sender: TObject);
begin
  secReconnect := SEC_RECONNECT;
  secPostpone := 0;
  btPostpone.Caption := '  ' + IntToStr(SEC_POSTPONE) + ' ';
end;

procedure TNeedReconnectNotificationForm.btReconnectClick(Sender: TObject);
begin
  timer.Enabled := false;
  reconnecting := true;
  Hide;
  Application.ProcessMessages;

  if rvgLogIn then begin
    DisconnectSystem;
    AutoLoginUserName := CurUserName;
    ConnectSystem;
  end;

  Release;
  wnd := nil;
  reconnecting := false;
end;


procedure TNeedReconnectNotificationForm.btPostponeClick(Sender: TObject);
begin
  secPostpone := SEC_POSTPONE;
  wnd.Hide;
end;


procedure TNeedReconnectNotificationForm.TimerTimer(Sender: TObject);
begin
  if not rvgLogIn then begin
    Release;
    wnd := nil;
  end;

  if reconnecting then
    exit;

  if secPostpone > 0 then begin
    Dec(secPostpone);
    if secPostpone = 0 then begin
      secReconnect := SEC_RECONNECT;
      wnd.Show
    end;
  end else begin
    Dec(secReconnect);
    btReconnect.Caption := ' - ' + IntToStr(secReconnect) + ' ';
    if secReconnect = 0 then begin
      btReconnectClick(nil);
    end;
  end;
end;


end.
