unit PolyLineSetup;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, ExtCtrls, Buttons, ComCtrls, PolyLine;

type
  TPolyLineSetupForm = class(TForm)
    OkButton: TBitBtn;
    CancelButton: TBitBtn;
    Timer: TTimer;
    Panel5: TPanel;
    Label5: TLabel;
    LineList: TListBox;
    btLineAdd: TSpeedButton;
    btLineDel: TSpeedButton;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label34: TLabel;
    LineXEdit: TEdit;
    LineYEdit: TEdit;
    udLineY: TUpDown;
    udLineX: TUpDown;
    LineRXEdit: TEdit;
    LineRYEdit: TEdit;
    udLineRY: TUpDown;
    udLineRX: TUpDown;
    cbFlash: TCheckBox;
    procedure btLineAddClick(Sender: TObject);
    procedure btLineDelClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure LineListClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure LineXEditChange(Sender: TObject);
    procedure LineYEditChange(Sender: TObject);
    procedure cbFlashClick(Sender: TObject);
  private
    NotLoaded: boolean;
    FlashFlag: boolean;
//    FlashCnt: integer;
    procedure Modify;
  public
    M: TPolyLine;
    D: TPolyLineEditor;
  end;

var
  PolyLineSetupForm: TPolyLineSetupForm;

implementation
uses ExtDlgs, inifiles;

{$R *.DFM}

procedure TPolyLineSetupForm.FormActivate(Sender: TObject);
var
  i: integer;
begin
  //  
  LineList.Clear;
  for i:=0 to Length(M.Line)-1 do
    LineList.Items.Add(format(' %d', [i+1]));


  if LineList.Items.Count>0 then LineList.ItemIndex := 0;
  LineListClick(nil);

//  FlashFlag := false;
//  FlashCnt := 0;
  NotLoaded := false;
end;


procedure TPolyLineSetupForm.LineListClick(Sender: TObject);
begin
  if LineList.ItemIndex < 0 then begin
    LineList.Clear;
    udLineX.Position := 0;
    udLineY.Position := 0;
    udLineRX.Position := 0;
    udLineRY.Position := 0;
  end else
    if LineList.ItemIndex < length(M.Line) then begin
      NotLoaded := true;
      udLineX.Position := M.Line[LineList.ItemIndex].Left;
      udLineY.Position := M.Line[LineList.ItemIndex].Top;
      udLineRX.Position := M.Line[LineList.ItemIndex].Right - M.Line[LineList.ItemIndex].Left;
      udLineRY.Position := M.Line[LineList.ItemIndex].Bottom - M.Line[LineList.ItemIndex].Top;
      NotLoaded := false;
    end;
end;


procedure TPolyLineSetupForm.FormCreate(Sender: TObject);
begin
  NotLoaded := true;
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    Left := ReadInteger('PolyLine', 'Left', 6);
    Top := ReadInteger('PolyLine', 'Top', 4);
    cbFlash.Checked := ReadBool('PolyLine', 'Flash', false);
    Free;
  end;
end;

procedure TPolyLineSetupForm.FormDestroy(Sender: TObject);
begin
  with TIniFile.Create(GetCurrentDir + '\VisScada.ini') do begin
    WriteInteger('PolyLine', 'Left', Left);
    WriteInteger('PolyLine', 'Top', Top);
    WriteBool('PolyLine', 'Flash', cbFlash.Checked);
    Free;
  end;
end;


procedure TPolyLineSetupForm.Modify;
begin
  D.Designer.Modified;
  M.Repaint;
end;


procedure TPolyLineSetupForm.TimerTimer(Sender: TObject);
var
  n: integer;
begin

  if (not cbFlash.Checked) and (M.FlashLine=-1) then exit;

//  inc(FlashCnt);
//  if FlashCnt>60 then FlashCnt:=0;
//  if FlashCnt>15 then exit;

  if (length(M.Line)>0) and (LineList.ItemIndex>=0) then begin
    n := LineList.ItemIndex;
    if FlashFlag then
      M.FlashLine := n
    else
      M.FlashLine := -1;
    FlashFlag := not FlashFlag;
    M.Repaint;
  end;

end;


procedure TPolyLineSetupForm.btLineAddClick(Sender: TObject);
var
  k: integer;
begin
  k := length(M.Line);
  SetLength(M.Line, k+1);

  new(M.Line[k]);
  M.Line[k].Left := 0;
  M.Line[k].Top := 0;
  M.Line[k].Right := 0;
  M.Line[k].Bottom := 0;

  LineList.Items.Add(format(' %d', [k+1]));
  LineList.ItemIndex := LineList.Items.Count-1;
  LineListClick(nil);
  Modify;
end;

procedure TPolyLineSetupForm.btLineDelClick(Sender: TObject);
var
  i,k: integer;
begin
  k := LineList.ItemIndex;
  if (k>=0) and (k<length(M.Line)) then begin
    dispose(M.Line[k]);

    for i:=k to length(M.Line)-2 do M.Line[i] := M.Line[i+1];
    SetLength(M.Line, length(M.Line)-1);

    LineList.Items.Delete(k);
    if k = LineList.Items.Count then Dec(k);
    LineList.ItemIndex := k;
    LineListClick(nil);
    Modify;
  end;

end;




procedure TPolyLineSetupForm.LineXEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LineXEdit.Text='') or (LineRXEdit.Text='') then exit;
  if (LineList.ItemIndex >= 0) and (LineList.ItemIndex < length(M.Line)) then begin
    M.Line[LineList.ItemIndex].Left := StrToInt(LineXEdit.Text);
    M.Line[LineList.ItemIndex].Right := M.Line[LineList.ItemIndex].Left +
        StrToInt(LineRXEdit.Text);
    Modify;
  end;
end;

procedure TPolyLineSetupForm.LineYEditChange(Sender: TObject);
begin
  if (NotLoaded) or (LineYEdit.Text='') or (LineRYEdit.Text='') then exit;
  if (LineList.ItemIndex >= 0) and (LineList.ItemIndex < length(M.Line)) then begin
    M.Line[LineList.ItemIndex].Top := StrToInt(LineYEdit.Text);
    M.Line[LineList.ItemIndex].Bottom := M.Line[LineList.ItemIndex].Top +
        StrToInt(LineRYEdit.Text);
    Modify;
  end;
end;

procedure TPolyLineSetupForm.cbFlashClick(Sender: TObject);
begin
//  M.FlashLine := -1;
//  M.Repaint;
end;

end.
