unit ProdArhPrint;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, FR_View, FR_Class, FR_E_TXT, FR_E_RTF;

type
  TProdArhPrintForm = class(TForm)
    Panel1: TPanel;
    btSave: TButton;
    btClose: TButton;
    frPreview: TfrPreview;
    procedure btSaveClick(Sender: TObject);
  private
    save_name: string;
  public
    { Public declarations }
    procedure MakeCurReport;
    procedure MakeReport(dbeg, dend: TDateTime; id: string; objname: string);
  end;

implementation
uses ProdDataMod, hyperstr;//, fr_class;

{$R *.DFM}

{ TProdArhPrintForm }

//  
procedure TProdArhPrintForm.MakeReport(dbeg, dend: TDateTime; id: string; objname: string);
begin
  save_name := id;// + FormatDateTime('yyyy-MM-dd hh_nn_ss', now);
  try
    ProdDM.Query.SelectSQL.Text :=
          'SELECT P.IDPROD, P.DTLOAD, P.DTEMPTY, C.NAME AS CULT_NAME, '+
          'T.NAME AS POSTAV_NAME, P.INFO '+
          'FROM PRODUCT P, CULTURA C, POSTAVSHIK T WHERE '+
          'P.IDOBJ='#39 + id + #39' AND P.IDCULT=C.IDCULT AND '+
          'P.IDPOSTAV=T.IDPOSTAV AND '+
          'P.DTLOAD>='#39 + DateToStr(dbeg) + ' 00:00:00'#39' AND '+
          '(P.DTEMPTY<='#39 + DateToStr(dend) + ' 23:59:59'#39' OR P.DTEMPTY IS NULL)  '+
          'ORDER BY DTLOAD DESC';

    proddm.Query.Open;

    proddm.frReport.LoadFromFile(proddm.ReportDir + 'ProdArh.frf');
    frVariables['VAR_OBJNAME'] := Objname;
    proddm.frReport.PrepareReport;
    proddm.frReport.Preview := frPreview;
//    proddm.dsProd.Close;
    proddm.Query.Transaction.Commit;
    proddm.frReport.ShowPreparedReport;
  except
    proddm.Query.Transaction.Active := false;
    MessageDlg('  !!!', mtError, [mbOk], 0);
  end;
end;

//   
procedure TProdArhPrintForm.MakeCurReport;
begin
  save_name := '   ' + FormatDateTime('yyyy-MM-dd',Now);
  try
    ProdDM.Query.SelectSQL.Text :=
          'SELECT P.IDPROD, P.DTLOAD, P.DTEMPTY, C.NAME AS CULT_NAME, '+
          'T.NAME AS POSTAV_NAME, P.IDOBJ, P.INFO '+
          'FROM PRODUCT P, CULTURA C, POSTAVSHIK T WHERE '+
          'P.ARH=0 AND P.IDCULT=C.IDCULT AND '+
          'P.IDPOSTAV=T.IDPOSTAV '+
          'ORDER BY IDOBJ';
    proddm.Query.Open;

    proddm.frReportSvod.LoadFromFile(proddm.ReportDir + 'ProdCur.frf');
//    frVariables['VAR_OBJNAME'] := Objname;
    proddm.frReportSvod.PrepareReport;
    proddm.frReportSvod.Preview := frPreview;
    proddm.Query.Transaction.Commit;
    proddm.frReportSvod.ShowPreparedReport;
  except
    proddm.Query.Transaction.Active := false;
    MessageDlg('  !!!', mtError, [mbOk], 0);
  end;
end;



//   
procedure TProdArhPrintForm.btSaveClick(Sender: TObject);
begin
  proddm.Query.Open;
  proddm.frReport.PrepareReport;
  proddm.frReport.SavePreparedReport('A:\' + save_name + '.frp');
  proddm.Query.Transaction.Commit;
end;

end.
