// DEPRECATED

unit ProdDataMod;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, FR_Class, FR_DSet, FR_DBSet,
  FIBQuery, pFIBQuery, FIBDatabase, pFIBDatabase, FIBDataSet, pFIBDataSet;

type
  TProdDM = class(TDataModule)
    frReport: TfrReport;
    frDBDataSet: TfrDBDataSet;
    frUserDataSet: TfrUserDataset;
    frReportSvod: TfrReport;
    frDBDataSetSvod: TfrDBDataSet;
    dbProd: TpFIBDatabase;
    Query: TpFIBDataSet;
    trnProdDs: TpFIBTransaction;
    qryProd: TpFIBQuery;
    trnProdQry: TpFIBTransaction;
    procedure frUserDataSetCheckEOF(Sender: TObject; var Eof: Boolean);
    procedure frUserDataSetFirst(Sender: TObject);
    procedure frUserDataSetNext(Sender: TObject);
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
    procedure frDBDataSetSvodFirst(Sender: TObject);
    procedure frReportSvodGetValue(const ParName: String;
      var ParValue: Variant);
  private
    { Private declarations }
    frud_cnt: integer;
    frud_list: TStringList;
    frud_infoadd: string;
  public
    Dbeg, Dend: TDateTime;
    ReportDir: string;
    function ConnectToProd: boolean;
    procedure DisconnectFromProd;
    function AdminAccessLevel: boolean;
    function UserAccessLevel: boolean;
  end;


  procedure CheckProdMode;

var
  ProdDM: TProdDM;
  ProdMode_password: string = 'KHROSA';
  ProdMode_On: boolean;


implementation

uses
  RpVisualGlobal,
  Status,
  IniFiles,
  HyperStr,
  ProdArhPrint,
  users,
  passwords,
  main;

{$R *.DFM}


procedure CheckProdMode;
var
  s: string;
begin
  if not ProdMode_On then
    while InputPassQuery('', '   ..:', s) do
      if UpperCase(s) = ProdMode_password then begin
        ProdMode_On := true;
        break;
      end else begin
        MessageDlg('  !', mtError, [mbOk], 0);
      end;
end;


{ TProdDM }


procedure TProdDM.DataModuleCreate(Sender: TObject);
begin
  frud_list := TStringList.Create;
  Dbeg := now;
  Dend := now;
end;

procedure TProdDM.DataModuleDestroy(Sender: TObject);
begin
  frud_list.Free;
end;


function TProdDM.AdminAccessLevel: boolean;
begin
  result := ProdMode_On;
end;

function TProdDM.UserAccessLevel: boolean;
begin
  result := true;
end;


// 
function TProdDM.ConnectToProd: boolean;
var
  IniFile: TIniFile;
  s: string;
begin
  ReportDir := CurDir + ReportDirStd;

  IniFile := TIniFile.Create(CurDir + RpVisualIniFile);
  proddm.dbProd.DBName := IniFile.ReadString('Database', 'ProdPath', '');
  if proddm.dbProd.DBName='' then begin
    s := '';
    if InputQuery('  ', '    ', s) then begin
      proddm.dbProd.DBName := s;
      IniFile.WriteString('Database', 'ProdPath', s);
    end;
  end;
  IniFile.Free;

  ShowStatusMessage('   ');

  try
    proddm.dbProd.Connected := true;
  except
    MessageDlg('       !', mtError, [mbOk], 0);
  end;
  result := proddm.dbProd.Connected;

  CloseStatusMessage;
end;

procedure TProdDM.DisconnectFromProd;
begin
  proddm.dbProd.Connected := false;
end;


// CHECK EOF
procedure TProdDM.frUserDataSetCheckEOF(Sender: TObject; var Eof: Boolean);
begin
  eof := frud_cnt > frud_list.Count;
end;

// ON FIRST
procedure TProdDM.frUserDataSetFirst(Sender: TObject);
begin
  frud_cnt:=0;
  frud_list.Text := '';
  frud_infoadd := '';
  if Query.Active then
    if not Query.Eof then
      frud_list.Text := Query.FieldByName('INFO').AsString;
  frUserDataSetNext(nil);
end;

// ON NEXT
procedure TProdDM.frUserDataSetNext(Sender: TObject);
var
  s: string;
  j: integer;
begin
  if frud_cnt < frud_list.Count then begin
    repeat
      s := frud_list.Strings[frud_cnt];
      if copy(s,1,1)='#' then begin
        j := 2;
        frVariables['VAR_DTLOAD'] := Parse(s, ';', j);   // 
        frVariables['VAR_WES'] := Parse(s, ';', j);      // 
        frVariables['VAR_WET'] := Parse(s, ';', j);      // 
        frVariables['VAR_KLEY'] := Parse(s, ';', j);     // 
        frVariables['VAR_KARL'] := Parse(s, ';', j);     // 
        frVariables['VAR_OVSUG'] := Parse(s, ';', j);    // 
        break;
      end else
        frud_infoadd := frud_infoadd + s + #13#10;

      inc(frud_cnt);
    until frud_cnt >= frud_list.Count;

    frVariables['VAR_INFOADD'] := frud_infoadd;

  end;
  inc(frud_cnt);
end;


procedure TProdDM.frDBDataSetSvodFirst(Sender: TObject);
begin
{  frVariables['VAR_DTLOAD'] := '';
  frVariables['VAR_WES'] := '';
  frVariables['VAR_WET'] := '';
  frVariables['VAR_KLEY'] := '';
  frVariables['VAR_KARL'] := '';
  frVariables['VAR_OVSUG'] := '';
}
end;

procedure TProdDM.frReportSvodGetValue(const ParName: String;
  var ParValue: Variant);
var
  s: string;
  k: integer;
begin
  if ParName='VAR_DTLOAD' then begin
    frUserDataSetFirst(nil);
    s := frVariables['VAR_DTLOAD'];
    k := pos(' ', s);
    if k>0 then frVariables['VAR_DTLOAD'] := copy(s,1,k-1);
  end;
//    ParValue := ParName + '-' + Query.Fields[0].AsString;
end;

end.
