unit ProdEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ProdFrame, PolyLine, ComCtrls, Mask;

type
  TProductEditModes = (pemNewLoad, pemNewRec, pemEditRec, pemEditCP);
type

  TProdEditForm = class(TForm)
    Panel1: TPanel;
    InfoPanel: TPanel;
    OkButton: TButton;
    btCancel: TButton;
    cmbProdName: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    cmbPostav: TComboBox;
    Label3: TLabel;
    edWes: TEdit;
    Label4: TLabel;
    edWet: TEdit;
    Label5: TLabel;
    edKley: TEdit;
    Label6: TLabel;
    edKarl: TEdit;
    Label7: TLabel;
    edOvsug: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    dtDate: TDateTimePicker;
    dtTime: TDateTimePicker;
    Panel3: TPanel;
    Label10: TLabel;
    PolyLine1: TPolyLine;
    PolyLine2: TPolyLine;
    procedure cmbProdNameDropDown(Sender: TObject);
    procedure edEditExit(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure edWesEnter(Sender: TObject);
    procedure OkButtonClick(Sender: TObject);
    procedure btCancelClick(Sender: TObject);
  private
  public
    P: TfrmProd;
    IdCult, IdPostav: integer;
    EditMode: TProductEditModes;
    procedure ProductRecord(idobj: string; mode: TProductEditModes);
  end;

implementation
uses ProdDataMod, hyperstr, SimpleTable;

{$R *.DFM}

procedure TProdEditForm.ProductRecord(idobj: string; mode: TProductEditModes);
var
  k: integer;
  s: string;
  flag: boolean;
begin
  if not ProdDM.UserAccessLevel then exit;

  EditMode := mode;
  P := Owner as TfrmProd;

  Caption := P.pnlObjName.Caption + ': ' +
        iif(EditMode=pemNewLoad, '  ', '') +
        iif(EditMode=pemNewRec, '    ', '') +
        iif(EditMode=pemEditRec, '   ', '') +
        iif(EditMode=pemEditCP, ' ', '');

  if (EditMode=pemNewLoad) or (EditMode=pemNewRec) then begin
    IdCult := -1;
    IdPostav := -1;
    cmbProdName.Items[0] := '';
    cmbPostav.Items[0] := '';
    dtDate.DateTime := now;
    dtTime.DateTime := now;
    edWes.Text := '';
    edWet.Text := '';
    edKley.Text := '';
    edKarl.Text := '';
    edOvsug.Text := '';
  end;

  if not (EditMode=pemNewLoad) then begin
    IdCult := P.IdCult;
    IdPostav := P.IdPostav;
    cmbProdName.Items[0] := P.pnlProdName.Caption;
    cmbPostav.Items[0] := P.pnlPostav.Caption;

    if (P.List.Items.Count > 0) and ((EditMode=pemNewRec)) then
      P.List.Items[0].Selected := true;

    if (P.List.Selected<>nil) then begin
      s := ShortDateFormat;
      ShortDateFormat := 'yyyy.MM.dd';
      dtDate.DateTime := StrToDateTime(P.List.Selected.Caption);
      dtTime.DateTime := StrToDateTime(P.List.Selected.Caption);
      ShortDateFormat := s;
      edWes.Text := P.List.Selected.SubItems[0];
      edWet.Text := P.List.Selected.SubItems[1];
      edKley.Text := P.List.Selected.SubItems[2];
      s := P.List.Selected.SubItems[3];
      k := pos('/', s);
      edKarl.Text := copy(s, 1, k-1);
      delete(s, 1, k);
      edOvsug.Text := trim(s);
    end;
  end;

  if EditMode in [pemNewLoad, pemNewRec] then begin
    dtDate.DateTime := now;
    dtTime.DateTime := now;
  end;  

  flag := EditMode in [pemNewLoad, pemEditCP];
  cmbProdName.Enabled := flag;
  cmbPostav.Enabled := flag;
  flag := EditMode in [pemNewLoad, pemNewRec, pemEditRec];
  InfoPanel.Visible := flag;
  dtDate.Enabled := flag;
  dtTime.Enabled := flag;
  edWes.Enabled := flag;
  edWet.Enabled := flag;
  edKley.Enabled := flag;
  edKarl.Enabled := flag;
  edOvsug.Enabled := flag;

  cmbProdName.ItemIndex := 0;
  cmbPostav.ItemIndex := 0;

  ShowModal;
end;


procedure TProdEditForm.cmbProdNameDropDown(Sender: TObject);
var
  Tbl: TSimpleTableForm;
begin
  cmbProdName.DroppedDown := false;

  Tbl := TSimpleTableForm.Create(self);
  Tbl.Left := Left + 106;
  Tbl.Top := Top  + 21 + (sender as TComboBox).Top;
  Tbl.Width := (sender as TComboBox).Width;
  Tbl.qry := proddm.qryProd;
  
  Tbl.btAdd.Visible := proddm.AdminAccessLevel;
  Tbl.btDel.Visible := Tbl.btAdd.Visible;

  if Sender = cmbProdName then begin
    Tbl.fldId := 'IDCULT';
    Tbl.fldName := 'NAME';
    Tbl.tblName := 'CULTURA';
    Tbl.id := IdCult;
  end;

  if Sender = cmbPostav then begin
    Tbl.fldId := 'IDPOSTAV';
    Tbl.fldName := 'NAME';
    Tbl.tblName := 'POSTAVSHIK';
    Tbl.id := IdPostav;
  end;

  Tbl.ShowModal;

  if Tbl.id >= 0 then begin
    if Sender = cmbProdName then begin
      IdCult := Tbl.id;
      cmbProdName.Items[0] := Tbl.name_str;
    end;
    if Sender = cmbPostav then begin
      IdPostav := Tbl.id;
      cmbPostav.Items[0] := Tbl.name_str;
    end;
    cmbProdName.ItemIndex := 0;
    cmbPostav.ItemIndex := 0;
  end;

  Tbl.Free;
  Update;
end;

procedure RJustifyEdit(var ThisEdit : TObject);
var
 Left, Width : Integer;
 GString : String;
 Rgn : TRect;
 TheCanvas : TControlCanvas;
 T: TEdit;
begin
  T := ThisEdit as TEdit;
  T.SelLength := 0;
  T.Update;
  TheCanvas := TControlCanvas.Create;
  try
    TheCanvas.Control := T;
    TheCanvas.Font.Assign(T.Font);
    GString := T.Text;
    Rgn     := T.ClientRect;
    TheCanvas.FillRect(Rgn);
    Width   := TheCanvas.TextWidth(GString);
    Left := Rgn.Right - Width - 1;
    TheCanvas.TextRect(Rgn, Left, 0, GString);
  finally
    TheCanvas.Free;
  end ;
end;

procedure TProdEditForm.edEditExit(Sender: TObject);
begin
  RJustifyEdit(Sender);
end;

procedure TProdEditForm.FormActivate(Sender: TObject);
begin
  if cmbProdName.Enabled then
    cmbProdName.SetFocus
  else
    dtDate.SetFocus;

  edEditExit(edWes);
  edEditExit(edWet);
  edEditExit(edKley);
  edEditExit(edKarl);
  edEditExit(edOvsug);
end;

procedure TProdEditForm.edWesEnter(Sender: TObject);
begin
  (Sender as TEdit).Update;
end;

// 
procedure TProdEditForm.OkButtonClick(Sender: TObject);
var
  dt: TDateTime;
  i: integer;
  s: string;
begin
  if (IdCult < 0) or (IdPostav < 0) then begin
    ShowMessage('    !');
    exit;
  end;

  if MessageDlg('    ', mtConfirmation,
        mbOKCancel, 0) <> mrOk then exit;

  dt := dtDate.DateTime;
  ReplaceTime(dt, dtTime.DateTime);

  if (EditMode=pemNewLoad) or (EditMode=pemNewRec) then
    with p.List.Items.Add do begin
      Caption := FormatDateTime('yyyy.MM.dd hh:nn:ss', dt);
      Subitems.Add(edWes.Text);
      Subitems.Add(edWet.Text);
      Subitems.Add(edKley.Text);
      Subitems.Add(edKarl.Text + '/' + edOvsug.Text);
      Selected := true;
    end;

  if (EditMode=pemEditRec) then
    with p.List.Selected do begin
      Caption := FormatDateTime('yyyy.MM.dd hh:nn:ss', dt);
      Subitems[0] := edWes.Text;
      Subitems[1] := edWet.Text;
      Subitems[2] := edKley.Text;
      Subitems[3] := edKarl.Text + '/' + edOvsug.Text;
    end;

  try
    proddm.qryProd.Transaction.StartTransaction;

    if EditMode in [pemNewLoad] then begin
      proddm.qryProd.SQL.text :=
          'SELECT GEN_ID(GEN_PRODUCT_ID,1) AS ID FROM RDB$DATABASE';
      proddm.qryProd.ExecQuery;
      p.IdProd := proddm.qryProd.FieldByName('ID').AsInteger;
      proddm.qryProd.Close;

      proddm.qryProd.SQL.text :=
            'INSERT INTO PRODUCT (IDPROD, IDCULT, IDPOSTAV, IDOBJ, '+
            'DTLOAD, ARH) VALUES (' + IntToStr(P.IdProd) + ',' + IntToStr(IdCult) + ',' +
            IntToStr(IdPostav) + ','#39 + P.Id + #39','#39 +
            DateTimeToStr(now) + #39',0)';
      proddm.qryProd.ExecQuery;
      proddm.qryProd.Close;
    end;

    if EditMode in [pemEditCp] then begin
      proddm.qryProd.SQL.text := 'UPDATE PRODUCT SET '+
            'IDCULT='+IntToStr(IdCult) + ',' +
            'IDPOSTAV='+IntToStr(IdPostav) + ' ' +
            'WHERE IDPROD=' + inttostr(p.IdProd);
      proddm.qryProd.ExecQuery;
      proddm.qryProd.Close;
    end;

    proddm.qryProd.Transaction.Commit;

    if EditMode in [pemNewLoad, pemNewRec, pemEditRec] then p.SaveInfo;

    close;

    if Assigned(p.OnDataChanging) then p.OnDataChanging(nil, p.Id);
  except
    proddm.qryProd.Transaction.Active := false;
    MessageDlg('    !', mtError, [mbOK], 0);
  end;
end;



procedure TProdEditForm.btCancelClick(Sender: TObject);
begin
  close;
end;

end.
