unit SimpleTable;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, ComCtrls, 
  FIBQuery, pFIBQuery, FIBDatabase, pFIBDatabase, FIBDataSet, pFIBDataSet;

type
  TSimpleTableForm = class(TForm)
    Panel1: TPanel;
    btAdd: TBitBtn;
    btOk: TBitBtn;
    btDel: TBitBtn;
    btCancel: TBitBtn;
    Panel2: TPanel;
    List: TListView;
    procedure btCancelClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure btAddClick(Sender: TObject);
    procedure btEditClick(Sender: TObject);
    procedure btDelClick(Sender: TObject);
    procedure ListClick(Sender: TObject);
  private
    function CheckForDuplicating(s: string; id: integer): boolean;
  public
    EditMode: boolean;
//    ds: TpFIBDataSet;
    qry: TpFIBQuery;
    fldId, fldName, tblName: string;
    id: integer;
    name_str: string;
  end;


implementation
uses
  InputDialog;


{$R *.DFM}

procedure TSimpleTableForm.btCancelClick(Sender: TObject);
begin
  id := -1;
  Close;
end;

procedure TSimpleTableForm.FormActivate(Sender: TObject);
begin
  qry.SQL.text := 'SELECT * FROM ' + tblName + ' ORDER BY ' + fldName;
  try
    qry.Transaction.StartTransaction;
    qry.ExecQuery;

    List.Items.Clear;
    while not qry.eof do
      with List.Items.Add do begin
        Caption := qry.FieldByName(fldName).AsString;
        Data := pointer(qry.FieldByName(fldId).AsInteger);
        if integer(Data) = id then Selected := true;
        qry.Next;
      end;
    qry.Transaction.Commit;
  finally
    qry.Transaction.Active := false;
  end;

  List.SetFocus;
end;

procedure TSimpleTableForm.btOkClick(Sender: TObject);
begin
  if List.Selected <> nil then begin
    id := Integer(List.Selected.Data);
    name_str := List.Selected.Caption;
    close;
  end;
end;



function TSimpleTableForm.CheckForDuplicating(s: string; id: integer): boolean;
begin
  result := false;
  if s='' then begin
    ShowMessage('   - !');
    exit;
  end;
  
  try
    qry.SQL.text := 'SELECT count(*) FROM ' + tblName + ' WHERE ' +
            fldName + '='#39 + s + #39' AND ' +
            fldId + '<>' + inttostr(id);
    qry.Transaction.StartTransaction;
    qry.ExecQuery;
    result := qry.Fields[0].AsInteger = 0;
    qry.Transaction.Commit;
  except
    qry.Transaction.Active := false;
  end;

  if not Result then
    ShowMessage('   !');

end;


procedure TSimpleTableForm.btAddClick(Sender: TObject);
var
  s: string;
  i: integer;
begin
  s := '';
  if ShowInputDialog(' ', '', s) then begin
    s := trim(s);
    if not CheckForDuplicating(s, -1) then exit;

    qry.SQL.text := 'INSERT INTO ' + tblName + ' (' + fldName + ') VALUES (' +
            #39 + s + #39 + ')';
    try
      qry.Transaction.StartTransaction;
      qry.ExecQuery;
      qry.Transaction.Commit;
    except
      qry.Transaction.Active := false;
    end;

    FormActivate(nil);

    for i:=0 to List.Items.Count-1 do
      if List.Items[i].Caption = s then begin
        List.Items[i].Selected := true;
        break;
      end;
  end;

end;

procedure TSimpleTableForm.btEditClick(Sender: TObject);
var
  s: string;
begin
  if (List.Selected = nil) or (not btAdd.Visible) then exit;
  s := List.Selected.Caption;
  if ShowInputDialog(' ', '', s) then
    if not(s = List.Selected.Caption) then begin
      if not CheckForDuplicating(s, integer(List.Selected.Data)) then exit;

      qry.SQL.text := 'UPDATE ' + tblName + ' SET ' +
            fldName + '='#39 + s + #39' WHERE ' +
            fldId + '=' + inttostr(integer(List.Selected.Data));
      try      
        qry.Transaction.StartTransaction;
        qry.ExecQuery;
        qry.Transaction.Commit;
      except
        qry.Transaction.Active := false;
      end;

      List.Selected.Caption := s;
    end;
end;

procedure TSimpleTableForm.btDelClick(Sender: TObject);
begin
  if List.Selected = nil then exit;

  try
    qry.SQL.Text := 'DELETE FROM ' + tblName + ' WHERE ' +
            fldId + '=' + inttostr(integer(List.Selected.Data));
    if not qry.Transaction.Active then
      qry.Transaction.StartTransaction;
    qry.ExecQuery;
    qry.Transaction.Commit;
  except
    qry.Transaction.Active := false;
    MessageDlg('  , ..      ' +
          ' !', mtError, [mbOk], 0);
  end;
  
  FormActivate(nil);
end;

procedure TSimpleTableForm.ListClick(Sender: TObject);
begin
  if not btAdd.Visible then btOkClick(nil);
end;

end.
