unit Helper;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, OleCtrls, SHDocVw, Buttons, Menus;//, Htmlview;

type
  THelpForm = class(TForm)
    Panel1: TPanel;
    btClose: TButton;
    Panel3: TPanel;
    PopupMenu1: TPopupMenu;
    qqq1: TMenuItem;
    WebBrowser1: TWebBrowser;
    procedure btCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
//    HTMLViewer: THTMLViewer;
  end;

  procedure ShowHelpPage(url: string);
  procedure ShowCommonHelp(url: string);
  procedure ShowProjectHelp(url: string);

var
  HelpForm: THelpForm;

implementation
uses 
  RpVisualGlobal;

{$R *.DFM}

{ THelpForm }

procedure ShowHelpPage(url: string);
begin

  if FileExists(url) then begin
    if HelpForm=nil then HelpForm := THelpForm.Create(nil);
    HelpForm.WebBrowser1.Navigate(url);
    HelpForm.ShowModal;
    HelpForm.Free;
    HelpForm:=nil;
  end else
    ShowMessage('    !');

end;

procedure ShowProjectHelp(url: string);
begin
  ShowHelpPage(CurDir + 'Help\' + url);
end;

procedure ShowCommonHelp(url: string);
begin
  ShowHelpPage(HelpDirStd + url);
end;

procedure THelpForm.btCloseClick(Sender: TObject);
begin
  close;
end;


procedure THelpForm.FormCreate(Sender: TObject);
begin
//  HTMLViewer := THTMLViewer.
end;

end.
