unit RcpManFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls;

type
  TRcpManFrameForm = class(TForm)
    list: TListView;
    procedure listCustomDrawItem(Sender: TCustomListView; Item: TListItem;
      State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure listAdvancedCustomDrawSubItem(Sender: TCustomListView;
      Item: TListItem; SubItem: Integer; State: TCustomDrawState;
      Stage: TCustomDrawStage; var DefaultDraw: Boolean);
    procedure listClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RcpManFrameForm: TRcpManFrameForm;

implementation
uses
  RcpMan,
  RcpManFrameSetValue;

{$R *.dfm}

procedure TRcpManFrameForm.listCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
var
  r: TRect;
begin
  if Item.SubItems.Count=0 then begin
    r := Item.DisplayRect(drBounds);
    list.Canvas.Brush.Color := clBtnFace;
    list.Canvas.Font.Style := [fsBold];
    list.Canvas.FillRect(r);
    list.Canvas.TextRect(r, r.Left+3, r.Top, Item.Caption);
    DefaultDraw := false;
  end;
end;

procedure TRcpManFrameForm.listAdvancedCustomDrawSubItem(
  Sender: TCustomListView; Item: TListItem; SubItem: Integer;
  State: TCustomDrawState; Stage: TCustomDrawStage;
  var DefaultDraw: Boolean);
begin
  if SubItem<>1 then
    list.Canvas.Brush.Color := clWhite
  else
    if Item.SubItems[RCPMAN_CURRENT_VALUE]<>'0' then
      list.Canvas.Brush.Color := $00A4FFA4
    else
      list.Canvas.Brush.Color := clWhite;

end;

procedure TRcpManFrameForm.listClick(Sender: TObject);
var
  w: TRcpManFrameSetValueForm;
  i: integer;
begin
  if list.Selected=nil then exit;
  if list.Selected.SubItems.Count=0 then exit;

  w:= TRcpManFrameSetValueForm.Create(self);
  try
    for i:=RCPMAN_LIST_START to list.Selected.SubItems.Count-1 do
      with w.list.Items.Add do
        Caption := list.Selected.SubItems[i];
    w.list.Selected := w.list.items[strtoint(list.Selected.SubItems[RCPMAN_CURRENT_VALUE])];

    w.ShowModal;
    if w.value>=0 then begin
      list.Selected.SubItems[RCPMAN_CURRENT_VALUE] := inttostr(w.value);
      list.Selected.SubItems[RCPMAN_CURRENT_STR] := w.list.Selected.Caption;
      OnClick(nil); // HasChanges := true;
    end;
  finally
    w.Free;
  end;

end;


end.
