unit ReportProp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TReportPropForm = class(TForm)
    edFname: TEdit;
    Label1: TLabel;
    edDescr: TEdit;
    Label2: TLabel;
    Bevel1: TBevel;
    btDesign: TButton;
    btCancel: TButton;
    btOk: TButton;
    cmbDatabase: TComboBox;
    Label3: TLabel;
    procedure btDesignClick(Sender: TObject);
    procedure btOkClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure cmbDatabaseChange(Sender: TObject);
  private
    function _save: boolean;

  public
    database: string;
    repdir: string;
    EditMode: boolean;
  end;

var
  ReportPropForm: TReportPropForm;

implementation

uses
  infodlg,
  DataMod,
  RpVisualUtils;

{$R *.dfm}

procedure TReportPropForm.FormActivate(Sender: TObject);
var
  i,j: integer;
begin
  if EditMode then begin
    edFname.ReadOnly := true;
    edFname.Color := clBtnFace;
  end else begin
    edFname.ReadOnly := false;
    edFname.Color := clWindow;
  end;

  cmbDatabase.Clear;
  for i:=0 to Application.ComponentCount-1 do
    for j:=0 to Application.Components[i].ComponentCount-1 do
      if Application.Components[i].Components[j].ClassName = 'TpFIBDatabase' then begin
        cmbDatabase.Items.Add(Application.Components[i].Components[j].Name);
        if Application.Components[i].Components[j].Name = database then
          cmbDatabase.ItemIndex := cmbDatabase.Items.Count-1; 
      end;

end;

function TReportPropForm._save: boolean;
var
  fp3_name, fpd_name: string;
  F: Textfile;
begin
  result := false;
  edFname.Text := trim(edFname.Text);
  fp3_name := ChangeFileExt( repdir + edFname.Text, '.fr3' );
  fpd_name := ChangeFileExt( repdir + edFname.Text, '.frd' );

  if not editmode then begin
    if edFname.Text='' then begin
      edFname.SetFocus;
      exit;
    end;

    if FileExists(fp3_name) then
      if showInfoDlg('     . ?',
            mtConfirmation, [mbYes, mbNo], 0) <> mrYes then exit;

    dm.frxReport.Clear;
    dm.frxReport.SaveToFile(fp3_name);
  end;

  AssignFile(F, fpd_name);
  try
    rewrite(f);
    writeln(F,trim(edDescr.Text));
    writeln(F,trim(cmbDatabase.Text));
    closefile(F);
  except
  end;
  result := true;
end;

procedure TReportPropForm.btOkClick(Sender: TObject);
begin
  if _save then ModalResult := mrOk;
end;


procedure TReportPropForm.btDesignClick(Sender: TObject);
begin
  if not Editmode then
    if _save then begin
      EditMode := true;
      FormActivate(nil);
    end else
      exit;

  dm.frxFIBComponents.DefaultDatabase := GetpFIBDatabaseByName(cmbDatabase.Text);
  dm.frxReport.FileName := ChangeFileExt( repdir + edFname.Text, '.fr3' );
  dm.frxReport.LoadFromFile(dm.frxReport.FileName);
  dm.frxReport.DesignReport;
end;


procedure TReportPropForm.cmbDatabaseChange(Sender: TObject);
begin
  database := cmbDatabase.Text;
end;

end.
