unit ReportsEditor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons;

type
  TReportsEditorForm = class(TForm)
    list: TListView;
    rbStd: TRadioButton;
    rbPrj: TRadioButton;
    btAdd: TBitBtn;
    btDel: TBitBtn;
    btEdit: TBitBtn;
    btClose: TBitBtn;
    procedure rbStdClick(Sender: TObject);
    procedure btEditClick(Sender: TObject);
    procedure btAddClick(Sender: TObject);
    procedure btDelClick(Sender: TObject);
  private
    repdir: string;
  public
    procedure MakeFileList;
  end;

var
  ReportsEditorForm: TReportsEditorForm;

implementation
uses
  datamod,
  ReportProp,
  RpVisualGlobal;

{$R *.dfm}

{ TReportsEditorForm }

procedure TReportsEditorForm.MakeFileList;
var
  sr: TSearchRec;
  F: Textfile;
  s,s1,s2: string;
begin
  if rbStd.Checked then
    repdir := curdir + ReportDirStd
  else
    repdir := curdir + ReportDirPrj;

  list.Items.Clear;
  if FindFirst(repdir + '*.fr3', faAnyFile, sr) = 0 then repeat

    s := repdir + ChangeFileExt(sr.Name, '.frd');
    AssignFile(F, s);
    try
      s1 := '';
      s2 := '';
      if FileExists(s) then begin
        reset(f);
        readln(F,s1);
        readln(F,s2);
        closefile(F);
      end;
      with list.Items.Add do begin
        caption := sr.Name;
        Subitems.Add(s1);
        Subitems.Add(s2);
      end;
    except
    end;
  until FindNext(sr)<>0;
  FindClose(sr);

end;

procedure TReportsEditorForm.rbStdClick(Sender: TObject);
begin
  MakeFileList;
end;

procedure TReportsEditorForm.btEditClick(Sender: TObject);
var
  w: TReportPropForm;
  editmode: boolean;
begin
  editmode := sender <> btAdd;

  if editmode then
    if list.Selected = nil then exit;

  w := TReportPropForm.create(Self);
  try
    w.repdir := repdir;
    w.editmode := editmode;
    if editmode then begin
      w.edFname.Text := list.Selected.Caption;
      w.edDescr.Text := list.Selected.SubItems[0];
      w.database := list.Selected.SubItems[1];
    end else begin
      w.edFname.Text := '';
      w.edDescr.Text := '';
      w.database := '';
    end;
    if w.ShowModal = mrOk then begin
      if not editmode then begin
        list.Selected := list.Items.Add;
        list.Selected.SubItems.Add('');
        list.Selected.SubItems.Add('');
      end;

      list.Selected.Caption := w.edFname.Text;
      list.Selected.SubItems[0] := w.edDescr.Text;
      list.Selected.SubItems[1] := w.Database;
    end;
  finally
    w.Free;
  end;

end;

procedure TReportsEditorForm.btAddClick(Sender: TObject);
begin
  if rbStd.Checked then begin
    rbPrj.Checked := true;
    MakeFileList;
  end;
  btEditClick(sender);
end;

procedure TReportsEditorForm.btDelClick(Sender: TObject);
begin
  if rbStd.Checked then exit;
  if list.Selected = nil then exit;
  DeleteFile(repdir + list.Selected.Caption);
  DeleteFile(repdir + ChangeFileExt(list.Selected.Caption, '.frd'));
  list.Selected.delete;
end;

end.
