unit RpVisualCmdline;

interface
  function findCmdlineParam(param: string): Boolean;
  function getCmdlineArgInt: Integer;
  function getCmdlineArgString: string;

implementation

uses SysUtils;
var
  curarg: string;

function findCmdlineParam(param: string): Boolean;
var
  i: Integer;
  s: string;
begin
  Result := false;
  param := trim(UpperCase(param));
  for i:=1 to ParamCount do begin
    s := trim(ParamStr(i));
    result := Copy( UpperCase(s), 1, Length(param)) = param;
    if Result then begin
      if Length(s) > Length(param) then begin
        Delete(s, 1, Length(param)+1);
        curarg := s;
      end else begin
        curarg := '';
      end;
      break;
    end;
  end;
end;

function getCmdlineArgInt: Integer;
var
  v,i: Integer;
begin
  Val(curarg, v, i);
  Result := v;
end;

function getCmdlineArgString: string;
begin
  Result := curarg;
end;


end.
