unit RpVisualGlobal;

interface
uses
  Registry,
  hyperstr,
  Windows,
  classes;

const
  ReportDirPrj = 'reports\';

  {Visual Device Scaning Modes}
  dsmAll = 0;
  dsmOnlyVisible = 1;

  ExtMode_password = 'EXTMODEADMIN';
  ExtMode_password1 = '20231';
  AdminMode_password = 'VISSCADAADMIN';

  mainFormColor = $00464646;

var
  RpVisualIniFile: String = 'rpvisual.ini';
  VisImagesPath: string;
  VisScadaDirStd: string;
  ReportDirStd: string;
  HelpDirStd: string;
  CurDir: string;

  rvgLogIn: boolean;
  rvgPrjOnTimerEnabled: Boolean = false;
  SuperMasterMode: boolean;
  ReadOnlyMode: boolean = false;
  MessageBarFlashingEnabled: boolean;
  databaseDisabled: Boolean = False;

  debugTagNotFoundHint: boolean = false;

  noIniSave: boolean = False;
  silentShutdown: boolean = false;
  autoConfim: boolean = false;
  AdminMode_On: boolean;
  AdminMode_Channel: boolean;
  ExtMode_On: boolean;
  keybuffer: string;
  
  searchWind, rezwind : HWND;
  Pid, Tid : Cardinal;



  FindObjectBlinkingDuration: integer = 10;
  FindObjectFilter: string;
  FindObjectClass: TClass;
  FindObjectResult: Boolean;
  FindObjectList: TStringList;

  FirstPass: Boolean = true;

  DBUser: string;
  DBPass: string;
  DBNameTag: string;
  DBNameMes: string;
//  modeUsersControl: Boolean;

  scrollBarHint: boolean;
  scrollBarEnable: boolean;
  scrollBarPositionVert: Integer;
  scrollBarPositionHoriz: Integer;


  CurUserId: integer = 0;
  CurPlaceId: integer = 0;
  CurUserName: string = '';
  CurUserInfo: string = '';
  CurPlaceName: string = '';
  AutoLoginUserName: string ='';

  DataClientProtocol: Integer;

  adminTagFilter: string;
  adminAndFilter: string;

  useMesloggingV2: Boolean;
  filterPlaceNames: string;
  filterPlaceIds: string;

  //         MCHB
  //   = false -   _PrjProcs._PrjStartAlarmBtnInputTagName
  //   = true -  MCHB.Control/CtrlBeep
  modeMchbCtrlBeep: boolean = false;

  pageFilterStr: string = '';
  pageFilterMode: integer = 0;

  canMessagePlaySound: boolean = false;
  messageSoundFileName: string = '';

  manualAccessIgnoreList: string = '';

  //      
  blinkingBadStatus: Boolean = false;



implementation

initialization

  with TRegistry.Create do
  try
    RootKey := HKEY_LOCAL_MACHINE;
    OpenKey('\Software\Promavtomatika\VisScada', false);
    VisScadaDirStd := (ReadString('VisScadaPath')) + '\';
    ReplaceS(VisScadaDirStd, '\\', '\');

    if VisScadaDirStd='\' then
      VisScadaDirStd:='d:\asutp\visscada\';

    VisImagesPath  := VisScadaDirStd + 'Images\';
    ReportDirStd   := VisScadaDirStd + 'Reports\';
    HelpDirStd     := VisScadaDirStd + 'Help\';
  finally
    Free;
  end;

  FindObjectList := TStringList.Create;

finalization
  FindObjectList.Free;

end.
