unit RpVisualIni;

interface
  procedure loadRpVisualIni;
  procedure saveRpVisualIni;

  procedure saveMainFormPositionIni;

  procedure loadLastUserIdIni;
  procedure saveLastUserIdIni;

  procedure loadTrendPropIni(id: string; var Ymin: Double; var Ymax: double);
  procedure saveTrendPropIni(id: string; Ymin, ymax: double);

  procedure saveAdminIni;

implementation
uses
  IniFiles,
  main,
  forms,
  SysUtils,
  RpVisualGlobal,
  RpVisualUtils;

procedure loadRpVisualIni;
begin
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    Form1.Left := ReadInteger('Form1', 'Left', 0);
    Form1.Top := ReadInteger('Form1', 'Top', 0);
    Form1.Width := ReadInteger('Form1', 'Width', 1024);
    Form1.Height := ReadInteger('Form1', 'Height', 768);

    Form1.BorderStyle := TFormBorderStyle( ReadInteger('Form1', 'BorderStyle', integer(bsNone)));
    Form1.WindowState := TWindowState(ReadInteger('Form1', 'WindowState', integer(wsMaximized)));

    scrollBarEnable := ReadInteger('Form1', 'ScrollBarsEnable', 0) = 1;
    scrollBarHint := ReadBool('Form1', 'ScrollBarHint', false);
    scrollBarPositionVert := ReadInteger('Form1', 'ScrollBarVert', 0);
    scrollBarPositionHoriz := ReadInteger('Form1', 'ScrollBarHoriz', 0);

    databaseDisabled := ReadBool('Database', 'Disabled', false);
    DBNameTag := ReadString('Database', 'TagArcPath', '');
    DBNameMes := ReadString('Database', 'MesArcPath', '');
    DBUser := ReadString('Database', 'DBUser', 'SYSDBA');
    DBPass := ReadString('Database', 'DBPass', 'masterkey');
//    modeUsersControl := ReadBool('Database', 'UsersControl', true);

    SuperMasterMode := ReadBool('Main', 'SuperMasterMode', true);
    ReadOnlyMode := ReadBool('Main', 'ReadOnlyMode', false);
    MessageBarFlashingEnabled := ReadBool('Main', 'MessageBarFlashingEnabled', true);
    useMesloggingV2 := ReadBool('Main', 'MesloggingV2', false);
    adminTagFilter := ReadString('Main', 'adminTagFilter', '');
    adminAndFilter := ReadString('Main', 'adminAndFilter', '');
    VisImagesPath := tailBackSlash( Trim(ReadString('Main', 'ImagesPath', VisImagesPath)) );
    CurPlaceName := ReadString('Main', 'Place', '');
    filterPlaceNames := ReadString('Main', 'FilterPlaceNames', '');

    pageFilterStr := ReadString('Main', 'pageFilterStr', '');
    pageFilterMode := ReadInteger('Main', 'pageFilterMode', 0);

    DataClientProtocol := ReadInteger('RPVISUAL', 'DataClientProtocol', 0);

    canMessagePlaySound := ReadBool('Main', 'canMessagePlaySound', true);
    messageSoundFileName := ReadString('Main', 'messageSoundFileName', '..\sounds\alarm.wav');

    blinkingBadStatus := ReadBool('Main', 'blinkingBadStatus', false);

  finally
    Free;
  end;
end;

procedure saveRpVisualIni;
begin
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    WriteInteger('Form1', 'BorderStyle', Integer(Form1.BorderStyle));
    WriteInteger('Form1', 'WindowState', Integer(Form1.WindowState));
    writeBool('Form1', 'ScrollbarsEnable', scrollBarEnable);
    writeBool('Form1', 'ScrollbarHint', scrollBarHint);
    writeInteger('Form1', 'ScrollbarVert', scrollBarPositionVert);
    writeInteger('Form1', 'ScrollbarHoriz', scrollBarPositionHoriz);

    WriteString('Database', 'TagArcPath', DBNameTag);
    WriteString('Database', 'MesArcPath', DBNameMes);
    WriteString('Database', 'DBUser', DBUser);
    WriteString('Database', 'DBPass', DBPass);
    WriteBool('Database', 'Disabled', databaseDisabled);

    WriteBool('Main', 'MessageBarFlashingEnabled', MessageBarFlashingEnabled);
    WriteBool('Main', 'ReadOnlyMode', ReadOnlyMode);
    writeBool('Main', 'SuperMasterMode', SuperMasterMode);
    writeBool('Main', 'MesloggingV2', useMesloggingV2);
    writeString('Main', 'ImagesPath', VisImagesPath);
    writeString('Main', 'Place', CurPlaceName);
    writeString('Main', 'FilterPlaceNames', filterPlaceNames);

    writeString('Main', 'pageFilterStr', pageFilterStr);
    writeInteger('Main', 'pageFilterMode', pageFilterMode);

    writeInteger('RPVISUAL', 'DataClientProtocol', DataClientProtocol);

    writeBool('Main', 'canMessagePlaySound', canMessagePlaySound);
    writeString('Main', 'messageSoundFileName', messageSoundFileName);

    writeBool('Main', 'blinkingBadStatus', blinkingBadStatus);
  finally
    Free;
  end;
end;

procedure saveMainFormPositionIni;
begin
  if noIniSave then Exit;
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    WriteInteger('Form1', 'Left', Form1.Left);
    WriteInteger('Form1', 'Top', Form1.Top);
    WriteInteger('Form1', 'Width', Form1.Width);
    WriteInteger('Form1', 'Height', Form1.Height);
  finally
    Free;
  end;
end;

procedure loadLastUserIdIni;
begin
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    CurUserId := ReadInteger('Database', 'LastUserId', -1);
  finally
    Free;
  end;
end;

procedure saveLastUserIdIni;
begin
  if noIniSave then Exit;
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    WriteInteger('Database', 'LastUserId', CurUserId);
  finally
    Free;
  end;
end;


procedure loadTrendPropIni(id: string; var Ymin: Double; var Ymax: double);
begin
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    Ymin := ReadFloat('Trends', 'Trend_'+id+'_Ymin', -5.0);
    Ymax := ReadFloat('Trends', 'Trend_'+id+'_Ymax', 100.0);
  finally
    Free;
  end;
end;

procedure saveTrendPropIni(id: string; Ymin, ymax: double);
begin
  if noIniSave then Exit;
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    WriteFloat('Trends', 'Trend_'+id+'_Ymin', Ymin);
    WriteFloat('Trends', 'Trend_'+id+'_Ymax', Ymax);
  finally
    Free;
  end
end;


procedure saveAdminIni;
begin
  if noIniSave then Exit;
  with TIniFile.Create(CurDir + RpVisualIniFile) do try
    WriteString('Main', 'adminTagFilter', adminTagFilter);
    WriteString('Main', 'adminAndFilter', adminAndFilter);
  finally
    Free;
  end
end;


end.
