//{$I RPVISUAL.INC}

unit RpVisualLegacyPanels;

interface
uses
  controls,
  classes,
  main,
  windows,
  forms,
  ComCtrls,
  scadabase;

  procedure _VisualDeviceClick(Sender: TObject);

implementation

uses
  RpVisualUtils,

//{$IFDEF CtrlPanelMainForm)}
//  CtrlPanelMain,
//{$ENDIF}

//{$IFDEF CtrlPanelMachForm)}
  CtrlPanelMach, VisMachine,
//{$ENDIF}

//{$IFDEF CtrlPanelZdvaForm)}
  CtrlPanelZdva, VisZdva,
//{$ENDIF}

//{$IFDEF CtrlPanelZdvbForm)}
  CtrlPanelZdvb, VisZdvb,
//{$ENDIF}

//{$IFDEF CtrlPanelZdvhForm)}
  CtrlPanelZdvh, VisZdvh,
//{$ENDIF}

//{$IFDEF CtrlPanelZdvcForm)}
  CtrlPanelZdvc, VisZDVC,
//{$ENDIF}

//{$IFDEF CtrlPanelZdvrForm)}
  CtrlPanelZdvr, VisZDVR,
//{$ENDIF}

//{$IFDEF CtrlPanelD1Form)}
  CtrlPanelD1, VisStatusShape,
//{$ENDIF}

//{$IFDEF CtrlPanelZdvtForm)}
  CtrlPanelZdvt, VisZdvt,
//{$ENDIF}

//{$IFDEF CtrlPanelMchaForm }
  CtrlPanelMcha, VisMcha,
//{$ENDIF}

//{$IFDEF CtrlPanelMchbForm }
  CtrlPanelMchb, VisMchb,
//{$ENDIF}

//{$IFDEF CtrlPanelDltaForm }
  CtrlPanelDlta, VisDlta,
//{$ENDIF}

//{$IFDEF CtrlPanelWesAkkontForm }
//  CtrlPanelWesAkkont, VisDynamicPict,
//{$ENDIF}

//{$IFDEF CtrlPanelDltbForm }
  CtrlPanelDltb, VisDltb,
//{$ENDIF}

//{$IFDEF CtrlPanelVspaForm }
  CtrlPanelVspa, VisVespA,
//{$ENDIF}

//{$IFDEF CtrlPanelVspcForm }
  CtrlPanelVspc, VisVespC,
//{$ENDIF}

  sidebar,
  SysUtils,
  Connecting,
  MesLogging,
  inifiles,
  users,
  dialogs,
  tagstorage,
  MesMonitor,
  MesView,
  AdminMain,
  menus,
  rpMessages,
  Graphics,
  datamod,
  TagViewer,
  ArcViewer,
  numbers,
  RpVisualGlobal,
  controlpanel,
  rpTcpClientGlobals,
  rpVisualMain;




////////////////////////////////////////////////////////////////////////////////
//    
procedure _VisualDeviceClick(Sender: TObject);

  procedure Make(InstanceClass: TComponentClass; var Reference);
  begin
    if pointer(Reference)=nil then Application.CreateForm(InstanceClass, Reference);
  end;

  procedure Kill(var frm: pointer);
  begin
    if frm<>nil then begin
      with TObject(frm) do Free;
      frm := nil;
    end;
  end;

begin
  if not rvgLogIn then exit;

  if Sender is TCustomScadaObject then begin
    _ShowLostTags(Sender as TCustomScadaObject);

    if showSidebar( TCustomScadaObject(sender) ) then
      Exit;
  end;

//{$IFDEF CtrlPanelMachForm)}
  //     VisMachine
  if (Sender as TComponent).ClassName = 'TVisMachine' then begin
    make( TCtrlPanelMachForm, CtrlPanelMachForm);
    CtrlPanelMachForm.M := TVisMachine(Sender);
    OpenControlPanel(TForm(CtrlPanelMachForm));
  end else
    Kill(pointer( CtrlPanelMachForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelD1Form)}
  //     
  if (Sender as TComponent).ClassName = 'TVisStatusShape' then begin
    make( TCtrlPanelD1Form, CtrlPanelD1Form);
    with Sender as TVisStatusShape do begin
      CtrlPanelD1Form.TagPath := TagPath;
      CtrlPanelD1Form.TagName := TagInfo;
      CtrlPanelD1Form.DatName := Hint;
      CtrlPanelD1Form.Flashing := Flashing;
    end;
    OpenControlPanel(TForm(CtrlPanelD1Form));
  end else
    Kill(pointer( CtrlPanelD1Form ));
//{$ENDIF}

//{$IFDEF CtrlPanelZdvrForm)}
  //      ZDVR
  if (Sender as TComponent).ClassName = 'TVisZDVR' then begin
    make( TCtrlPanelZdvrForm, CtrlPanelZdvrForm);
    with Sender as TVisZDVR do begin
      CtrlPanelZdvrForm.TagName := TagName;
      CtrlPanelZdvrForm.TagPath := TagPath;
      CtrlPanelZdvrForm.DeviceName := DeviceName;
    end;
    OpenControlPanel(TForm(CtrlPanelZdvrForm));
  end else
    Kill(pointer( CtrlPanelZdvrForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelZdvcForm)}
  //     
  if (Sender as TComponent).ClassName = 'TVisZDVC' then begin
    make( TCtrlPanelZdvcForm, CtrlPanelZdvcForm);
    with Sender as TVisZDVC do begin
      CtrlPanelZdvcForm.TagName := TagName;
      CtrlPanelZdvcForm.TagPath := TagPath;                     
      CtrlPanelZdvcForm.DeviceName := DeviceName;
    end;
    OpenControlPanel(TForm(CtrlPanelZdvcForm));
  end else
    Kill(pointer( CtrlPanelZdvcForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelZdvhForm)}
  //     TVisZdvh
  if (Sender as TComponent).ClassName = 'TVisZDVH' then begin
    make( TCtrlPanelZdvhForm, CtrlPanelZdvhForm);
    CtrlPanelZdvhForm.M := TVisZdvh(Sender);
    OpenControlPanel(TForm(CtrlPanelZdvhForm));
  end else
    Kill(pointer( CtrlPanelZdvhForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelZdvaForm)}
  //     TVisZdva
  if (Sender as TComponent).ClassName = 'TVisZDVA' then begin
    make( TCtrlPanelZdvaForm, CtrlPanelZdvaForm);
    CtrlPanelZdvaForm.M := TVisZdva(Sender);
//    ShowControlPanel(CtrlPanelZdvaForm);
    OpenControlPanel(TForm(CtrlPanelZdvaForm));
  end else
    Kill(pointer( CtrlPanelZdvaForm ));
//{$ENDIF}


//{$IFDEF CtrlPanelZdvbForm)}
  //     TVisZdva
  if (Sender as TComponent).ClassName = 'TVisZDVB' then begin
    make( TCtrlPanelZdvbForm, CtrlPanelZdvbForm);
    CtrlPanelZdvbForm.M := TVisZdvb(Sender);
    OpenControlPanel(TForm(CtrlPanelZdvbForm));
  end else
    Kill(pointer( CtrlPanelZdvbForm ));
//{$ENDIF}


//{$IFDEF CtrlPanelZdvtForm)}
  //     TVisZdvt
  if (Sender as TComponent).ClassName = 'TVisZDVT' then begin
    make( TCtrlPanelZdvtForm, CtrlPanelZdvtForm);
    CtrlPanelZdvtForm.M := TVisZdvt(Sender);
    OpenControlPanel(TForm(CtrlPanelZdvtForm));
  end else
    Kill(pointer( CtrlPanelZdvtForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelMchaForm }
  //     TVisMcha
  if (Sender as TComponent).ClassName = 'TVisMcha' then begin
    make(TCtrlPanelMchaForm, CtrlPanelMchaForm);
    CtrlPanelMchaForm.M := TVisMcha(Sender);
    OpenControlPanel(TForm(CtrlPanelMchaForm));
  end else
    kill(pointer( CtrlPanelMchaForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelMchbForm }
  //     TVisMchb
  if (Sender as TComponent).ClassName = 'TVisMchb' then begin
    make(TCtrlPanelMchbForm, CtrlPanelMchbForm);
    CtrlPanelMchbForm.M := TVisMchb(Sender);
    OpenControlPanel(TForm(CtrlPanelMchbForm));
  end else
    kill(pointer( CtrlPanelMchbForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelDltaForm }
  //     TVisDlta
  if (Sender as TComponent).ClassName = 'TVisDltA' then begin
    make(TCtrlPanelDltaForm, CtrlPanelDltaForm);
    CtrlPanelDltaForm.M := TVisDlta(Sender);
    OpenControlPanel(TForm(CtrlPanelDltaForm));
  end else
    kill(pointer( CtrlPanelDltaForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelWesAkkontForm }
//  //     TCtrlPanelWesAkkont
//  if ((Sender as TComponent).ClassName = 'TVisDynamicPict')
//        and (pos('Akkont',(Sender as TComponent).Name)>0) then begin
//    make(TCtrlPanelWesAkkontForm, CtrlPanelWesAkkontForm);
//    CtrlPanelWesAkkontForm.M := TVisDynamicPict(Sender);
//    ShowControlPanel(CtrlPanelWesAkkontForm);
//  end else
//    kill(pointer( CtrlPanelWesAkkontForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelDltbForm }
  //     TVisDltb
  if (Sender as TComponent).ClassName = 'TVisDltB' then begin
    make(TCtrlPanelDltbForm, CtrlPanelDltbForm);
    CtrlPanelDltbForm.M := TVisDltb(Sender);
    OpenControlPanel(TForm(CtrlPanelDltbForm));
  end else
    kill(pointer( CtrlPanelDltbForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelVspaForm }
  //     TVisVspa
  if (Sender as TComponent).ClassName = 'TVisVespA' then begin
    make(TCtrlPanelVspaForm, CtrlPanelVspaForm);
    CtrlPanelVspaForm.M := TVisVespA(Sender);
    OpenControlPanel(TForm(CtrlPanelVspaForm));
  end else
    kill(pointer( CtrlPanelVspaForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelVspcForm }
  //     TVisVspc
  if (Sender as TComponent).ClassName = 'TVisVespC' then begin
    make(TCtrlPanelVspcForm, CtrlPanelVspcForm);
    CtrlPanelVspcForm.M := TVisVespC(Sender);
    OpenControlPanel(TForm(CtrlPanelVspcForm));
  end else
    kill(pointer( CtrlPanelVspcForm ));
//{$ENDIF}

//{$IFDEF CtrlPanelMainForm)}
//  //    
//  if (Sender = Form1.MainPanelButton) or (TComponent(Sender).Name = 'btMarshrutControl') then begin
//    make(TCtrlPanelMainForm, CtrlPanelMainForm);
//    ShowControlPanel(CtrlPanelMainForm);
//  end else
//    Kill(pointer( CtrlPanelMainForm ));
//{$ENDIF}

end;




end.
