unit RpVisualMain;

interface
uses
  hyperstr,
  controls,
  classes,
  windows,
  Messages,
  forms,
  ComCtrls,
  scadabase,
  AdvPageControl,
  pFIBDatabase,
  Graphics,
  Math;


  procedure _FormCreate(Sender: TObject);
  procedure _FormActivate(Sender: TObject);
  procedure updateMainFormButtons;
  procedure _ConnectButtonClick(Sender: TObject);
  procedure _DisconnectButtonClick(Sender: TObject);
  procedure _LockButtonClick(Sender: TObject);
  procedure _FormDestroy(Sender: TObject);
  procedure _FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  procedure _ScreenTimerTimer(Sender: TObject);
  procedure _PanelMesTextClick(Sender: TObject);
  procedure _MesMonitorButtonClick(Sender: TObject);
  procedure _MesViewButtonClick(Sender: TObject);
  procedure _PageControlChange(Sender: TObject);
  procedure _TabSheetClick;
  procedure _TabSheetMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  procedure _SetupButtonClick(Sender: TObject);
  procedure _GotoMenuItemClick(Sender: TObject);
  procedure _ScadaObjectClick(Sender: TObject; obj: TCustomScadaObject; var frm: TForm);
  procedure _ShowLostTags(obj: TCustomScadaObject);
  procedure _btTrendViewerClick(Sender: TObject);
  procedure _btArcViewerClick(Sender: TObject);
  procedure _FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);

  procedure _FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
  procedure _ScrollBarChange(Sender: TObject);
  procedure SaveDragPosition;
  procedure initScrollBars;
  procedure setupScrollbarsByRealPos;

  procedure _mnFindScadaObjectClick(Sender: TObject);

  function  _AddFormToWinControl(prnt: TWinControl; cls: TFormClass; var frm: TForm ): boolean;
  procedure _AddFormToPageControl( cls: TFormClass; var frm: TForm; name: string);
  procedure _WritelnAdminLog(s: string);
  procedure _ch_tr(tagpath, sys_name: string; d,m,g: integer);
  procedure _SaveMessageScadaObject(Sender: TObject; mesText: string; BckgColor: Integer = clLime; FontColor: integer = clBlack);
  procedure _StopAlarmBeepClick(Sender: TObject);
  procedure _btWesClientClick(Sender: TObject);
  procedure _btMotohrClick(Sender: TObject);




implementation

uses
  MotohrView,
  RpVisualParams,
  infodlg,
  InputDialog,
  VisLabel,
  SetChannel,
  RpVisualCmdline,
  RpVisualIni,
  main,
  Sidebar,
  NeedReconnectNotification,
  commondataboard,
  CriticalAlerts,
  UserControlEx,
  VisButton,
  VisComboBox,
  VisCheckBox,
  VisTrackBar,
  SysUtils,
  Connecting,
  MesLogging,
  users,
  dialogs,
  tagstorage,
  MesMonitor,
  MesView,
  AdminMain,
  menus,
  rpMessages,
  datamod,
  TagViewer,
  ArcViewer,
  numbers,
  RpVisualGlobal,
  RpVisualUtils,
  controlpanel,
  rpTcpClientGlobals,
  _PrjProcs,
  logger,
  DataClientConnectBad;


var
  mouseDownX,mouseDownY: integer;
  dragPosX,dragPosY: integer;
  scrollbarsOnChangeDisabled: boolean = false;
  pageCount: integer = 0;


procedure _FormCreate(Sender: TObject);
begin
  _WritelnAdminLog('[_FormCreate]');

  Form1.DoubleBuffered := true;

  if findCmdlineParam('-ini') then
    RpVisualIniFile := getCmdlineArgString();

  CurDir := ExtractFileDir(Application.ExeName) + '\';
  rpTcpClientTempDir := CurDir + 'Temp\';

  LoggerInit;

  ResetSecurityVars;

  Form1.PageControl.Align := alClient;
  Form1.PageControl.ActivePageIndex := 0;

  loadRpVisualIni;
  initDataClient;

  initScrollBars;

  _PrjInitForms;
  _PageControlChange(nil);

  Form1.lbLogo.Caption := rpVisualParams_Read('PrjLogoCaption', ' ', _PrjLogoCaption);


//  removeFilteredPages;
end;

procedure _FormActivate(Sender: TObject);
var
  i: integer;
begin
//  Form1.ScreenTimerTimer(nil);

  if not FirstPass then
    exit;

  if SetChannelForm = nil then
    SetChannelForm := TSetChannelForm.Create(Form1);

  if MesMonitorForm = nil then
    MesMonitorForm := TMesMonitorForm.Create(Form1);

  if MesViewForm = nil then
    MesViewForm := TMesViewForm.Create(Form1);



  if findCmdlineParam('-START') then begin
    AutoLoginUserName := getCmdlineArgString();
    form1.Update;
    Application.ProcessMessages;
    Sleep(1000);
    Application.ProcessMessages;
    form1.ConnectButton1Click(nil);
  end;

  if findCmdlineParam('-X') then
    Form1.Left := getCmdlineArgInt();

  if findCmdlineParam('-Y') then
    Form1.Top := getCmdlineArgInt();

  if findCmdlineParam('-SIZEX') then
    Form1.Width := getCmdlineArgInt();

  if findCmdlineParam('-SIZEY') then
    Form1.Height := getCmdlineArgInt();

  if findCmdlineParam('-SCREEN') then begin
    i := getCmdlineArgInt();
    if i < Form1.PageControl.PageCount then
      Form1.PageControl.ActivePageIndex := i;
  end;

  if findCmdlineParam('-NOINISAVE') then
    noIniSave := true;

  if findCmdlineParam('-SSHUTDOWN') then
    silentShutdown := true;

  if findCmdlineParam('-AUTOCONFIRM') then
    autoConfim := true;

  FirstPass := false;
end;


procedure updateMainFormButtons;
begin
  Form1.ConnectButton.Enabled := not rvgLogin;
  Form1.DisConnectButton.Enabled := rvgLogin;
  Form1.LockButton.Enabled := (rvgLogin) and (isMesloggingConnected);
  Form1.MesViewButton.Enabled := (rvgLogin) and (isMesloggingConnected);
  Form1.MesMonButton.Enabled := (rvgLogin) and (isMesloggingConnected);
  Form1.ExitButton.Enabled := not rvgLogIn;
  Form1.btTrendViewer.Enabled := (rvgLogin) and (isTagloggingConnected);
  Form1.btArcViewer.Enabled := (rvgLogin) and (isTagloggingConnected);
end;


////////////////////////////////////////////////////////////////////////////////
//   
procedure _ConnectButtonClick(Sender: TObject);
begin
  _WritelnAdminLog('[_ConnectButtonClick]');

  if not Form1.ConnectButton.Enabled then exit;
  Form1.ConnectButton.Enabled := false;

  CurUserId := 0;
  CurUserName := AutoLoginUserName;
  ConnectSystem;

end;

////////////////////////////////////////////////////////////////////////////////
//   
procedure _DisconnectButtonClick(Sender: TObject);
begin
  _WritelnAdminLog('[_DisconnectButtonClick]');

  DisconnectSystem;

  ClearMesBar;
  LogoutUser;
end;



////////////////////////////////////////////////////////////////////////////////
//  / 
procedure _LockButtonClick(Sender: TObject);
begin
  if sender <> nil then begin
    if not modeUserEx then
      if showInfoDlg('  ?', mtConfirmation,
            [mbYes, mbNo], 0) <> mrYes then exit;
    LogoutUser;
    _WritelnAdminLog('[_LockButtonClick] Lock');
  end;

  if not LoginUser then begin
    _DisconnectButtonClick(nil);
  end else begin
    _PrjAfterStart;
  end;
end;


////////////////////////////////////////////////////////////////////////////////
//  
procedure _FormDestroy(Sender: TObject);
begin
  _WritelnAdminLog('[_FormDestroy]');
end;


////////////////////////////////////////////////////////////////////////////////
//    
procedure _FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := false;

  if silentShutdown then
    CanClose := True
  else
    CanClose := showInfoDlg(' ?', mtConfirmation, [mbYes, mbNo],
      0) = mrYes;

  if CanClose then begin
    DisconnectFromTagLogging;
    DisconnectFromDataClient;
    saveMainFormPositionIni;
  end;
end;


procedure _ScreenTimerTimer(Sender: TObject);
begin
  if not rvgLogin then exit;

  if not checkDataClientConnection then
    exit;

  checkTagloggingConnection;
  checkMesloggingConnection;

  ScanScadaObjects(dsmOnlyVisible, UpdateDeviceProc);

//  if autoConfim then begin
//    AcknoledgeMesAll;
//  end;

  UpdateMesLogging;
  updateSidebar;

  try
    processCriticalAlerts;
  except
  end;

  processReconnectNotification;
end;



////////////////////////////////////////////////////////////////////////////////
//    
procedure _MesMonitorButtonClick(Sender: TObject);
begin
//  if not CheckInversAccess(PREVILEG_ZAPRET_MES, false) then exit;
  if not CheckAccess(PREVILEG_ZAPRET_MES, false, true) then exit;

  showMesMonitor();
//  MesMonitorForm.ShowModal;
end;

////////////////////////////////////////////////////////////////////////////////
//   
procedure _MesViewButtonClick(Sender: TObject);
begin
  if not CheckAccess(PREVILEG_ZAPRET_MES, false, true) then exit;
  showMesView();
end;


////////////////////////////////////////////////////////////////////////////////
//   
procedure _PageControlChange(Sender: TObject);
begin
  _ScreenTimerTimer(nil);
  HideSidebar;
//  HideControlPanel;
  CloseControlPanel;

  if form1.PageControl.ActivePage.ComponentCount > 0 then
    if form1.PageControl.ActivePage.Components[0] is TForm then
      with form1.PageControl.ActivePage.Components[0] as TForm do begin
//        if Form1.ScrollBarVert.Visible then begin
//          Align := alNone;
//          Width := form1.ScrollBarHoriz.max;
//          Height := form1.ScrollBarVert.max;
//        end else
//          Align := alClient;

        if Assigned(OnActivate) then
          OnActivate(sender);
      end;


  setupScrollbarsByRealPos;
end;




////////////////////////////////////////////////////////////////////////////////
//      
procedure _TabSheetClick;
begin
  _TabSheetMouseDown(nil, mbLeft, [], 0, 0);
end;

procedure _TabSheetMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  HideSidebar;
//  HideControlPanel;
  CloseControlPanel;
  SaveDragPosition;
end;


////////////////////////////////////////////////////////////////////////////////
//     
procedure _SetupButtonClick(Sender: TObject);
begin

  if isModeUserEx then begin
    if not isPermitted('') then
      exit
    else
      AdminMode_On := true;
  end else begin
    if not SuperMasterMode then
      CheckAdminMode
    else
      AdminMode_On := true;
  end;

  if AdminMode_On then begin
    if AdminMainForm=nil then
      AdminMainForm := TAdminMainForm.Create(Form1);
      
    AdminMainForm.Show;
    AdminMainForm.WindowState := wsNormal;
  end;
end;


////////////////////////////////////////////////////////////////////////////////
//     
procedure _GotoMenuItemClick(Sender: TObject);
begin
  with Sender as TMenuItem do
    if MenuIndex < Form1.PageControl.PageCount then begin
      Form1.PageControl.ActivePageIndex := MenuIndex;
      _ScreenTimerTimer(nil);
    end;
end;


////////////////////////////////////////////////////////////////////////////////
//     
procedure _PanelMesTextClick(Sender: TObject);
begin
  if (not CheckAccess(PREVILEG_ZAPRET_MES, false, true)) and (not modeUserEx) then exit;
  AcknoledgeMes;
end;





////////////////////////////////////////////////////////////////////////////////
//
procedure _btTrendViewerClick(Sender: TObject);
begin
  if not isTagloggingConnected then exit;
  if not CheckAccess(PREVILEG_ZAPRET_GRAFIKOV, true, true) then exit;

  with TTagViewerForm.Create(form1) do begin
    Readonly := not CheckAccess(PREVILEG_ADMIN, false);
    db := dm.pFIBDbArc;
    fname := ChangeFileExt( Application.ExeName, '.tvc');
    Show;
    Init;
  end;
end;


////////////////////////////////////////////////////////////////////////////////
//
procedure _btArcViewerClick(Sender: TObject);
begin
  if not isTagloggingConnected then exit;
  if not CheckAccess(PREVILEG_ZAPRET_ARHIV, true, true) then exit;

  with TArcViewerForm.Create(form1) do begin
    Readonly := not CheckAccess(PREVILEG_ADMIN, false);
    db := dm.pFIBDbArc;
    fname := ChangeFileExt( Application.ExeName, '.avc');
    Show;
    Init;
  end;
end;

////////////////////////////////////////////////////////////////////////////////
//
procedure _FormMouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
var
  i: integer;
begin
  with Form1.PageControl do begin
    i:=ActivePageIndex;

    if WheelDelta<0 then begin
      repeat
        inc(i);
        if i < PageCount then
          if Pages[i].TabVisible then begin
            ActivePageIndex := i;
            break;
          end;
      until i>=PageCount;
      Handled := true;
    end;

    if WheelDelta>0 then begin
      repeat
        dec(i);
        if i >= 0 then
          if Pages[i].TabVisible then begin
            ActivePageIndex := i;
            break;
          end;
      until i<0;
      Handled := true;
    end;

  end;
  _PageControlChange(sender);
end;


////////////////////////////////////////////////////////////////////////////////
// ScrollBars
////////////////////////////////////////////////////////////////////////////////
procedure _FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
  lb: smallint;
begin
  lb := GetAsyncKeyState(VK_LBUTTON);
  if lb = -32768 then  begin
    with form1.ScrollBarHoriz do
      if Visible then
        Position := Math.Min(Max-PageSize, Math.Max(0,
              dragPosX + mouseDownX - Mouse.CursorPos.X));

    with form1.ScrollBarVert do
      if Visible then
        Position := Math.Min(Max-PageSize, Math.Max(0,
              dragPosY + mouseDownY - Mouse.CursorPos.Y));
  end;
end;

procedure SaveDragPosition;
begin
  mouseDownX := Mouse.CursorPos.X;
  mouseDownY := Mouse.CursorPos.Y;
  dragPosX := form1.ScrollBarHoriz.Position;
  dragPosY := form1.ScrollBarVert.Position;
end;


procedure initScrollBars;
begin
  Form1.ScrollBarVert.Visible := scrollBarEnable;
  Form1.ScrollBarHoriz.Visible := scrollBarEnable;

  if scrollBarEnable then begin

    with Form1.ScrollBarVert do begin
      PageSize := math.max(0, math.min(Max, Max - scrollBarPositionVert + 1));
      ShowHint := scrollBarHint;
      if PageSize >= Max then
        Visible := false;
    end;

    with Form1.ScrollBarHoriz do begin
      PageSize := math.max(0, math.min(Max, Max - scrollBarPositionHoriz + 1));
      ShowHint := scrollBarHint;
      if PageSize >= Max then
        Visible := false;
    end;
  end;
end;

procedure _ScrollBarChange(Sender: TObject);
begin
  if scrollbarsOnChangeDisabled then exit;
  with Form1 do begin
    PageControl.ActivePage.Controls[0].Top :=  - ScrollBarVert.Position;
    PageControl.ActivePage.Controls[0].Left :=  - ScrollBarHoriz.Position;
    ScrollBarVert.Hint := ' ' + inttostr(ScrollBarVert.Position);
    ScrollBarHoriz.Hint := ' ' + inttostr(ScrollBarHoriz.Position);
  end;
end;

procedure setupScrollbarsByRealPos;
begin
  with Form1 do begin
    scrollbarsOnChangeDisabled := true;
    ScrollBarVert.Position := - PageControl.ActivePage.Controls[0].Top;
    ScrollBarHoriz.Position := - PageControl.ActivePage.Controls[0].Left;
    scrollbarsOnChangeDisabled := false;
  end;
end;

////////////////////////////////////////////////////////////////////////////////
//   
////////////////////////////////////////////////////////////////////////////////
procedure FindObjectListProc(Device: TCustomScadaObject);
begin
  if (CheckFilter( Device.Hint, '*' + FindObjectFilter + '*' )) and (Device.Visible) then begin
    FindObjectList.AddObject(Device.Hint, Device);
  end;
end;

procedure _mnFindScadaObjectClick(Sender: TObject);
var
  i,j: integer;
  device: TCustomScadaObject;
begin
  if not ShowInputDialog(' ', '', FindObjectFilter) then
    exit;

  FindObjectList.Clear;

  CustomScanScadaObjects(Form1.PageControl.ActivePage, FindObjectListProc);
  if FindObjectList.Count = 0 then begin
    for i := 0 to Form1.PageControl.PageCount-1 do begin
      CustomScanScadaObjects(Form1.PageControl.Pages[i], FindObjectListProc);
      if FindObjectList.Count > 0 then begin
        Form1.PageControl.ActivePageIndex := i;
        Break;
      end;
    end;
  end;

  if FindObjectList.Count > 0 then begin
    for i:=1 to FindObjectBlinkingDuration do begin
      for j:=0 to FindObjectList.Count-1 do begin
        device := TCustomScadaObject(FindObjectList.Objects[j]);
        device.Visible := False;
      end;
      Form1.PageControl.ActivePage.Update;
      Application.ProcessMessages;
      Sleep(50);

      for j:=0 to FindObjectList.Count-1 do begin
        device := TCustomScadaObject(FindObjectList.Objects[j]);
        device.Visible := true;
      end;
      Form1.PageControl.ActivePage.Update;
      Application.ProcessMessages;
      Sleep(50);
      
    end;
  end;

  FindObjectList.Clear;
end;


////////////////////////////////////////////////////////////////////////////////
//     Form1.PageControl
////////////////////////////////////////////////////////////////////////////////
function _AddFormToWinControl(prnt: TWinControl; cls: TFormClass; var frm: TForm ): boolean;
begin
  result := false;
  if frm = nil then begin
//    frm := cls.Create(Form1);
    frm := cls.Create(prnt);
    result := true;
  end;
  frm.Parent := prnt;
  frm.Left := 0;
  frm.Top := 0;
  frm.Width := 2000;
  frm.Height := 1500;

  frm.BorderStyle := bsNone;
  frm.Show;
  if frm.HelpContext=1 then
    frm.Color := Form1.Color;

  frm.OnMouseMove := Form1.FormMouseMove;
  frm.OnMouseDown := Form1.FormMouseDown;
end;

procedure _AddFormToPageControl(cls: TFormClass; var frm: TForm; name: string);
var
  TabSheet: TAdvTabSheet;
  filter: string;
  found, enabled: boolean;
begin
  inc(pageCount);

  filter := trim(pageFilterStr);
  if filter <> '' then begin
    ReplaceS(filter, ' ', '');
    filter := ',' + filter + ',';
  end;

  enabled := true;

  if pageFilterStr <> '' then begin
    found := pos(','+inttostr(pageCount)+',', filter) > 0;
    if pageFilterMode = 0 then
      enabled := found
    else
      enabled := not found;
  end;

  if enabled then begin
    TabSheet := TAdvTabSheet.Create(Form1.PageControl);
    TabSheet.AdvPageControl := Form1.PageControl;
    TabSheet.Caption := ' ' + name + ' ';
    TabSheet.Hint := cls.ClassName;
    _AddFormToWinControl(TabSheet, cls, frm);
  end;

end;



procedure _WritelnAdminLog(s: string);
var
  F: TextFile;
begin
  try
    AssignFile(F, CurDir + 'rpvisual.log');
    if not FileExists(CurDir + 'rpvisual.log') then
      rewrite(F)
    else begin
      append(F);
    end;

    s := DateTimeToStr(now) + ':  ' + s;

    Writeln(F, s);
  finally
    try
       CloseFile(F);
     except
    end;
  end;
end;



procedure _ShowLostTags(obj: TCustomScadaObject);
begin
  if obj.LostTags<>'' then
    ShowMessage(' : '#13#10 + obj.LostTags);
end;


////////////////////////////////////////////////////////////////////////////////
//    
procedure _ScadaObjectClick(Sender: TObject; obj: TCustomScadaObject; var frm: TForm);
begin
  _ShowLostTags(obj);

  if showSidebar( obj ) then
      Exit;

  if frm <> nil then
    OpenControlPanel(frm);
end;


//   
// d -  + 100
// m -  + 200
// g -  + 300 - 2000
procedure _ch_tr(tagpath, sys_name: string; d,m,g: integer);
var
  dt_plc, dt_trial, dt_diff: TDatetime;
  Year, Month, Day: Word;
  s: string;
begin
  d:=d-100;
  m:=m-200;
  g:=g-300+2000;
  s := inttostr(d);
  s := s+'.';
  s := s + inttostr(m);
  s := s+'.';
  s := s + inttostr(g);

  dt_trial := StrToDate(s);
  Year := GetTagValueByName(tagpath + '.SYS_' + sys_name + '_Date_Year');
  Month := GetTagValueByName(tagpath + '.SYS_' + sys_name + '_Date_Month');
  Day := GetTagValueByName(tagpath + '.SYS_' + sys_name + '_Date_Day');

  if (Year<=0) or (Month<=0) or (Day<=0) or
     (Year>2100) or (Month>12) or (Day>31) then exit;

  dt_plc := EncodeDate(Year, Month, Day);

  dt_diff := dt_trial - dt_plc;

  if dt_diff<0 then begin
//    ShowMessage('      !');
    PostMessage(Form1.Handle, WM_FUCK_ALERT, 0, 0);

    _PrjBeforeStop;
    _DisconnectButtonClick(nil);
    _PrjAfterStop;
  end else

  if dt_diff<15 then
    PostMessage(Form1.Handle, WM_FUCK_ALERT, 1, trunc(dt_diff)+1);
//    ShowMessage('!         '+
//          inttostr(trunc(dt_diff)+1) + ' .');

end;

//      CustomScadaObject
//  :
//   1. sender  TCustomScadaObject
//   2. sender.hint      '<> - <>'
//   3. mesText -  '<>'.   ,   ' '
//
procedure _SaveMessageScadaObject(Sender: TObject; mesText: string; BckgColor: Integer = clLime; FontColor: integer = clBlack);
var
  s1,s2: string;
begin
  s1 := '';
  s2 := '';


  if sender is TCustomScadaObject  then
    with sender as TCustomScadaObject do begin
      s1 := get_clear_hint(Hint);
      s2 := trim(copy(s1, pos('-',s1)+1, length(s1)));
      s1 := trim(copy(s1, 1, pos('-',s1)-1));
    end;

  if sender is TVisCheckBox  then
    with sender as TVisCheckBox do begin
      if objCheckBox.Checked then
        s2 := s2 + ' = '
      else
        s2 := s2 + ' = ';
    end;

  if sender is TVisButton  then
    with sender as TVisButton do begin
//      s := mesText;
      mesText := s1;
      s1 := s2;
      if objButton.Down then
        s2 := CaptionDown
      else
        s2 := CaptionUp;
    end;

  if sender is TVisComboBox  then
      s2 := s2 + ' = ' + (sender as TVisComboBox).objComboBox.Text;

  if sender is TVisTrackBar  then
      s2 := s2 + ' = ' + (sender as TVisTrackBar).objTrackBar.Hint;


  if mesText = '' then
    mesText := ' ';

  SaveMessageText(mesText, s1, s2, BckgColor, FontColor );
end;


procedure _StopAlarmBeepClick(Sender: TObject);
begin
  SetTagValue((sender as TVisLabel).Tags[0].idx, 1);
  (sender as TVisLabel).Visible := false;
end;



procedure _btWesClientClick(Sender: TObject);
begin
  StartProgram(
    ' ',
    'wesclient',
    '..\WesClient\WesClient.exe',
    True,
    'wesclient'
  );
end;

procedure _btMotohrClick(Sender: TObject);
begin
  showMotohrView;
end;





end.
